/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.FormatNumber;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.Whitespace;

public abstract class IntegerValue
extends DecimalValue {
    private static long a = -9999L;
    private static long b = -9998L;
    private static long[] c = new long[]{533L, a, a, 536L, Long.MIN_VALUE, Long.MAX_VALUE, 537L, Integer.MIN_VALUE, Integer.MAX_VALUE, 538L, -32768L, 32767L, 539L, -128L, 127L, 540L, 0L, a, 541L, 1L, a, 534L, a, 0L, 535L, a, -1L, 542L, 0L, b, 543L, 0L, 0xFFFFFFFFL, 544L, 0L, 65535L, 545L, 0L, 255L};

    public static IntegerValue makeIntegerValue(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigIntegerValue.MAX_LONG) > 0 || bigInteger.compareTo(BigIntegerValue.MIN_LONG) < 0) {
            return new BigIntegerValue(bigInteger);
        }
        return Int64Value.makeIntegerValue(bigInteger.longValue());
    }

    public static ConversionResult makeIntegerValue(double d2) {
        if (Double.isNaN(d2)) {
            ValidationFailure validationFailure = new ValidationFailure("Cannot convert double NaN to an integer");
            validationFailure.setErrorCode("FOCA0002");
            return validationFailure;
        }
        if (Double.isInfinite(d2)) {
            ValidationFailure validationFailure = new ValidationFailure("Cannot convert double INF to an integer");
            validationFailure.setErrorCode("FOCA0002");
            return validationFailure;
        }
        if (d2 > 9.223372036854776E18 || d2 < -9.223372036854776E18) {
            double d3 = d2;
            if (d3 == Math.floor(d3)) {
                return new BigIntegerValue(FormatNumber.adjustToDecimal(d2, 2).toBigInteger());
            }
            return new BigIntegerValue(new BigDecimal(d2).toBigInteger());
        }
        return Int64Value.makeIntegerValue((long)d2);
    }

    public static ConversionResult makeIntegerValue(DoubleValue doubleValue) {
        double d2 = ((NumericValue)doubleValue).getDoubleValue();
        return IntegerValue.makeIntegerValue(d2);
    }

    public abstract ValidationFailure convertToSubType(BuiltInAtomicType var1, boolean var2);

    public abstract ValidationFailure validateAgainstSubType(BuiltInAtomicType var1);

    public static boolean checkRange(long l2, BuiltInAtomicType builtInAtomicType) {
        int n2 = builtInAtomicType.getFingerprint();
        for (int i2 = 0; i2 < c.length; i2 += 3) {
            if (c[i2] != (long)n2) continue;
            long l3 = c[i2 + 1];
            if (l3 != a && l2 < l3) {
                return false;
            }
            long l4 = c[i2 + 2];
            return l4 == a || l4 == b || l2 <= l4;
        }
        throw new IllegalArgumentException("No range information found for integer subtype " + builtInAtomicType.getDescription());
    }

    public static IntegerValue getMinInclusive(BuiltInAtomicType builtInAtomicType) {
        int n2 = builtInAtomicType.getFingerprint();
        for (int i2 = 0; i2 < c.length; i2 += 3) {
            if (c[i2] != (long)n2) continue;
            long l2 = c[i2 + 1];
            if (l2 == a) {
                return null;
            }
            return Int64Value.makeIntegerValue(l2);
        }
        return null;
    }

    public static IntegerValue getMaxInclusive(BuiltInAtomicType builtInAtomicType) {
        int n2 = builtInAtomicType.getFingerprint();
        for (int i2 = 0; i2 < c.length; i2 += 3) {
            if (c[i2] != (long)n2) continue;
            long l2 = c[i2 + 2];
            if (l2 == a) {
                return null;
            }
            if (l2 == b) {
                return IntegerValue.makeIntegerValue(BigIntegerValue.MAX_UNSIGNED_LONG);
            }
            return Int64Value.makeIntegerValue(l2);
        }
        return null;
    }

    public static boolean checkBigRange(BigInteger bigInteger, BuiltInAtomicType builtInAtomicType) {
        for (int i2 = 0; i2 < c.length; i2 += 3) {
            if (c[i2] != (long)builtInAtomicType.getFingerprint()) continue;
            long l2 = c[i2 + 1];
            if (l2 != a && BigInteger.valueOf(l2).compareTo(bigInteger) > 0) {
                return false;
            }
            long l3 = c[i2 + 2];
            if (l3 == a) {
                return true;
            }
            if (l3 == b) {
                return BigIntegerValue.MAX_UNSIGNED_LONG.compareTo(bigInteger) >= 0;
            }
            return BigInteger.valueOf(l3).compareTo(bigInteger) >= 0;
        }
        throw new IllegalArgumentException("No range information found for integer subtype " + builtInAtomicType.getDescription());
    }

    public static ConversionResult stringToInteger(CharSequence charSequence) {
        int n2;
        int n3 = charSequence.length();
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n3 && charSequence.charAt(n2) <= ' '; ++n2) {
        }
        while (n4 > n2 && charSequence.charAt(n4) <= ' ') {
            --n4;
        }
        if (n2 > n4) {
            return new ValidationFailure("Cannot convert zero-length string to an integer");
        }
        if (n4 - n2 < 16) {
            n3 = 0;
            long l2 = 0L;
            if (charSequence.charAt(n2) == '+') {
                ++n2;
            } else if (charSequence.charAt(n2) == '-') {
                n3 = 1;
                ++n2;
            }
            if (n2 > n4) {
                return new ValidationFailure("Cannot convert string " + Err.wrap(charSequence, 4) + " to integer: no digits after the sign");
            }
            while (n2 <= n4) {
                char c2;
                if ((c2 = charSequence.charAt(n2++)) >= '0' && c2 <= '9') {
                    l2 = 10L * l2 + (long)(c2 - 48);
                    continue;
                }
                return new ValidationFailure("Cannot convert string " + Err.wrap(charSequence, 4) + " to an integer");
            }
            return Int64Value.makeIntegerValue(n3 != 0 ? -l2 : l2);
        }
        try {
            CharSequence charSequence2 = Whitespace.trimWhitespace(charSequence);
            if (charSequence2.charAt(0) == '+') {
                charSequence2 = charSequence2.subSequence(1, charSequence2.length());
            }
            if (charSequence2.length() < 16) {
                return new Int64Value(Long.parseLong(charSequence2.toString()));
            }
            return new BigIntegerValue(new BigInteger(charSequence2.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return new ValidationFailure("Cannot convert string " + Err.wrap(charSequence, 4) + " to an integer");
        }
    }

    public static ValidationFailure castableAsInteger(CharSequence charSequence) {
        int n2 = (charSequence = Whitespace.trimWhitespace(charSequence)).length() - 1;
        if (n2 < 0) {
            return new ValidationFailure("Cannot convert empty string to an integer");
        }
        int n3 = 0;
        if (charSequence.charAt(0) == '+' || charSequence.charAt(0) == '-') {
            ++n3;
        }
        if (n3 > n2) {
            return new ValidationFailure("Cannot convert string " + Err.wrap(charSequence, 4) + " to integer: no digits after the sign");
        }
        while (n3 <= n2) {
            char c2;
            if ((c2 = charSequence.charAt(n3++)) >= '0' && c2 <= '9') continue;
            return new ValidationFailure("Cannot convert string " + Err.wrap(charSequence, 4) + " to an integer: contains a character that is not a digit");
        }
        return null;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.INTEGER;
    }

    @Override
    public abstract BigDecimal getDecimalValue();

    @Override
    public boolean isWholeNumber() {
        return true;
    }

    public abstract IntegerValue plus(IntegerValue var1);

    public abstract IntegerValue minus(IntegerValue var1);

    public abstract IntegerValue times(IntegerValue var1);

    public abstract NumericValue div(IntegerValue var1);

    public NumericValue div(IntegerValue object, Location location) {
        try {
            return this.div((IntegerValue)object);
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(location);
            throw object;
        }
    }

    public abstract IntegerValue mod(IntegerValue var1);

    public IntegerValue mod(IntegerValue object, Location location) {
        try {
            return this.mod((IntegerValue)object);
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(location);
            throw object;
        }
    }

    public abstract IntegerValue idiv(IntegerValue var1);

    public IntegerValue idiv(IntegerValue object, Location location) {
        try {
            return this.idiv((IntegerValue)object);
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(location);
            throw object;
        }
    }

    public abstract BigInteger asBigInteger();

    protected static int signum(int n2) {
        return n2 >> 31 | -n2 >>> 31;
    }

    @Override
    public boolean isIdentical(AtomicValue atomicValue) {
        return atomicValue instanceof IntegerValue && ((AtomicValue)this).equals(atomicValue);
    }
}

