/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Arrays;
import java.util.StringTokenizer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;

public class NestedIntegerValue
extends AtomicValue
implements Comparable,
AtomicMatchKey {
    public static NestedIntegerValue ONE = new NestedIntegerValue(new int[]{1});
    public static NestedIntegerValue TWO = new NestedIntegerValue(new int[]{2});
    private int[] a;

    public NestedIntegerValue(String string) {
        this.typeLabel = BuiltInAtomicType.STRING;
        NestedIntegerValue.parse(string);
    }

    public NestedIntegerValue(int[] nArray) {
        this.typeLabel = BuiltInAtomicType.STRING;
        this.a = nArray;
    }

    public static NestedIntegerValue parse(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int[] nArray = new int[stringTokenizer.countTokens()];
        try {
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new XPathException("Nested integer value has incorrect format: " + string);
        }
        return new NestedIntegerValue(nArray);
    }

    public NestedIntegerValue append(int n2) {
        int[] nArray = new int[this.a.length + 1];
        System.arraycopy(this.a, 0, nArray, 0, this.a.length);
        nArray[this.a.length] = n2;
        return new NestedIntegerValue(nArray);
    }

    public NestedIntegerValue getStem() {
        if (this.a.length == 0) {
            return null;
        }
        int[] nArray = new int[this.a.length - 1];
        System.arraycopy(this.a, 0, nArray, 0, nArray.length);
        return new NestedIntegerValue(nArray);
    }

    public int getDepth() {
        return this.a.length;
    }

    public int getLeaf() {
        if (this.a.length == 0) {
            return -1;
        }
        return this.a[this.a.length - 1];
    }

    @Override
    public Comparable getSchemaComparable() {
        return this;
    }

    @Override
    public AtomicMatchKey getXPathComparable(boolean bl2, StringCollator stringCollator, int n2) {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof NestedIntegerValue && Arrays.equals(this.a, ((NestedIntegerValue)object).a);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        NestedIntegerValue nestedIntegerValue = new NestedIntegerValue(this.a);
        new NestedIntegerValue(this.a).typeLabel = atomicType;
        return nestedIntegerValue;
    }

    @Override
    protected CharSequence getPrimitiveStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.a.length << 1);
        for (int i2 = 0; i2 < this.a.length - 1; ++i2) {
            fastStringBuffer.append(this.a[i2] + ".");
        }
        fastStringBuffer.append("" + this.a[this.a.length - 1]);
        return fastStringBuffer;
    }

    public int compareTo(Object object) {
        if (!(object instanceof NestedIntegerValue)) {
            throw new ClassCastException("NestedIntegerValue is not comparable to " + object.getClass());
        }
        object = (NestedIntegerValue)object;
        for (int i2 = 0; i2 < this.a.length && i2 < ((NestedIntegerValue)object).a.length; ++i2) {
            if (this.a[i2] == ((NestedIntegerValue)object).a[i2]) continue;
            if (this.a[i2] < ((NestedIntegerValue)object).a[i2]) {
                return -1;
            }
            return 1;
        }
        return Integer.signum(this.a.length - ((NestedIntegerValue)object).a.length);
    }
}

