/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QualifiedNameValue;

public final class NotationValue
extends QualifiedNameValue {
    public NotationValue(String object, String string, String string2, boolean bl2) {
        if (bl2 && !NameChecker.isValidNCName(string2)) {
            object = new XPathException("Malformed local name in NOTATION: '" + string2 + '\'');
            ((XPathException)object).setErrorCode("FORG0001");
            throw object;
        }
        object = object == null ? "" : object;
        String string3 = string = string == null ? "" : string;
        if (bl2 && string.isEmpty() && ((String)object).length() != 0) {
            object = new XPathException("NOTATION has null namespace but non-empty prefix");
            ((XPathException)object).setErrorCode("FOCA0002");
            throw object;
        }
        this.qName = new StructuredQName((String)object, string, string2);
        this.typeLabel = BuiltInAtomicType.NOTATION;
    }

    public NotationValue(String string, String string2, String string3) {
        this.qName = new StructuredQName(string, string2, string3);
        this.typeLabel = BuiltInAtomicType.NOTATION;
    }

    public NotationValue(String string, String string2, String string3, AtomicType atomicType) {
        this.qName = new StructuredQName(string, string2, string3);
        this.typeLabel = atomicType;
    }

    public NotationValue(StructuredQName structuredQName, AtomicType atomicType) {
        if (structuredQName == null) {
            throw new NullPointerException("qName");
        }
        if (atomicType == null) {
            throw new NullPointerException("typeLabel");
        }
        this.qName = structuredQName;
        this.typeLabel = atomicType;
    }

    @Override
    public final AtomicValue copyAsSubType(AtomicType atomicType) {
        NotationValue notationValue = new NotationValue(this.getPrefix(), this.getNamespaceURI(), this.getLocalName());
        new NotationValue(this.getPrefix(), this.getNamespaceURI(), this.getLocalName()).typeLabel = atomicType;
        return notationValue;
    }

    @Override
    public final BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.NOTATION;
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof NotationValue && this.qName.equals(((NotationValue)object).qName);
    }

    @Override
    public final Comparable getSchemaComparable() {
        return new a(this, 0);
    }

    @Override
    public final String toString() {
        return "NOTATION(" + this.getClarkName() + ')';
    }

    private final class a
    implements Comparable {
        private /* synthetic */ NotationValue a;

        private a(NotationValue notationValue) {
            this.a = notationValue;
        }

        public final int compareTo(Object object) {
            if (this.equals(object)) {
                return 0;
            }
            return Integer.MIN_VALUE;
        }

        public final boolean equals(Object object) {
            if (object instanceof a) {
                object = (a)object;
                if (this.a.qName.equals(((a)object).a.qName)) {
                    return true;
                }
            }
            return false;
        }

        public final int hashCode() {
            return this.a.qName.hashCode();
        }

        /* synthetic */ a(NotationValue notationValue, byte by) {
            this(notationValue);
        }
    }
}

