/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public abstract class NumericValue
extends AtomicValue
implements Comparable<NumericValue>,
AtomicMatchKey {
    public static NumericValue parseNumber(String object) {
        if (((String)object).indexOf(101) >= 0 || ((String)object).indexOf(69) >= 0) {
            try {
                return new DoubleValue(Double.parseDouble((String)object));
            }
            catch (NumberFormatException numberFormatException) {
                return DoubleValue.NaN;
            }
        }
        if (((String)object).indexOf(46) >= 0) {
            if ((object = BigDecimalValue.makeDecimalValue((CharSequence)object, true)) instanceof ValidationFailure) {
                return DoubleValue.NaN;
            }
            return (NumericValue)object;
        }
        if ((object = Int64Value.stringToInteger((CharSequence)object)) instanceof ValidationFailure) {
            return DoubleValue.NaN;
        }
        return (NumericValue)object;
    }

    public abstract double getDoubleValue();

    public abstract float getFloatValue();

    public abstract BigDecimal getDecimalValue();

    @Override
    public abstract boolean effectiveBooleanValue();

    public static boolean isInteger(AtomicValue atomicValue) {
        return atomicValue instanceof IntegerValue;
    }

    public abstract long longValue();

    public abstract NumericValue negate();

    public abstract NumericValue floor();

    public abstract NumericValue ceiling();

    public abstract NumericValue round(int var1);

    public abstract NumericValue roundHalfToEven(int var1);

    public abstract int signum();

    public boolean isNegativeZero() {
        return false;
    }

    public abstract boolean isWholeNumber();

    public abstract int asSubscript();

    public abstract NumericValue abs();

    @Override
    public final AtomicMatchKey getXPathComparable(boolean bl2, StringCollator stringCollator, int n2) {
        return this;
    }

    @Override
    public int compareTo(NumericValue numericValue) {
        double d2;
        double d3 = this.getDoubleValue();
        if (d3 == (d2 = numericValue.getDoubleValue())) {
            return 0;
        }
        if (d3 < d2) {
            return -1;
        }
        return 1;
    }

    @Override
    public abstract int compareTo(long var1);

    @Override
    public final boolean equals(Object object) {
        return object instanceof NumericValue && this.compareTo((NumericValue)object) == 0;
    }

    public abstract int hashCode();

    @Override
    public String toString() {
        return this.getStringValue();
    }
}

