/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Objects;
import net.sf.saxon.om.Genre;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.StringValue;

public class ObjectValue<T>
implements ExternalObject<T> {
    private T a;

    public ObjectValue(T t2) {
        this.a = Objects.requireNonNull(t2, "External object cannot wrap a Java null");
    }

    @Override
    public Genre getGenre() {
        return Genre.EXTERNAL;
    }

    @Override
    public String getStringValue() {
        return this.a.toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.a.toString();
    }

    @Override
    public StringValue atomize() {
        return new StringValue(this.getStringValue());
    }

    @Override
    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return typeHierarchy.getConfiguration().getJavaExternalObjectType(this.a.getClass());
    }

    public static String displayTypeName(Object object) {
        return "java-type:" + object.getClass().getName();
    }

    @Override
    public boolean effectiveBooleanValue() {
        return true;
    }

    @Override
    public T getObject() {
        return this.a;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectValue) {
            object = ((ObjectValue)object).a;
            return this.a.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    @Override
    public String toShortString() {
        String string = this.a.toString();
        if (string.startsWith(this.a.getClass().getName())) {
            return string;
        }
        return "(" + this.a.getClass().getSimpleName() + ")" + Err.truncate30(this.a.toString());
    }
}

