/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;

public class QNameValue
extends QualifiedNameValue {
    public QNameValue(String string, String string2, String string3) {
        this(string, string2, string3, BuiltInAtomicType.QNAME);
    }

    public QNameValue(String string, String string2, String string3, AtomicType atomicType) {
        this.qName = new StructuredQName(string, string2, string3);
        if (atomicType == null) {
            atomicType = BuiltInAtomicType.QNAME;
        }
        this.typeLabel = atomicType;
    }

    public QNameValue(String object, String string, String string2, AtomicType atomicType, boolean bl2) {
        if (!NameChecker.isValidNCName(string2)) {
            object = new XPathException("Malformed local name in QName: '" + string2 + '\'');
            ((XPathException)object).setErrorCode("FORG0001");
            throw object;
        }
        object = object == null ? "" : object;
        String string3 = string = "".equals(string) ? null : string;
        if (bl2 && string == null && ((String)object).length() != 0) {
            object = new XPathException("QName has null namespace but non-empty prefix");
            ((XPathException)object).setErrorCode("FOCA0002");
            throw object;
        }
        this.qName = new StructuredQName((String)object, string, string2);
        this.typeLabel = atomicType;
    }

    public QNameValue(StructuredQName structuredQName, AtomicType atomicType) {
        if (structuredQName == null) {
            throw new NullPointerException("qName");
        }
        if (atomicType == null) {
            throw new NullPointerException("typeLabel");
        }
        this.qName = structuredQName;
        this.typeLabel = atomicType;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        return new QNameValue(this.qName, atomicType);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.QNAME;
    }

    @Override
    public AtomicValue getComponent(AccessorFn.Component object) {
        switch (object) {
            case LOCALNAME: {
                return new StringValue(this.getLocalName(), BuiltInAtomicType.NCNAME);
            }
            case NAMESPACE: {
                return new AnyURIValue(this.getNamespaceURI());
            }
            case PREFIX: {
                object = this.getPrefix();
                if (((String)object).isEmpty()) {
                    return null;
                }
                return new StringValue((CharSequence)object, BuiltInAtomicType.NCNAME);
            }
        }
        throw new UnsupportedOperationException("Component of QName must be URI, Local Name, or Prefix");
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof QNameValue && this.qName.equals(((QNameValue)object).qName);
    }

    @Override
    public Comparable getSchemaComparable() {
        return new a(this, 0);
    }

    private final class a
    implements Comparable {
        private /* synthetic */ QNameValue a;

        private a(QNameValue qNameValue) {
            this.a = qNameValue;
        }

        public final int compareTo(Object object) {
            if (this.equals(object)) {
                return 0;
            }
            return Integer.MIN_VALUE;
        }

        public final boolean equals(Object object) {
            if (object instanceof a) {
                object = (a)object;
                if (this.a.qName.equals(((a)object).a.qName)) {
                    return true;
                }
            }
            return false;
        }

        public final int hashCode() {
            return this.a.qName.hashCode();
        }

        /* synthetic */ a(QNameValue qNameValue, byte by) {
            this(qNameValue);
        }
    }
}

