/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.YearMonthDurationValue;

public class SaxonDuration
extends Duration {
    private DurationValue a;

    public SaxonDuration(DurationValue durationValue) {
        this.a = durationValue;
    }

    public DurationValue getDurationValue() {
        return this.a;
    }

    @Override
    public QName getXMLSchemaType() {
        if (this.a instanceof DayTimeDurationValue) {
            return new QName("http://www.w3.org/2001/XMLSchema", "dayTimeDuration");
        }
        if (this.a instanceof YearMonthDurationValue) {
            return new QName("http://www.w3.org/2001/XMLSchema", "yearMonthDuration");
        }
        return new QName("http://www.w3.org/2001/XMLSchema", "duration");
    }

    @Override
    public int getSign() {
        return this.a.signum();
    }

    @Override
    public Number getField(DatatypeConstants.Field field) {
        if (field == DatatypeConstants.YEARS) {
            return BigInteger.valueOf(((NumericValue)((Int64Value)((AtomicValue)this.a).getComponent(AccessorFn.Component.YEAR))).longValue());
        }
        if (field == DatatypeConstants.MONTHS) {
            return BigInteger.valueOf(((NumericValue)((Int64Value)((AtomicValue)this.a).getComponent(AccessorFn.Component.MONTH))).longValue());
        }
        if (field == DatatypeConstants.DAYS) {
            return BigInteger.valueOf(((NumericValue)((Int64Value)((AtomicValue)this.a).getComponent(AccessorFn.Component.DAY))).longValue());
        }
        if (field == DatatypeConstants.HOURS) {
            return BigInteger.valueOf(((NumericValue)((Int64Value)((AtomicValue)this.a).getComponent(AccessorFn.Component.HOURS))).longValue());
        }
        if (field == DatatypeConstants.MINUTES) {
            return BigInteger.valueOf(((NumericValue)((Int64Value)((AtomicValue)this.a).getComponent(AccessorFn.Component.MINUTES))).longValue());
        }
        if (field == DatatypeConstants.SECONDS) {
            return ((NumericValue)((BigDecimalValue)((AtomicValue)this.a).getComponent(AccessorFn.Component.SECONDS))).getDecimalValue();
        }
        throw new IllegalArgumentException("Invalid field");
    }

    @Override
    public boolean isSet(DatatypeConstants.Field field) {
        return true;
    }

    @Override
    public Duration add(Duration duration) {
        try {
            return new SaxonDuration(this.a.add(((SaxonDuration)duration).a));
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException.getMessage());
        }
    }

    @Override
    public Duration subtract(Duration duration) {
        try {
            return new SaxonDuration(this.a.subtract(((SaxonDuration)duration).a));
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException.getMessage());
        }
    }

    @Override
    public void addTo(Calendar calendar) {
        int n2 = this.getSign();
        if (n2 == 0) {
            return;
        }
        calendar.add(1, this.getYears() * n2);
        calendar.add(2, this.getMonths() * n2);
        calendar.add(5, this.getDays() * n2);
        calendar.add(11, this.getHours() * n2);
        calendar.add(12, this.getMinutes() * n2);
        calendar.add(13, (int)((NumericValue)((Int64Value)((AtomicValue)this.a).getComponent(AccessorFn.Component.WHOLE_SECONDS))).longValue() * n2);
        calendar.add(14, (int)((NumericValue)((Int64Value)((AtomicValue)this.a).getComponent(AccessorFn.Component.MICROSECONDS))).longValue() * n2 / 1000);
    }

    @Override
    public Duration multiply(BigDecimal bigDecimal) {
        try {
            return new SaxonDuration(this.a.multiply(bigDecimal.doubleValue()));
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException.getMessage());
        }
    }

    @Override
    public Duration negate() {
        return new SaxonDuration(this.a.negate());
    }

    @Override
    public Duration normalizeWith(Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compare(Duration object) {
        if (!(object instanceof SaxonDuration)) {
            throw new IllegalArgumentException("Supplied duration is not a SaxonDuration");
        }
        Comparable comparable = ((AtomicValue)this.a).getSchemaComparable();
        object = ((AtomicValue)((SaxonDuration)object).a).getSchemaComparable();
        return comparable.compareTo(object);
    }

    @Override
    public int hashCode() {
        return this.a.hashCode();
    }
}

