/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SaxonDuration;
import net.sf.saxon.value.TimeValue;

public class SaxonXMLGregorianCalendar
extends XMLGregorianCalendar {
    private CalendarValue a;
    private BigInteger b;
    private int c = Integer.MIN_VALUE;
    private int d = Integer.MIN_VALUE;
    private int e = Integer.MIN_VALUE;
    private int f = Integer.MIN_VALUE;
    private int g = Integer.MIN_VALUE;
    private int h = Integer.MIN_VALUE;
    private int i = Integer.MIN_VALUE;

    public SaxonXMLGregorianCalendar(CalendarValue calendarValue) {
        this.clear();
        this.setCalendarValue(calendarValue);
    }

    private SaxonXMLGregorianCalendar() {
    }

    public void setCalendarValue(CalendarValue calendarValue) {
        block9: {
            this.a = calendarValue;
            try {
                if (calendarValue instanceof GYearValue) {
                    this.b = BigInteger.valueOf(((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.YEAR))).longValue());
                    break block9;
                }
                if (calendarValue instanceof GYearMonthValue) {
                    this.b = BigInteger.valueOf(((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.YEAR))).longValue());
                    this.c = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.MONTH))).longValue();
                    break block9;
                }
                if (calendarValue instanceof GMonthValue) {
                    this.c = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.MONTH))).longValue();
                    break block9;
                }
                if (calendarValue instanceof GMonthDayValue) {
                    this.c = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.MONTH))).longValue();
                    this.d = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.DAY))).longValue();
                    break block9;
                }
                if (calendarValue instanceof GDayValue) {
                    this.d = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.DAY))).longValue();
                    break block9;
                }
                if (calendarValue instanceof DateValue) {
                    this.b = BigInteger.valueOf(((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.YEAR))).longValue());
                    this.c = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.MONTH))).longValue();
                    this.d = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.DAY))).longValue();
                    break block9;
                }
                if (calendarValue instanceof TimeValue) {
                    this.e = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.HOURS))).longValue();
                    this.f = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.MINUTES))).longValue();
                    this.g = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.WHOLE_SECONDS))).longValue();
                    this.h = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.MICROSECONDS))).longValue();
                    break block9;
                }
                this.b = BigInteger.valueOf(((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.YEAR))).longValue());
                this.c = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.MONTH))).longValue();
                this.d = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.DAY))).longValue();
                this.e = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.HOURS))).longValue();
                this.f = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.MINUTES))).longValue();
                this.g = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.WHOLE_SECONDS))).longValue();
                this.h = (int)((NumericValue)((Int64Value)calendarValue.getComponent(AccessorFn.Component.MICROSECONDS))).longValue();
                return;
            }
            catch (XPathException xPathException) {
                throw new IllegalArgumentException(xPathException.getMessage());
            }
        }
    }

    @Override
    public void clear() {
        this.b = null;
        this.c = Integer.MIN_VALUE;
        this.d = Integer.MIN_VALUE;
        this.e = Integer.MIN_VALUE;
        this.f = Integer.MIN_VALUE;
        this.g = Integer.MIN_VALUE;
        this.h = Integer.MIN_VALUE;
        this.i = Integer.MIN_VALUE;
    }

    @Override
    public void reset() {
        this.clear();
    }

    @Override
    public void setYear(BigInteger bigInteger) {
        this.a = null;
        this.b = bigInteger;
    }

    @Override
    public void setYear(int n2) {
        this.a = null;
        this.b = BigInteger.valueOf(n2);
    }

    @Override
    public void setMonth(int n2) {
        this.a = null;
        this.c = n2;
    }

    @Override
    public void setDay(int n2) {
        this.a = null;
        this.d = n2;
    }

    @Override
    public void setTimezone(int n2) {
        this.a = null;
        this.i = n2;
    }

    @Override
    public void setHour(int n2) {
        this.a = null;
        this.e = n2;
    }

    @Override
    public void setMinute(int n2) {
        this.a = null;
        this.f = n2;
    }

    @Override
    public void setSecond(int n2) {
        this.a = null;
        this.g = n2;
    }

    @Override
    public void setMillisecond(int n2) {
        this.a = null;
        this.h = n2 * 1000;
    }

    @Override
    public void setFractionalSecond(BigDecimal number) {
        this.a = null;
        this.g = ((BigDecimal)number).intValue();
        number = ((BigDecimal)number).movePointRight(6).toBigInteger();
        number = ((BigInteger)number).remainder(BigInteger.valueOf(1000000L));
        this.h = ((BigInteger)number).intValue();
    }

    @Override
    public BigInteger getEon() {
        return this.b.divide(BigInteger.valueOf(1000000000L));
    }

    @Override
    public int getYear() {
        return this.b.intValue();
    }

    @Override
    public BigInteger getEonAndYear() {
        return this.b;
    }

    @Override
    public int getMonth() {
        return this.c;
    }

    @Override
    public int getDay() {
        return this.d;
    }

    @Override
    public int getTimezone() {
        return this.i;
    }

    @Override
    public int getHour() {
        return this.e;
    }

    @Override
    public int getMinute() {
        return this.f;
    }

    @Override
    public int getSecond() {
        return this.g;
    }

    public int getMicrosecond() {
        BigDecimal bigDecimal = this.getFractionalSecond();
        if (bigDecimal == null) {
            return Integer.MIN_VALUE;
        }
        return this.getFractionalSecond().movePointRight(6).intValue();
    }

    @Override
    public BigDecimal getFractionalSecond() {
        if (this.g == Integer.MIN_VALUE) {
            return null;
        }
        return BigDecimal.valueOf(this.h).movePointLeft(6);
    }

    @Override
    public int compare(XMLGregorianCalendar xMLGregorianCalendar) {
        return this.toCalendarValue().getSchemaComparable().compareTo(((SaxonXMLGregorianCalendar)xMLGregorianCalendar).toCalendarValue().getSchemaComparable());
    }

    @Override
    public XMLGregorianCalendar normalize() {
        return new SaxonXMLGregorianCalendar(this.toCalendarValue().adjustTimezone(0));
    }

    @Override
    public String toXMLFormat() {
        return this.toCalendarValue().getStringValue();
    }

    @Override
    public QName getXMLSchemaType() {
        if (this.g == Integer.MIN_VALUE) {
            if (this.b == null) {
                if (this.c == Integer.MIN_VALUE) {
                    return DatatypeConstants.GDAY;
                }
                if (this.d == Integer.MIN_VALUE) {
                    return DatatypeConstants.GMONTH;
                }
                return DatatypeConstants.GMONTHDAY;
            }
            if (this.d == Integer.MIN_VALUE) {
                if (this.c == Integer.MIN_VALUE) {
                    return DatatypeConstants.GYEAR;
                }
                return DatatypeConstants.GYEARMONTH;
            }
            return DatatypeConstants.DATE;
        }
        if (this.b == null) {
            return DatatypeConstants.TIME;
        }
        return DatatypeConstants.DATETIME;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void add(Duration object) {
        try {
            object = this.toCalendarValue().add(((SaxonDuration)object).getDurationValue());
            this.setCalendarValue((CalendarValue)object);
            return;
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException.getMessage());
        }
    }

    @Override
    public GregorianCalendar toGregorianCalendar() {
        return this.toCalendarValue().getCalendar();
    }

    @Override
    public GregorianCalendar toGregorianCalendar(TimeZone cloneable, Locale locale, XMLGregorianCalendar xMLGregorianCalendar) {
        cloneable = new GregorianCalendar((TimeZone)cloneable, locale);
        ((GregorianCalendar)cloneable).setGregorianChange(new Date(Long.MIN_VALUE));
        ((Calendar)cloneable).set(0, this.b == null ? (xMLGregorianCalendar.getYear() > 0 ? 1 : -1) : this.b.signum());
        ((Calendar)cloneable).set(1, this.b == null ? xMLGregorianCalendar.getYear() : this.b.abs().intValue());
        ((Calendar)cloneable).set(2, this.c == Integer.MIN_VALUE ? xMLGregorianCalendar.getMonth() : this.c);
        ((Calendar)cloneable).set(5, this.d == Integer.MIN_VALUE ? xMLGregorianCalendar.getDay() : this.d);
        ((Calendar)cloneable).set(10, this.e == Integer.MIN_VALUE ? xMLGregorianCalendar.getHour() : this.e);
        ((Calendar)cloneable).set(12, this.f == Integer.MIN_VALUE ? xMLGregorianCalendar.getMinute() : this.f);
        ((Calendar)cloneable).set(13, this.g == Integer.MIN_VALUE ? xMLGregorianCalendar.getSecond() : this.g);
        ((Calendar)cloneable).set(14, this.h == Integer.MIN_VALUE ? xMLGregorianCalendar.getMillisecond() : this.h / 1000);
        return cloneable;
    }

    @Override
    public TimeZone getTimeZone(int n2) {
        if (this.i == Integer.MIN_VALUE) {
            if (n2 == Integer.MIN_VALUE) {
                return new GregorianCalendar().getTimeZone();
            }
            return new SimpleTimeZone(n2 * 60000, "XXX");
        }
        return new SimpleTimeZone(this.i * 60000, "XXX");
    }

    @Override
    public Object clone() {
        SaxonXMLGregorianCalendar saxonXMLGregorianCalendar = new SaxonXMLGregorianCalendar();
        saxonXMLGregorianCalendar.setYear(this.b);
        saxonXMLGregorianCalendar.setMonth(this.c);
        saxonXMLGregorianCalendar.setDay(this.d);
        saxonXMLGregorianCalendar.setHour(this.e);
        saxonXMLGregorianCalendar.setMinute(this.f);
        saxonXMLGregorianCalendar.setSecond(this.g);
        saxonXMLGregorianCalendar.setMillisecond(this.h / 1000);
        saxonXMLGregorianCalendar.setTimezone(this.i);
        return saxonXMLGregorianCalendar;
    }

    public CalendarValue toCalendarValue() {
        if (this.a != null) {
            return this.a;
        }
        if (this.g == Integer.MIN_VALUE) {
            if (this.b == null) {
                if (this.c == Integer.MIN_VALUE) {
                    return new GDayValue((byte)this.d, this.i);
                }
                if (this.d == Integer.MIN_VALUE) {
                    return new GMonthValue((byte)this.c, this.i);
                }
                return new GMonthDayValue((byte)this.c, (byte)this.d, this.i);
            }
            if (this.d == Integer.MIN_VALUE) {
                if (this.c == Integer.MIN_VALUE) {
                    return new GYearValue(this.b.intValue(), this.i, true);
                }
                return new GYearMonthValue(this.b.intValue(), (byte)this.c, this.i, true);
            }
            return new DateValue(this.b.intValue(), (byte)this.c, (byte)this.d, this.i, true);
        }
        if (this.b == null) {
            return new TimeValue((byte)this.e, (byte)this.f, (byte)this.g, this.getMicrosecond() * 1000, this.i, "");
        }
        return new DateTimeValue(this.b.intValue(), (byte)this.c, (byte)this.d, (byte)this.e, (byte)this.f, (byte)this.g, this.getMicrosecond(), this.i, true);
    }
}

