/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.ReverseListIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceSlice;

public class SequenceExtent<T extends Item<?>>
implements GroundedValue<T> {
    private List<T> a;

    public SequenceExtent(T[] TArray) {
        this.a = Arrays.asList(TArray);
    }

    public SequenceExtent(SequenceExtent<T> sequenceExtent, int n2, int n3) {
        int n4 = n2;
        this.a = sequenceExtent.a.subList(n4, n4 + n3);
    }

    public SequenceExtent(List<T> list) {
        this.a = list;
    }

    public SequenceExtent(SequenceIterator<T> sequenceIterator) {
        int n2 = (sequenceIterator.getProperties() & 2) == 0 ? 20 : ((LastPositionFinder)((Object)sequenceIterator)).getLength();
        ArrayList<T> arrayList = new ArrayList<T>(n2);
        sequenceIterator.forEachOrFail(arrayList::add);
        this.a = arrayList;
    }

    public static <T extends Item<?>> GroundedValue<? extends T> makeSequenceExtent(SequenceIterator<T> sequenceIterator) {
        return sequenceIterator.materialize();
    }

    public static <T extends Item<?>> GroundedValue<T> fromIterator(SequenceIterator<T> sequenceIterator) {
        return new SequenceExtent<T>(sequenceIterator).reduce();
    }

    public static <T extends Item<?>> GroundedValue<T> makeResidue(SequenceIterator<T> object) {
        if ((object.getProperties() & 1) != 0) {
            return ((GroundedIterator)object).getResidue();
        }
        object = new SequenceExtent<T>(object);
        return ((SequenceExtent)object).reduce();
    }

    public static <T extends Item<?>> GroundedValue<T> makeSequenceExtent(List<T> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return EmptySequence.getInstance();
        }
        if (n2 == 1) {
            return (GroundedValue)list.get(0);
        }
        return new SequenceExtent<T>(list);
    }

    @Override
    public String getStringValue() {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public CharSequence getStringValueCS() {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public T head() {
        return this.itemAt(0);
    }

    @Override
    public int getLength() {
        return this.a.size();
    }

    public int getCardinality() {
        switch (this.a.size()) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    @Override
    public T itemAt(int n2) {
        if (n2 < 0 || n2 >= this.getLength()) {
            return null;
        }
        return (T)((Item)this.a.get(n2));
    }

    @Override
    public ListIterator<T> iterate() {
        return new ListIterator<T>(this.a);
    }

    public UnfailingIterator<T> reverseIterate() {
        return new ReverseListIterator<T>(this.a);
    }

    @Override
    public boolean effectiveBooleanValue() {
        int n2 = this.getLength();
        if (n2 == 0) {
            return false;
        }
        Item item = (Item)this.a.get(0);
        if (item instanceof NodeInfo) {
            return true;
        }
        if (n2 == 1 && item instanceof AtomicValue) {
            return item.effectiveBooleanValue();
        }
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public GroundedValue<T> subsequence(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.a.size()) {
            return EmptySequence.getInstance();
        }
        return new SequenceSlice<T>(this.a, n2, n3).reduce();
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            fastStringBuffer.append(i2 == 0 ? "(" : ", ");
            fastStringBuffer.append(((Item)this.a.get(i2)).toString());
        }
        fastStringBuffer.append(')');
        return fastStringBuffer.toString();
    }

    @Override
    public GroundedValue<T> reduce() {
        int n2 = this.getLength();
        if (n2 == 0) {
            return EmptySequence.getInstance();
        }
        if (n2 == 1) {
            return this.itemAt(0);
        }
        return this;
    }

    @Override
    public Iterable<T> asIterable() {
        return this.a;
    }

    @Override
    public Iterator<T> iterator() {
        return this.a.iterator();
    }
}

