/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.EmptySequence;

public class SequenceSlice<T extends Item<?>>
implements GroundedValue<T> {
    private List<T> a;
    private int b;
    private int c;

    public SequenceSlice(List<T> list, int n2, int n3) {
        this.a = list;
        this.b = n2;
        if (n2 < 0 || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 > list.size() || n2 + n3 > list.size()) {
            this.c = list.size() - n2;
            return;
        }
        this.c = n3;
    }

    @Override
    public String getStringValue() {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public CharSequence getStringValueCS() {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public T head() {
        return this.itemAt(0);
    }

    @Override
    public int getLength() {
        return this.c;
    }

    public int getCardinality() {
        switch (this.getLength()) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    @Override
    public T itemAt(int n2) {
        if (n2 < 0 || n2 >= this.getLength()) {
            return null;
        }
        return (T)((Item)this.a.get(n2 + this.b));
    }

    @Override
    public ListIterator<T> iterate() {
        return new ListIterator<T>(this.a.subList(this.b, this.b + this.c));
    }

    @Override
    public GroundedValue<T> subsequence(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n2 += this.b) > this.a.size()) {
            return EmptySequence.getInstance();
        }
        if (n3 < 0) {
            return EmptySequence.getInstance();
        }
        if (n2 + (n3 = Integer.min(n3, this.c)) > this.a.size()) {
            n3 = this.a.size() - n2;
        }
        switch (n3) {
            case 0: {
                return EmptySequence.getInstance();
            }
            case 1: {
                return (GroundedValue)this.a.get(n2);
            }
        }
        return new SequenceSlice<T>(this.a, n2, n3);
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            fastStringBuffer.append(i2 == 0 ? "(" : ", ");
            fastStringBuffer.append(this.itemAt(i2).toString());
        }
        fastStringBuffer.append(')');
        return fastStringBuffer.toString();
    }

    @Override
    public GroundedValue<T> reduce() {
        int n2 = this.getLength();
        if (n2 == 0) {
            return EmptySequence.getInstance();
        }
        if (n2 == 1) {
            return this.itemAt(0);
        }
        return this;
    }

    @Override
    public Iterable<T> asIterable() {
        return this.a.subList(this.b, this.b + this.c);
    }

    @Override
    public Iterator<T> iterator() {
        return this.a.subList(this.b, this.b + this.c).iterator();
    }
}

