/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Optional;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public final class SequenceType {
    private ItemType a;
    private int b;
    public static final SequenceType ANY_SEQUENCE = AnyItemType.getInstance().zeroOrMore();
    public static final SequenceType SINGLE_ITEM = AnyItemType.getInstance().one();
    public static final SequenceType OPTIONAL_ITEM = AnyItemType.getInstance().zeroOrOne();
    public static final SequenceType SINGLE_ATOMIC = BuiltInAtomicType.ANY_ATOMIC.one();
    public static final SequenceType OPTIONAL_ATOMIC = BuiltInAtomicType.ANY_ATOMIC.zeroOrOne();
    public static final SequenceType ATOMIC_SEQUENCE = BuiltInAtomicType.ANY_ATOMIC.zeroOrMore();
    public static final SequenceType SINGLE_STRING = BuiltInAtomicType.STRING.one();
    public static final SequenceType SINGLE_UNTYPED_ATOMIC = BuiltInAtomicType.UNTYPED_ATOMIC.one();
    public static final SequenceType OPTIONAL_STRING = BuiltInAtomicType.STRING.zeroOrOne();
    public static final SequenceType SINGLE_BOOLEAN = BuiltInAtomicType.BOOLEAN.one();
    public static final SequenceType OPTIONAL_BOOLEAN = BuiltInAtomicType.BOOLEAN.zeroOrOne();
    public static final SequenceType SINGLE_INTEGER = BuiltInAtomicType.INTEGER.one();
    public static final SequenceType SINGLE_DECIMAL = BuiltInAtomicType.DECIMAL.one();
    public static final SequenceType OPTIONAL_INTEGER = BuiltInAtomicType.INTEGER.zeroOrOne();
    public static final SequenceType SINGLE_SHORT = BuiltInAtomicType.SHORT.one();
    public static final SequenceType OPTIONAL_SHORT = BuiltInAtomicType.SHORT.zeroOrOne();
    public static final SequenceType SINGLE_BYTE = BuiltInAtomicType.BYTE.one();
    public static final SequenceType OPTIONAL_BYTE = BuiltInAtomicType.BYTE.zeroOrOne();
    public static final SequenceType SINGLE_DOUBLE = BuiltInAtomicType.DOUBLE.one();
    public static final SequenceType OPTIONAL_DOUBLE = BuiltInAtomicType.DOUBLE.zeroOrOne();
    public static final SequenceType SINGLE_FLOAT = BuiltInAtomicType.FLOAT.one();
    public static final SequenceType OPTIONAL_FLOAT = BuiltInAtomicType.FLOAT.zeroOrOne();
    public static final SequenceType OPTIONAL_DECIMAL = BuiltInAtomicType.DECIMAL.zeroOrOne();
    public static final SequenceType OPTIONAL_ANY_URI = BuiltInAtomicType.ANY_URI.zeroOrOne();
    public static final SequenceType OPTIONAL_DATE = BuiltInAtomicType.DATE.zeroOrOne();
    public static final SequenceType OPTIONAL_TIME = BuiltInAtomicType.TIME.zeroOrOne();
    public static final SequenceType OPTIONAL_G_YEAR = BuiltInAtomicType.G_YEAR.zeroOrOne();
    public static final SequenceType OPTIONAL_G_YEAR_MONTH = BuiltInAtomicType.G_YEAR_MONTH.zeroOrOne();
    public static final SequenceType OPTIONAL_G_MONTH = BuiltInAtomicType.G_MONTH.zeroOrOne();
    public static final SequenceType OPTIONAL_G_MONTH_DAY = BuiltInAtomicType.G_MONTH_DAY.zeroOrOne();
    public static final SequenceType OPTIONAL_G_DAY = BuiltInAtomicType.G_DAY.zeroOrOne();
    public static final SequenceType OPTIONAL_DATE_TIME = BuiltInAtomicType.DATE_TIME.zeroOrOne();
    public static final SequenceType OPTIONAL_DURATION = BuiltInAtomicType.DURATION.zeroOrOne();
    public static final SequenceType OPTIONAL_YEAR_MONTH_DURATION = BuiltInAtomicType.YEAR_MONTH_DURATION.zeroOrOne();
    public static final SequenceType OPTIONAL_DAY_TIME_DURATION = BuiltInAtomicType.DAY_TIME_DURATION.zeroOrOne();
    public static final SequenceType SINGLE_QNAME = BuiltInAtomicType.QNAME.one();
    public static final SequenceType OPTIONAL_QNAME = BuiltInAtomicType.QNAME.zeroOrOne();
    public static final SequenceType OPTIONAL_NOTATION = BuiltInAtomicType.NOTATION.zeroOrOne();
    public static final SequenceType OPTIONAL_BASE64_BINARY = BuiltInAtomicType.BASE64_BINARY.zeroOrOne();
    public static final SequenceType OPTIONAL_HEX_BINARY = BuiltInAtomicType.HEX_BINARY.zeroOrOne();
    public static final SequenceType OPTIONAL_NUMERIC = SequenceType.makeSequenceType(NumericType.getInstance(), 24576);
    public static final SequenceType SINGLE_NUMERIC = SequenceType.makeSequenceType(NumericType.getInstance(), 16384);
    public static final SequenceType OPTIONAL_NODE = AnyNodeTest.getInstance().zeroOrOne();
    public static final SequenceType SINGLE_NODE = AnyNodeTest.getInstance().one();
    public static final SequenceType OPTIONAL_DOCUMENT_NODE = NodeKindTest.DOCUMENT.zeroOrOne();
    public static final SequenceType NODE_SEQUENCE = AnyNodeTest.getInstance().zeroOrMore();
    public static final SequenceType STRING_SEQUENCE = BuiltInAtomicType.STRING.zeroOrMore();
    public static final SequenceType SINGLE_FUNCTION = SequenceType.makeSequenceType(AnyFunctionType.ANY_FUNCTION, 16384);
    public static final SequenceType OPTIONAL_FUNCTION_ITEM = SequenceType.makeSequenceType(AnyFunctionType.getInstance(), 24576);
    public static final SequenceType FUNCTION_ITEM_SEQUENCE = SequenceType.makeSequenceType(AnyFunctionType.getInstance(), 57344);
    public static final SequenceType EMPTY_SEQUENCE = new SequenceType(ErrorType.getInstance(), 8192);
    public static final SequenceType NON_EMPTY_SEQUENCE = SequenceType.makeSequenceType(AnyItemType.getInstance(), 49152);
    public static final SequenceType VOID = SequenceType.makeSequenceType(ErrorType.getInstance(), 32768);

    public SequenceType(ItemType itemType, int n2) {
        this.a = itemType;
        if (itemType instanceof ErrorType && Cardinality.allowsZero(n2)) {
            this.b = 8192;
            return;
        }
        this.b = n2;
    }

    public static SequenceType makeSequenceType(ItemType itemType, int n2) {
        if (itemType instanceof ItemType.WithSequenceTypeCache) {
            ItemType.WithSequenceTypeCache withSequenceTypeCache = (ItemType.WithSequenceTypeCache)itemType;
            switch (n2) {
                case 16384: {
                    return withSequenceTypeCache.one();
                }
                case 24576: {
                    return withSequenceTypeCache.zeroOrOne();
                }
                case 57344: {
                    return withSequenceTypeCache.zeroOrMore();
                }
                case 49152: {
                    return withSequenceTypeCache.oneOrMore();
                }
            }
        }
        if (n2 == 8192) {
            return EMPTY_SEQUENCE;
        }
        return new SequenceType(itemType, n2);
    }

    public final ItemType getPrimaryType() {
        return this.a;
    }

    public final int getCardinality() {
        return this.b;
    }

    public final boolean matches(Sequence<?> object, TypeHierarchy typeHierarchy) {
        Object t2;
        int n2 = 0;
        object = object.iterate();
        while ((t2 = object.next()) != null) {
            ++n2;
            if (this.a.matches((Item)t2, typeHierarchy)) continue;
            return false;
        }
        return !(n2 == 0 && !Cardinality.allowsZero(this.b) || n2 > 1 && !Cardinality.allowsMany(this.b));
    }

    public final Optional<String> explainMismatch(GroundedValue object, TypeHierarchy object2) {
        try {
            Object t2;
            int n2 = 0;
            object = object.iterate();
            while ((t2 = object.next()) != null) {
                ++n2;
                if (this.a.matches((Item)t2, (TypeHierarchy)object2)) continue;
                object = "The " + RoleDiagnostic.ordinal(n2) + " item is not an instance of the required type";
                if (((Optional)(object2 = this.a.explainMismatch((Item)t2, (TypeHierarchy)object2))).isPresent()) {
                    object = n2 == 1 ? (String)((Optional)object2).get() : (String)object + ". " + (String)((Optional)object2).get();
                } else if (n2 == 1) {
                    return Optional.empty();
                }
                return Optional.of(object);
            }
            if (n2 == 0 && !Cardinality.allowsZero(this.b)) {
                return Optional.of("The type does not allow an empty sequence");
            }
            if (n2 > 1 && !Cardinality.allowsMany(this.b)) {
                return Optional.of("The type does not allow a sequence of more than one item");
            }
            return Optional.empty();
        }
        catch (XPathException xPathException) {
            return Optional.empty();
        }
    }

    public final String toString() {
        if (this.b == 8192) {
            return "empty-sequence()";
        }
        return this.a + Cardinality.getOccurrenceIndicator(this.b);
    }

    public final String toExportString() {
        if (this.b == 8192) {
            return "empty-sequence()";
        }
        return this.a.toExportString() + Cardinality.getOccurrenceIndicator(this.b);
    }

    public final String toExportString2() {
        return null;
    }

    public final int hashCode() {
        return this.a.hashCode() ^ this.b;
    }

    public final boolean equals(Object object) {
        return object instanceof SequenceType && this.a.equals(((SequenceType)object).a) && this.b == ((SequenceType)object).b;
    }

    public final boolean isSameType(SequenceType sequenceType, TypeHierarchy typeHierarchy) {
        return this.b == sequenceType.b && typeHierarchy.relationship(this.a, sequenceType.a) == 0;
    }
}

