/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.regex.BMPString;
import net.sf.saxon.regex.EmptyString;
import net.sf.saxon.regex.LatinString;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.UntypedAtomicValue;

public class StringValue
extends AtomicValue {
    public static final StringValue EMPTY_STRING = new StringValue(EmptyString.THE_INSTANCE);
    public static final StringValue SINGLE_SPACE = new StringValue(LatinString.SINGLE_SPACE);
    public static final StringValue TRUE = new StringValue(new LatinString("true"));
    public static final StringValue FALSE = new StringValue(new LatinString("false"));
    protected CharSequence value;

    protected StringValue() {
        this.value = "";
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public StringValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : charSequence;
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public StringValue(CharSequence charSequence, AtomicType atomicType) {
        this.value = charSequence;
        this.typeLabel = atomicType;
    }

    public synchronized void setContainsNoSurrogates() {
        if (!(this.value instanceof BMPString || this.value instanceof LatinString || this.value instanceof EmptyString)) {
            this.value = new BMPString(this.value);
        }
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        StringValue stringValue = new StringValue(this.value);
        new StringValue(this.value).typeLabel = atomicType;
        return stringValue;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.STRING;
    }

    public static StringValue makeStringValue(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return EMPTY_STRING;
        }
        return new StringValue(charSequence);
    }

    public static boolean isEmpty(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return ((String)charSequence).isEmpty();
        }
        if (charSequence instanceof UnicodeString) {
            return ((UnicodeString)charSequence).uLength() == 0;
        }
        return charSequence.length() == 0;
    }

    @Override
    public final CharSequence getPrimitiveStringValue() {
        return this.value;
    }

    public final void setStringValueCS(CharSequence charSequence) {
        this.value = charSequence;
    }

    public synchronized int getStringLength() {
        if (!(this.value instanceof UnicodeString)) {
            this.a();
        }
        return ((UnicodeString)this.value).uLength();
    }

    public synchronized int getStringLengthUpperBound() {
        if (this.value instanceof UnicodeString) {
            return ((UnicodeString)this.value).uLength();
        }
        return this.value.length();
    }

    public synchronized UnicodeString getUnicodeString() {
        if (!(this.value instanceof UnicodeString)) {
            this.a();
        }
        return (UnicodeString)this.value;
    }

    private void a() {
        this.value = UnicodeString.makeUnicodeString(this.value);
    }

    public static int getStringLength(CharSequence charSequence) {
        if (charSequence instanceof UnicodeString) {
            return ((UnicodeString)charSequence).uLength();
        }
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 >= '\ud800' && c2 <= '\udbff') continue;
            ++n2;
        }
        return n2;
    }

    public boolean isZeroLength() {
        return this.value.length() == 0;
    }

    public boolean containsSurrogatePairs() {
        return UnicodeString.containsSurrogatePairs(this.value);
    }

    public boolean isKnownToContainNoSurrogates() {
        return this.value instanceof BMPString || this.value instanceof LatinString || this.value instanceof EmptyString;
    }

    public synchronized UnfailingIterator<Int64Value> iterateCharacters() {
        if (this.value instanceof UnicodeString) {
            return new UnicodeCharacterIterator((UnicodeString)this.value);
        }
        return new CharacterIterator(this.value);
    }

    public static int[] expand(CharSequence charSequence) {
        int[] nArray = new int[StringValue.getStringLength(charSequence)];
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            int n3 = charSequence.charAt(i2);
            if (n3 >= 55296 && n3 <= 56319) {
                n3 = (n3 - 55296 << 10) + (charSequence.charAt(i2 + 1) - 56320) + 65536;
                ++i2;
            }
            nArray[n2++] = n3;
        }
        return nArray;
    }

    public static CharSequence contract(int[] nArray, int n2) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(nArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            fastStringBuffer.appendWideChar(nArray[i2]);
        }
        return fastStringBuffer;
    }

    @Override
    public AtomicMatchKey getXPathComparable(boolean bl2, StringCollator stringCollator, int n2) {
        return stringCollator.getCollationKey(this.value);
    }

    @Override
    public boolean equals(Object object) {
        throw new ClassCastException("equals on StringValue is not allowed");
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean codepointEquals(StringValue stringValue) {
        if (this.value instanceof String) {
            return ((String)this.value).contentEquals(stringValue.value);
        }
        if (stringValue.value instanceof String) {
            return ((String)stringValue.value).contentEquals(this.value);
        }
        if (this.value instanceof UnicodeString) {
            if (!(stringValue.value instanceof UnicodeString)) {
                stringValue.a();
            }
            return this.value.equals(stringValue.value);
        }
        return this.value.length() == stringValue.value.length() && this.value.toString().equals(stringValue.value.toString());
    }

    @Override
    public boolean effectiveBooleanValue() {
        return this.value.length() > 0;
    }

    @Override
    public String toString() {
        return "\"" + this.value + '\"';
    }

    @Override
    public String toShortString() {
        String string = this.value.toString();
        if (string.length() > 40) {
            string = string.substring(0, 35) + "...";
        }
        return "\"" + string + '\"';
    }

    @Override
    public Comparable getSchemaComparable() {
        return this.getStringValue();
    }

    @Override
    public boolean isIdentical(AtomicValue atomicValue) {
        return atomicValue instanceof StringValue && this instanceof AnyURIValue == atomicValue instanceof AnyURIValue && this instanceof UntypedAtomicValue == atomicValue instanceof UntypedAtomicValue && this.codepointEquals((StringValue)atomicValue);
    }

    public static String diagnosticDisplay(String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length());
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= ' ' && c2 <= '~') {
                fastStringBuffer.append(c2);
                continue;
            }
            fastStringBuffer.append("\\u");
            for (int i3 = 12; i3 >= 0; i3 -= 4) {
                fastStringBuffer.append("0123456789ABCDEF".charAt(c2 >> i3 & 0xF));
            }
        }
        return fastStringBuffer.toString();
    }

    public static final class UnicodeCharacterIterator
    implements UnfailingIterator<Int64Value> {
        private UnicodeString a;
        private int b = 0;

        public UnicodeCharacterIterator(UnicodeString unicodeString) {
            this.a = unicodeString;
        }

        @Override
        public final Int64Value next() {
            if (this.b < this.a.uLength()) {
                return new Int64Value(this.a.uCharAt(this.b++));
            }
            return null;
        }

        @Override
        public final void close() {
        }

        @Override
        public final int getProperties() {
            return 0;
        }
    }

    public static final class CharacterIterator
    implements UnfailingIterator<Int64Value> {
        private int a = 0;
        private CharSequence b;

        public CharacterIterator(CharSequence charSequence) {
            this.b = charSequence;
        }

        @Override
        public final Int64Value next() {
            if (this.a < this.b.length()) {
                int n2;
                if ((n2 = this.b.charAt(this.a++)) >= 55296 && n2 <= 56319) {
                    try {
                        n2 = (n2 - 55296 << 10) + (this.b.charAt(this.a++) - 56320) + 65536;
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        System.err.println("Invalid surrogate at end of string");
                        System.err.println(StringValue.diagnosticDisplay(this.b.toString()));
                        stringIndexOutOfBoundsException.printStackTrace();
                        throw stringIndexOutOfBoundsException;
                    }
                }
                return new Int64Value(n2);
            }
            return null;
        }
    }
}

