/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.Whitespace;

public final class TimeValue
extends CalendarValue
implements Comparable {
    private byte a;
    private byte b;
    private byte c;
    private int d;

    private TimeValue() {
    }

    public TimeValue(byte by, byte by2, byte by3, int n2, int n3) {
        this.a = by;
        this.b = by2;
        this.c = by3;
        this.d = n2 * 1000;
        this.setTimezoneInMinutes(n3);
        this.typeLabel = BuiltInAtomicType.TIME;
    }

    public TimeValue(byte by, byte by2, byte by3, int n2, int n3, String string) {
        if (!string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.a = by;
        this.b = by2;
        this.c = by3;
        this.d = n2;
        this.setTimezoneInMinutes(n3);
        this.typeLabel = BuiltInAtomicType.TIME;
    }

    public static TimeValue makeTimeValue(byte by, byte by2, byte by3, int n2, int n3) {
        return new TimeValue(by, by2, by3, n2, n3, "");
    }

    public TimeValue(GregorianCalendar gregorianCalendar, int n2) {
        this.a = (byte)gregorianCalendar.get(11);
        this.b = (byte)gregorianCalendar.get(12);
        this.c = (byte)gregorianCalendar.get(13);
        this.d = gregorianCalendar.get(14) * 1000000;
        this.setTimezoneInMinutes(n2);
        this.typeLabel = BuiltInAtomicType.TIME;
    }

    public static ConversionResult makeTimeValue(CharSequence charSequence) {
        TimeValue timeValue = new TimeValue();
        StringTokenizer stringTokenizer = new StringTokenizer(Whitespace.trimWhitespace(charSequence).toString(), "-:.+Z", true);
        if (!stringTokenizer.hasMoreElements()) {
            return TimeValue.a("too short", charSequence);
        }
        String string = (String)stringTokenizer.nextElement();
        if (string.length() != 2) {
            return TimeValue.a("hour must be two digits", charSequence);
        }
        int n2 = DurationValue.simpleInteger(string);
        if (n2 < 0) {
            return TimeValue.a("Non-numeric hour component", charSequence);
        }
        timeValue.a = (byte)n2;
        if (timeValue.a > 24) {
            return TimeValue.a("hour is out of range", charSequence);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return TimeValue.a("too short", charSequence);
        }
        if (!":".equals(stringTokenizer.nextElement())) {
            return TimeValue.a("wrong delimiter after hour", charSequence);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return TimeValue.a("too short", charSequence);
        }
        string = (String)stringTokenizer.nextElement();
        if (string.length() != 2) {
            return TimeValue.a("minute must be two digits", charSequence);
        }
        n2 = DurationValue.simpleInteger(string);
        if (n2 < 0) {
            return TimeValue.a("Non-numeric minute component", charSequence);
        }
        timeValue.b = (byte)n2;
        if (timeValue.b > 59) {
            return TimeValue.a("minute is out of range", charSequence);
        }
        if (timeValue.a == 24 && timeValue.b != 0) {
            return TimeValue.a("If hour is 24, minute must be 00", charSequence);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return TimeValue.a("too short", charSequence);
        }
        if (!":".equals(stringTokenizer.nextElement())) {
            return TimeValue.a("wrong delimiter after minute", charSequence);
        }
        if (!stringTokenizer.hasMoreElements()) {
            return TimeValue.a("too short", charSequence);
        }
        string = (String)stringTokenizer.nextElement();
        if (string.length() != 2) {
            return TimeValue.a("second must be two digits", charSequence);
        }
        n2 = DurationValue.simpleInteger(string);
        if (n2 < 0) {
            return TimeValue.a("Non-numeric second component", charSequence);
        }
        timeValue.c = (byte)n2;
        if (timeValue.c > 59) {
            return TimeValue.a("second is out of range", charSequence);
        }
        if (timeValue.a == 24 && timeValue.c != 0) {
            return TimeValue.a("If hour is 24, second must be 00", charSequence);
        }
        int n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        while (stringTokenizer.hasMoreElements()) {
            if (n4 == 9) {
                return TimeValue.a("characters after the end", charSequence);
            }
            String string2 = (String)stringTokenizer.nextElement();
            if (".".equals(string2)) {
                if (n4 != 0) {
                    return TimeValue.a("decimal separator occurs twice", charSequence);
                }
                if (!stringTokenizer.hasMoreElements()) {
                    return TimeValue.a("decimal point must be followed by digits", charSequence);
                }
                string = (String)stringTokenizer.nextElement();
                if (string.length() > 9 && string.matches("^[0-9]+$")) {
                    string = string.substring(0, 9);
                }
                if ((n2 = DurationValue.simpleInteger(string)) < 0) {
                    return TimeValue.a("Non-numeric fractional seconds component", charSequence);
                }
                double d2 = Double.parseDouble("." + string);
                timeValue.d = (int)Math.round(d2 * 1.0E9);
                if (timeValue.a == 24 && timeValue.d != 0) {
                    return TimeValue.a("If hour is 24, fractional seconds must be 0", charSequence);
                }
                n4 = 1;
                continue;
            }
            if ("Z".equals(string2)) {
                if (n4 > 1) {
                    return TimeValue.a("Z cannot occur here", charSequence);
                }
                n3 = 0;
                n4 = 9;
                timeValue.setTimezoneInMinutes(0);
                continue;
            }
            if ("+".equals(string2) || "-".equals(string2)) {
                if (n4 > 1) {
                    return TimeValue.a(string2 + " cannot occur here", charSequence);
                }
                n4 = 2;
                if (!stringTokenizer.hasMoreElements()) {
                    return TimeValue.a("missing timezone", charSequence);
                }
                string = (String)stringTokenizer.nextElement();
                if (string.length() != 2) {
                    return TimeValue.a("timezone hour must be two digits", charSequence);
                }
                n2 = DurationValue.simpleInteger(string);
                if (n2 < 0) {
                    return TimeValue.a("Non-numeric timezone hour component", charSequence);
                }
                n3 = n2 * 60;
                if (n3 > 840) {
                    return TimeValue.a("timezone hour is out of range", charSequence);
                }
                if (!"-".equals(string2)) continue;
                bl2 = true;
                continue;
            }
            if (":".equals(string2)) {
                if (n4 != 2) {
                    return TimeValue.a("colon cannot occur here", charSequence);
                }
                n4 = 9;
                string = (String)stringTokenizer.nextElement();
                n2 = DurationValue.simpleInteger(string);
                if (n2 < 0) {
                    return TimeValue.a("Non-numeric timezone minute component", charSequence);
                }
                int n5 = n2;
                if (string.length() != 2) {
                    return TimeValue.a("timezone minute must be two digits", charSequence);
                }
                if (n5 > 59) {
                    return TimeValue.a("timezone minute is out of range", charSequence);
                }
                n3 += n5;
                if (bl2) {
                    n3 = -n3;
                }
                timeValue.setTimezoneInMinutes(n3);
                continue;
            }
            return TimeValue.a("timezone format is incorrect", charSequence);
        }
        if (n4 == 2 || n4 == 3) {
            return TimeValue.a("timezone incomplete", charSequence);
        }
        if (timeValue.a == 24) {
            timeValue.a = 0;
        }
        timeValue.typeLabel = BuiltInAtomicType.TIME;
        return timeValue;
    }

    private static ValidationFailure a(String object, CharSequence charSequence) {
        object = new ValidationFailure("Invalid time " + Err.wrap(charSequence, 4) + " (" + (String)object + ")");
        ((ValidationFailure)object).setErrorCode("FORG0001");
        return object;
    }

    @Override
    public final BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.TIME;
    }

    public final byte getHour() {
        return this.a;
    }

    public final byte getMinute() {
        return this.b;
    }

    public final byte getSecond() {
        return this.c;
    }

    public final int getMicrosecond() {
        return this.d / 1000;
    }

    public final int getNanosecond() {
        return this.d;
    }

    @Override
    public final CharSequence getPrimitiveStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        TimeValue.a(fastStringBuffer, this.a);
        fastStringBuffer.append(':');
        TimeValue.a(fastStringBuffer, this.b);
        fastStringBuffer.append(':');
        TimeValue.a(fastStringBuffer, this.c);
        if (this.d != 0) {
            fastStringBuffer.append('.');
            int n2 = this.d;
            int n3 = 100000000;
            while (n2 > 0) {
                int n4 = n2 / n3;
                fastStringBuffer.append((char)(n4 + 48));
                n2 %= n3;
                n3 /= 10;
            }
        }
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    @Override
    public final CharSequence getCanonicalLexicalRepresentation() {
        if (this.hasTimezone() && this.getTimezoneInMinutes() != 0) {
            return this.adjustTimezone(0).getStringValueCS();
        }
        return this.getStringValueCS();
    }

    @Override
    public final DateTimeValue toDateTime() {
        return new DateTimeValue(1972, 12, 31, this.a, this.b, this.c, this.d, this.getTimezoneInMinutes());
    }

    @Override
    public final GregorianCalendar getCalendar() {
        Cloneable cloneable;
        int n2;
        while (true) {
            n2 = timeValue.hasTimezone() ? timeValue.getTimezoneInMinutes() * 60000 : 0;
            cloneable = new SimpleTimeZone(n2, "LLL");
            cloneable = new GregorianCalendar((TimeZone)cloneable);
            ((Calendar)cloneable).setLenient(false);
            if (n2 >= ((GregorianCalendar)cloneable).getMinimum(15) && n2 <= ((GregorianCalendar)cloneable).getMaximum(15)) break;
            TimeValue timeValue = timeValue.adjustTimezone(0);
        }
        ((Calendar)cloneable).set(1972, 11, 31, timeValue.a, timeValue.b, timeValue.c);
        ((Calendar)cloneable).set(14, timeValue.d / 1000000);
        ((Calendar)cloneable).set(15, n2);
        ((Calendar)cloneable).set(16, 0);
        ((Calendar)cloneable).getTime();
        return cloneable;
    }

    @Override
    public final AtomicValue copyAsSubType(AtomicType atomicType) {
        TimeValue timeValue = new TimeValue(this.a, this.b, this.c, this.d, this.getTimezoneInMinutes(), "");
        new TimeValue(this.a, this.b, this.c, this.d, this.getTimezoneInMinutes(), "").typeLabel = atomicType;
        return timeValue;
    }

    @Override
    public final TimeValue adjustTimezone(int n2) {
        DateTimeValue dateTimeValue = ((CalendarValue)this).toDateTime().adjustTimezone(n2);
        return new TimeValue(dateTimeValue.getHour(), dateTimeValue.getMinute(), dateTimeValue.getSecond(), dateTimeValue.getNanosecond(), dateTimeValue.getTimezoneInMinutes(), "");
    }

    @Override
    public final AtomicValue getComponent(AccessorFn.Component object) {
        switch (object) {
            case HOURS: {
                return Int64Value.makeIntegerValue(this.a);
            }
            case MINUTES: {
                return Int64Value.makeIntegerValue(this.b);
            }
            case SECONDS: {
                object = BigDecimal.valueOf(this.d);
                object = ((BigDecimal)object).divide(BigDecimalValue.BIG_DECIMAL_ONE_BILLION, 6, RoundingMode.HALF_UP);
                object = ((BigDecimal)object).add(BigDecimal.valueOf(this.c));
                return new BigDecimalValue((BigDecimal)object);
            }
            case WHOLE_SECONDS: {
                return Int64Value.makeIntegerValue(this.c);
            }
            case MICROSECONDS: {
                return new Int64Value(this.d / 1000);
            }
            case NANOSECONDS: {
                return new Int64Value(this.d);
            }
            case TIMEZONE: {
                if (this.hasTimezone()) {
                    return DayTimeDurationValue.fromMilliseconds(60000L * (long)this.getTimezoneInMinutes());
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for time: " + (Object)object);
    }

    public final int compareTo(Object object) {
        object = (TimeValue)object;
        if (this.getTimezoneInMinutes() == ((CalendarValue)object).getTimezoneInMinutes()) {
            if (this.a != ((TimeValue)object).a) {
                return IntegerValue.signum(this.a - ((TimeValue)object).a);
            }
            if (this.b != ((TimeValue)object).b) {
                return IntegerValue.signum(this.b - ((TimeValue)object).b);
            }
            if (this.c != ((TimeValue)object).c) {
                return IntegerValue.signum(this.c - ((TimeValue)object).c);
            }
            if (this.d != ((TimeValue)object).d) {
                return IntegerValue.signum(this.d - ((TimeValue)object).d);
            }
            return 0;
        }
        return ((CalendarValue)this).toDateTime().compareTo(((CalendarValue)object).toDateTime());
    }

    @Override
    public final int compareTo(CalendarValue calendarValue, int n2) {
        if (!(calendarValue instanceof TimeValue)) {
            throw new ClassCastException("Time values are not comparable to " + calendarValue.getClass());
        }
        TimeValue timeValue = (TimeValue)calendarValue;
        if (this.getTimezoneInMinutes() == timeValue.getTimezoneInMinutes()) {
            return this.compareTo(calendarValue);
        }
        return ((CalendarValue)((CalendarValue)this).toDateTime()).compareTo(((CalendarValue)timeValue).toDateTime(), n2);
    }

    @Override
    public final Comparable getSchemaComparable() {
        return new a(this, 0);
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof TimeValue && this.compareTo(object) == 0;
    }

    public final int hashCode() {
        return DateTimeValue.a(1951, (byte)10, (byte)11, this.a, this.b, this.c, this.d, this.getTimezoneInMinutes());
    }

    @Override
    public final TimeValue add(DurationValue object) {
        if (object instanceof DayTimeDurationValue) {
            object = ((CalendarValue)this).toDateTime().add((DurationValue)object);
            return new TimeValue(((DateTimeValue)object).getHour(), ((DateTimeValue)object).getMinute(), ((DateTimeValue)object).getSecond(), ((DateTimeValue)object).getNanosecond(), this.getTimezoneInMinutes(), "");
        }
        object = new XPathException("Time+Duration arithmetic is supported only for xs:dayTimeDuration");
        ((XPathException)object).setErrorCode("XPTY0004");
        ((XPathException)object).setIsTypeError(true);
        throw object;
    }

    @Override
    public final DayTimeDurationValue subtract(CalendarValue object, XPathContext xPathContext) {
        if (!(object instanceof TimeValue)) {
            object = new XPathException("First operand of '-' is a time, but the second is not");
            ((XPathException)object).setIsTypeError(true);
            throw object;
        }
        return super.subtract((CalendarValue)object, xPathContext);
    }

    private final class a
    implements Comparable {
        private /* synthetic */ TimeValue a;

        private a(TimeValue timeValue) {
            this.a = timeValue;
        }

        public final int compareTo(Object object) {
            if (object instanceof a) {
                a a2 = this;
                DateTimeValue dateTimeValue = ((CalendarValue)a2.a).toDateTime();
                a2 = (a)object;
                object = ((CalendarValue)a2.a).toDateTime();
                return ((AtomicValue)dateTimeValue).getSchemaComparable().compareTo(((AtomicValue)object).getSchemaComparable());
            }
            return Integer.MIN_VALUE;
        }

        public final boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public final int hashCode() {
            return ((AtomicValue)((CalendarValue)this.a).toDateTime()).getSchemaComparable().hashCode();
        }

        /* synthetic */ a(TimeValue timeValue, byte by) {
            this(timeValue);
        }
    }
}

