/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.ComparisonException;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class UntypedAtomicValue
extends StringValue {
    public static final UntypedAtomicValue ZERO_LENGTH_UNTYPED = new UntypedAtomicValue("");
    private int a = -1;
    private ConversionResult b = null;

    public UntypedAtomicValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : charSequence;
        this.typeLabel = BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType atomicType) {
        UntypedAtomicValue untypedAtomicValue = new UntypedAtomicValue(this.value);
        new UntypedAtomicValue(this.value).b = this.b;
        untypedAtomicValue.a = this.a;
        untypedAtomicValue.typeLabel = atomicType;
        return untypedAtomicValue;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public int compareTo(AtomicValue object, StringCollator object2, XPathContext xPathContext) {
        if (object instanceof NumericValue) {
            object2 = null;
            if (this.a == 517) {
                try {
                    object2 = (DoubleValue)this.b.asAtomic();
                }
                catch (ValidationException validationException) {
                    throw new NumberFormatException(validationException.getMessage());
                }
            }
            if (object2 == null) {
                try {
                    object2 = new DoubleValue(xPathContext.getConfiguration().getConversionRules().getStringToDoubleConverter().stringToNumber(this.value));
                }
                catch (NumberFormatException numberFormatException) {
                    object2 = new XPathException("Cannot convert untyped atomic value '" + this.getStringValue() + "' to a double ", "FORG0001");
                    throw new ComparisonException((XPathException)object2);
                }
                this.a = 517;
                this.b = object2;
            }
            return ((NumericValue)object2).compareTo((NumericValue)object);
        }
        if (object instanceof StringValue) {
            if (object2 instanceof CodepointCollator) {
                return CodepointCollator.compareCS(this.getStringValueCS(), ((AtomicValue)object).getStringValueCS());
            }
            return object2.compareStrings(this.getStringValue(), ((AtomicValue)object).getStringValue());
        }
        object2 = xPathContext.getConfiguration();
        object2 = ((Configuration)object2).getConversionRules().getConverter(BuiltInAtomicType.UNTYPED_ATOMIC, ((AtomicValue)object).getItemType());
        if ((object2 = ((Converter)object2).convert(this)) instanceof ValidationFailure) {
            object = new XPathException("Cannot convert untyped atomic value '" + this.getStringValue() + "' to type " + ((AtomicValue)object).getItemType(), "FORG0001");
            throw new ComparisonException((XPathException)object);
        }
        return ((Comparable)object2).compareTo(object);
    }

    public synchronized ConversionResult getConversionResultIfKnown(int n2) {
        if (this.a == n2) {
            return this.b;
        }
        return null;
    }

    public synchronized ConversionResult obtainConversionResult(int n2, StringConverter stringConverter) {
        ConversionResult conversionResult = this.getConversionResultIfKnown(n2);
        if (conversionResult == null) {
            this.a = n2;
            this.b = stringConverter.convertString(this.value);
            return this.b;
        }
        return conversionResult;
    }

    public synchronized void setConversionResult(int n2, AtomicValue atomicValue) {
        this.a = n2;
        this.b = atomicValue;
    }

    @Override
    public String toShortString() {
        return "u" + super.toShortString();
    }
}

