/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;

public class Whitespace {
    public static final int PRESERVE = 0;
    public static final int REPLACE = 1;
    public static final int COLLAPSE = 2;
    public static final int TRIM = 3;
    public static final int NONE = 0;
    public static final int IGNORABLE = 1;
    public static final int ALL = 2;
    public static final int UNSPECIFIED = 3;
    public static final int XSLT = 4;
    private static boolean[] a = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true};

    private Whitespace() {
    }

    public static boolean isWhitespace(int n2) {
        switch (n2) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static CharSequence applyWhitespaceNormalization(int n2, CharSequence charSequence) {
        switch (n2) {
            case 0: {
                return charSequence;
            }
            case 1: {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
                block9: for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                    char c2 = charSequence.charAt(i2);
                    switch (c2) {
                        case '\t': 
                        case '\n': 
                        case '\r': {
                            fastStringBuffer.append(' ');
                            continue block9;
                        }
                        default: {
                            fastStringBuffer.append(c2);
                        }
                    }
                }
                return fastStringBuffer;
            }
            case 2: {
                return Whitespace.collapseWhitespace(charSequence);
            }
            case 3: {
                return Whitespace.trimWhitespace(charSequence);
            }
        }
        throw new IllegalArgumentException("Unknown whitespace facet value");
    }

    public static CharSequence removeAllWhitespace(CharSequence charSequence) {
        if (Whitespace.containsWhitespace(charSequence)) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                char c2 = charSequence.charAt(i2);
                if (c2 <= ' ' && a[c2]) continue;
                fastStringBuffer.append(c2);
            }
            return fastStringBuffer;
        }
        return charSequence;
    }

    public static CharSequence removeLeadingWhitespace(CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 == 0 || charSequence.charAt(0) > ' ') {
            return charSequence;
        }
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 <= ' ' && a[c2]) continue;
            n3 = i2;
            break;
        }
        if (n3 == 0) {
            return charSequence;
        }
        if (n3 < 0 || n3 == n2) {
            return "";
        }
        return charSequence.subSequence(n3, n2);
    }

    public static boolean containsWhitespace(CharSequence charSequence) {
        int n2 = charSequence.length() - 1;
        while (n2 >= 0) {
            char c2;
            if ((c2 = charSequence.charAt(n2--)) > ' ' || !a[c2]) continue;
            return true;
        }
        return false;
    }

    public static boolean isWhite(CharSequence charSequence) {
        if (charSequence instanceof CompressedWhitespace) {
            return true;
        }
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2;
            if ((c2 = charSequence.charAt(n3++)) <= ' ' && a[c2]) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhite(char c2) {
        return c2 <= ' ' && a[c2];
    }

    public static CharSequence normalizeWhitespace(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        block3: for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': {
                    fastStringBuffer.append(' ');
                    continue block3;
                }
                default: {
                    fastStringBuffer.append(c2);
                }
            }
        }
        return fastStringBuffer;
    }

    public static CharSequence collapseWhitespace(CharSequence charSequence) {
        int n2;
        if (!Whitespace.containsWhitespace(charSequence)) {
            return charSequence;
        }
        int n3 = charSequence.length();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n3);
        boolean bl2 = true;
        block3: for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            n2 = c2;
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl2) continue block3;
                    fastStringBuffer.append(' ');
                    bl2 = true;
                    continue block3;
                }
                default: {
                    fastStringBuffer.append((char)n2);
                    bl2 = false;
                }
            }
        }
        n2 = fastStringBuffer.length();
        if (n2 > 0 && fastStringBuffer.charAt(n2 - '\u0001') == ' ') {
            fastStringBuffer.setLength(n2 - '\u0001');
        }
        return fastStringBuffer;
    }

    public static CharSequence trimWhitespace(CharSequence charSequence) {
        char c2;
        if (charSequence.length() == 0) {
            return charSequence;
        }
        int n2 = 0;
        int n3 = charSequence.length() - 1;
        while ((c2 = charSequence.charAt(n2)) <= ' ' && a[c2]) {
            if (n2++ < n3) continue;
            return "";
        }
        while ((c2 = charSequence.charAt(n3)) <= ' ' && a[c2]) {
            --n3;
        }
        if (n2 == 0 && n3 == charSequence.length() - 1) {
            return charSequence;
        }
        return charSequence.subSequence(n2, n3 + 1);
    }

    public static String trim(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return Whitespace.trimWhitespace(charSequence).toString();
    }

    public static class Tokenizer
    implements UnfailingIterator<StringValue> {
        private char[] a;
        private int b;

        public Tokenizer(char[] cArray) {
            this.a = cArray;
            this.b = 0;
        }

        public Tokenizer(CharSequence charSequence) {
            this.a = CharSlice.toCharArray(charSequence);
            this.b = 0;
        }

        @Override
        public StringValue next() {
            int n2;
            int n3;
            int n4 = this.a.length;
            for (n3 = this.b; n3 < n4 && Whitespace.isWhite(this.a[n3]); ++n3) {
            }
            if (n3 >= n4) {
                return null;
            }
            for (n2 = n3; n2 < n4 && !Whitespace.isWhite(this.a[n2]); ++n2) {
            }
            this.b = n2;
            return StringValue.makeStringValue(new CharSlice(this.a, n3, n2 - n3));
        }

        @Override
        public void close() {
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }
}

