/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.DurationValue;

public final class YearMonthDurationValue
extends DurationValue
implements Comparable<YearMonthDurationValue> {
    private YearMonthDurationValue() {
        this.typeLabel = BuiltInAtomicType.YEAR_MONTH_DURATION;
    }

    public static ConversionResult makeYearMonthDurationValue(CharSequence object) {
        if ((object = DurationValue.makeDuration((CharSequence)object, true, false)) instanceof ValidationFailure) {
            return object;
        }
        object = (DurationValue)object;
        return YearMonthDurationValue.fromMonths((((DurationValue)object).getYears() * 12 + ((DurationValue)object).getMonths()) * ((DurationValue)object).signum());
    }

    @Override
    public final AtomicValue copyAsSubType(AtomicType atomicType) {
        YearMonthDurationValue yearMonthDurationValue = YearMonthDurationValue.fromMonths(this.getLengthInMonths());
        YearMonthDurationValue.fromMonths(this.getLengthInMonths()).typeLabel = atomicType;
        return yearMonthDurationValue;
    }

    @Override
    public final BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.YEAR_MONTH_DURATION;
    }

    @Override
    public final CharSequence getPrimitiveStringValue() {
        int n2 = this.getYears();
        int n3 = this.getMonths();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (this.negative) {
            fastStringBuffer.append('-');
        }
        fastStringBuffer.append('P');
        if (n2 != 0) {
            fastStringBuffer.append(n2 + "Y");
        }
        if (n3 != 0 || n2 == 0) {
            fastStringBuffer.append(n3 + "M");
        }
        return fastStringBuffer;
    }

    public final int getLengthInMonths() {
        return this.months * (this.negative ? -1 : 1);
    }

    public static YearMonthDurationValue fromMonths(int n2) {
        YearMonthDurationValue yearMonthDurationValue = new YearMonthDurationValue();
        new YearMonthDurationValue().negative = n2 < 0;
        yearMonthDurationValue.months = n2 < 0 ? -n2 : n2;
        yearMonthDurationValue.seconds = 0L;
        yearMonthDurationValue.nanoseconds = 0;
        return yearMonthDurationValue;
    }

    @Override
    public final YearMonthDurationValue multiply(long l2) {
        if (Math.abs(l2) < 30000L && Math.abs(this.months) < 30000) {
            return YearMonthDurationValue.fromMonths((int)l2 * this.getLengthInMonths());
        }
        return this.multiply((double)l2);
    }

    @Override
    public final YearMonthDurationValue multiply(double d2) {
        if (Double.isNaN(d2)) {
            XPathException xPathException = new XPathException("Cannot multiply a duration by NaN");
            xPathException.setErrorCode("FOCA0005");
            throw xPathException;
        }
        double d3 = this.getLengthInMonths();
        double d4 = d2 * d3;
        if (Double.isInfinite(d4) || d4 > 2.147483647E9 || d4 < -2.147483648E9) {
            XPathException xPathException = new XPathException("Overflow when multiplying a duration by a number");
            xPathException.setErrorCode("FODT0002");
            throw xPathException;
        }
        return YearMonthDurationValue.fromMonths((int)Math.round(d4));
    }

    @Override
    public final DurationValue divide(double d2) {
        if (Double.isNaN(d2)) {
            XPathException xPathException = new XPathException("Cannot divide a duration by NaN");
            xPathException.setErrorCode("FOCA0005");
            throw xPathException;
        }
        double d3 = this.getLengthInMonths();
        double d4 = d3 / d2;
        if (Double.isInfinite(d4) || d4 > 2.147483647E9 || d4 < -2.147483648E9) {
            XPathException xPathException = new XPathException("Overflow when dividing a duration by a number");
            xPathException.setErrorCode("FODT0002");
            throw xPathException;
        }
        return YearMonthDurationValue.fromMonths((int)Math.round(d4));
    }

    @Override
    public final BigDecimalValue divide(DurationValue object) {
        if (object instanceof YearMonthDurationValue) {
            BigDecimal bigDecimal = BigDecimal.valueOf(this.getLengthInMonths());
            if (((BigDecimal)(object = BigDecimal.valueOf(((YearMonthDurationValue)object).getLengthInMonths()))).signum() == 0) {
                object = new XPathException("Divide by zero (durations)");
                ((XPathException)object).setErrorCode("FOAR0001");
                throw object;
            }
            return new BigDecimalValue(bigDecimal.divide((BigDecimal)object, 20, RoundingMode.HALF_EVEN));
        }
        XPathException xPathException = new XPathException("Cannot divide two durations of different type");
        xPathException.setErrorCode("XPTY0004");
        throw xPathException;
    }

    @Override
    public final DurationValue add(DurationValue object) {
        if (object instanceof YearMonthDurationValue) {
            return YearMonthDurationValue.fromMonths(this.getLengthInMonths() + ((YearMonthDurationValue)object).getLengthInMonths());
        }
        object = new XPathException("Cannot add two durations of different type");
        ((XPathException)object).setErrorCode("XPTY0004");
        throw object;
    }

    @Override
    public final DurationValue subtract(DurationValue object) {
        if (object instanceof YearMonthDurationValue) {
            return YearMonthDurationValue.fromMonths(this.getLengthInMonths() - ((YearMonthDurationValue)object).getLengthInMonths());
        }
        object = new XPathException("Cannot subtract two durations of different type");
        ((XPathException)object).setErrorCode("XPTY0004");
        throw object;
    }

    @Override
    public final DurationValue negate() {
        return YearMonthDurationValue.fromMonths(-this.getLengthInMonths());
    }

    @Override
    public final int compareTo(YearMonthDurationValue yearMonthDurationValue) {
        return Integer.compare(this.getLengthInMonths(), yearMonthDurationValue.getLengthInMonths());
    }

    @Override
    public final AtomicMatchKey getXPathComparable(boolean bl2, StringCollator stringCollator, int n2) {
        return this;
    }
}

