/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.EmptySequence;

public class JAXPVariableReference
extends Expression
implements Callable {
    private StructuredQName a;
    private XPathVariableResolver b;

    public JAXPVariableReference(StructuredQName structuredQName, XPathVariableResolver xPathVariableResolver) {
        this.a = structuredQName;
        this.b = xPathVariableResolver;
    }

    @Override
    public String getExpressionName() {
        return "$" + this.a.getDisplayName();
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        return new JAXPVariableReference(this.a, this.b);
    }

    @Override
    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public int computeSpecialProperties() {
        return 0x800000;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof JAXPVariableReference && ((JAXPVariableReference)object).a.equals(this.a) && ((JAXPVariableReference)object).b == this.b;
    }

    @Override
    public int computeHashCode() {
        return this.a.hashCode();
    }

    public Sequence<?> call(XPathContext xPathContext, Sequence[] object) {
        object = xPathContext.getConfiguration();
        Object object2 = this.b.resolveVariable(this.a.toJaxpQName());
        if (object2 == null) {
            return EmptySequence.getInstance();
        }
        object = JPConverter.allocate(object2.getClass(), null, (Configuration)object);
        return object.convert(object2, xPathContext);
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        return this.call(xPathContext, (Sequence[])null).iterate();
    }

    @Override
    public String toString() {
        return ((Expression)this).getExpressionName();
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("jaxpVar", this);
        expressionPresenter.emitAttribute("name", this.a);
        expressionPresenter.endElement();
    }
}

