/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xpath.JAXPVariableReference;
import net.sf.saxon.xpath.XPathFunctionLibrary;

public class JAXPXPathStaticContext
extends AbstractStaticContext
implements NamespaceResolver {
    private SlotManager a;
    private XPathFunctionLibrary b;
    private NamespaceContext c = new a(0);
    private XPathVariableResolver d;

    public JAXPXPathStaticContext(Configuration configuration) {
        this.setConfiguration(configuration);
        this.a = configuration.makeSlotManager();
        this.setDefaultFunctionLibrary(31);
        this.b = new XPathFunctionLibrary();
        JAXPXPathStaticContext jAXPXPathStaticContext = this;
        jAXPXPathStaticContext.addFunctionLibrary(jAXPXPathStaticContext.b);
        this.setPackageData(new PackageData(this.getConfiguration()));
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.c = namespaceContext;
    }

    public NamespaceContext getNamespaceContext() {
        return this.c;
    }

    public SlotManager getStackFrameMap() {
        return this.a;
    }

    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.d = xPathVariableResolver;
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.d;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        if (this.b != null) {
            this.b.setXPathFunctionResolver(xPathFunctionResolver);
        }
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        if (this.b != null) {
            return this.b.getXPathFunctionResolver();
        }
        return null;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this;
    }

    @Override
    public String getURIForPrefix(String string, boolean bl2) {
        if (string.isEmpty()) {
            if (bl2) {
                return this.getDefaultElementNamespace();
            }
            return "";
        }
        return this.c.getNamespaceURI(string);
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        if (this.c instanceof NamespaceResolver) {
            return ((NamespaceResolver)((Object)this.c)).iteratePrefixes();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final Expression bindVariable(StructuredQName structuredQName) {
        if (this.d != null) {
            return new JAXPVariableReference(structuredQName, this.d);
        }
        throw new XPathException("Variable is used in XPath expression, but no JAXP VariableResolver is available");
    }

    public void importSchema(Source source) {
        this.getConfiguration().addSchemaSource(source, this.getConfiguration().getErrorListener());
        this.setSchemaAware(true);
    }

    @Override
    public boolean isImportedSchema(String string) {
        return this.getConfiguration().isSchemaAvailable(string);
    }

    @Override
    public Set<String> getImportedSchemaNamespaces() {
        return this.getConfiguration().getImportedNamespaces();
    }

    private static final class a
    implements NamespaceContext,
    NamespaceResolver {
        private a() {
        }

        @Override
        public final String getNamespaceURI(String string) {
            if (string == null) {
                throw new IllegalArgumentException("prefix");
            }
            if (string.equals("")) {
                return "";
            }
            if (string.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if (string.equals("xs")) {
                return "http://www.w3.org/2001/XMLSchema";
            }
            if (string.equals("xsi")) {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
            if (string.equals("saxon")) {
                return "http://saxon.sf.net/";
            }
            return null;
        }

        @Override
        public final String getPrefix(String string) {
            throw new UnsupportedOperationException();
        }

        public final Iterator getPrefixes(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Iterator<String> iteratePrefixes() {
            String[] stringArray = new String[]{"", "xml", "xs", "xsi", "saxon"};
            return Arrays.asList(stringArray).iterator();
        }

        @Override
        public final String getURIForPrefix(String string, boolean bl2) {
            return this.getNamespaceURI(string);
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

