/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.xpath.JAXPXPathStaticContext;
import net.sf.saxon.xpath.XPathExpressionImpl;
import org.xml.sax.InputSource;

public class XPathEvaluator
implements XPath {
    private Configuration a;
    private JAXPXPathStaticContext b;

    public XPathEvaluator() {
        this(Configuration.newConfiguration());
    }

    public XPathEvaluator(Configuration configuration) {
        this.a = configuration;
        this.b = new JAXPXPathStaticContext(configuration);
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    public JAXPXPathStaticContext getStaticContext() {
        return this.b;
    }

    @Override
    public void reset() {
        this.b = new JAXPXPathStaticContext(this.a);
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.b.setXPathVariableResolver(xPathVariableResolver);
    }

    @Override
    public XPathVariableResolver getXPathVariableResolver() {
        return this.b.getXPathVariableResolver();
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        this.b.setXPathFunctionResolver(xPathFunctionResolver);
    }

    @Override
    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.b.getXPathFunctionResolver();
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.b.setNamespaceContext(namespaceContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.b.getNamespaceContext();
    }

    public void importSchema(Source source) {
        this.b.importSchema(source);
        this.b.setSchemaAware(true);
    }

    @Override
    public XPathExpression compile(String object) {
        if (object == null) {
            throw new NullPointerException("expr");
        }
        try {
            Executable executable = new Executable(this.getConfiguration());
            object = ExpressionTool.make((String)object, this.b, 0, -1, null);
            Object object2 = ExpressionVisitor.make(this.b);
            ContextItemStaticInfo contextItemStaticInfo = this.getConfiguration().makeContextItemStaticInfo(Type.ITEM_TYPE, true);
            object = ((Expression)object).typeCheck((ExpressionVisitor)object2, contextItemStaticInfo).optimize((ExpressionVisitor)object2, contextItemStaticInfo);
            object2 = this.b.getConfiguration().makeSlotManager();
            ExpressionTool.allocateSlots((Expression)object, 0, (SlotManager)object2);
            object = new XPathExpressionImpl((Expression)object, executable);
            ((XPathExpressionImpl)object).setStackFrameMap((SlotManager)object2);
            return object;
        }
        catch (XPathException xPathException) {
            throw new XPathExpressionException(xPathException);
        }
    }

    @Override
    public Object evaluate(String object, Object object2, QName qName) {
        object = this.compile((String)object);
        return object.evaluate(object2, qName);
    }

    @Override
    public String evaluate(String object, Object object2) {
        object = this.compile((String)object);
        return object.evaluate(object2);
    }

    @Override
    public Object evaluate(String object, InputSource inputSource, QName qName) {
        if (object == null) {
            throw new NullPointerException("expr");
        }
        if (inputSource == null) {
            throw new NullPointerException("inputSource");
        }
        if (qName == null) {
            throw new NullPointerException("qName");
        }
        object = this.compile((String)object);
        return object.evaluate(inputSource, qName);
    }

    @Override
    public String evaluate(String object, InputSource inputSource) {
        if (object == null) {
            throw new NullPointerException("expr");
        }
        if (inputSource == null) {
            throw new NullPointerException("inputSource");
        }
        object = this.compile((String)object);
        return object.evaluate(inputSource);
    }
}

