/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.ArrayList;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.EmptySequence;

public class XPathFunctionCall
extends FunctionCall
implements Callable {
    private StructuredQName a;
    private XPathFunction b;

    public XPathFunctionCall(StructuredQName structuredQName, XPathFunction xPathFunction) {
        this.b = xPathFunction;
    }

    @Override
    public StructuredQName getFunctionName() {
        return this.a;
    }

    @Override
    public Function getTargetFunction(XPathContext xPathContext) {
        return null;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor expressionVisitor) {
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0;
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        return new XPathFunctionCall(this.a, this.b);
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        Sequence[] sequenceArray = new Sequence[this.getArity()];
        for (int i2 = 0; i2 < sequenceArray.length; ++i2) {
            sequenceArray[i2] = SequenceTool.toLazySequence(this.getArg(i2).iterate(xPathContext));
        }
        return this.call(xPathContext, sequenceArray).iterate();
    }

    public Sequence<?> call(XPathContext xPathContext, Sequence[] object) {
        ArrayList arrayList = new ArrayList(((Sequence[])object).length);
        Configuration configuration = xPathContext.getConfiguration();
        for (Sequence sequence : object) {
            ArrayList arrayList2 = new ArrayList();
            sequence.iterate().forEachOrFail(item -> {
                configuration = PJConverter.allocate(configuration, Type.getItemType(item, ((Configuration)configuration).getTypeHierarchy()), 16384, Object.class);
                arrayList2.add(((PJConverter)((Object)configuration)).convert(item, Object.class, xPathContext));
            });
            if (arrayList2.size() == 1) {
                arrayList.add(arrayList2.get(0));
                continue;
            }
            arrayList.add(arrayList2);
        }
        try {
            object = this.b.evaluate(arrayList);
            if (object == null) {
                return EmptySequence.getInstance();
            }
            JPConverter jPConverter = JPConverter.allocate(object.getClass(), null, configuration);
            return jPConverter.convert(object, xPathContext);
        }
        catch (XPathFunctionException xPathFunctionException) {
            throw new XPathException(xPathFunctionException);
        }
    }

    @Override
    public ItemType getItemType() {
        return Type.ITEM_TYPE;
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }
}

