/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import java.util.Arrays;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.z.IntComplementSet;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntUniversalSet;

public class IntArraySet
implements IntSet {
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private int[] a;
    private int b = -1;

    public IntArraySet() {
        this.a = EMPTY_INT_ARRAY;
    }

    public IntArraySet(IntHashSet intHashSet) {
        this.a = intHashSet.getValues();
        Arrays.sort(this.a);
    }

    public IntArraySet(IntArraySet intArraySet) {
        this.a = new int[intArraySet.a.length];
        System.arraycopy(intArraySet.a, 0, this.a, 0, this.a.length);
    }

    @Override
    public IntSet copy() {
        IntArraySet intArraySet = new IntArraySet();
        new IntArraySet().a = new int[this.a.length];
        System.arraycopy(this.a, 0, intArraySet.a, 0, this.a.length);
        return intArraySet;
    }

    @Override
    public IntSet mutableCopy() {
        return this.copy();
    }

    @Override
    public void clear() {
        this.a = EMPTY_INT_ARRAY;
        this.b = -1;
    }

    @Override
    public int size() {
        return this.a.length;
    }

    @Override
    public boolean isEmpty() {
        return this.a.length == 0;
    }

    public int[] getValues() {
        return this.a;
    }

    @Override
    public boolean contains(int n2) {
        return Arrays.binarySearch(this.a, n2) >= 0;
    }

    @Override
    public boolean remove(int n2) {
        this.b = -1;
        if ((n2 = Arrays.binarySearch(this.a, n2)) < 0) {
            return false;
        }
        int[] nArray = new int[this.a.length - 1];
        if (n2 > 0) {
            System.arraycopy(this.a, 0, nArray, 0, n2);
        }
        if (n2 < nArray.length) {
            System.arraycopy(this.a, n2 + 1, nArray, n2, this.a.length - n2);
        }
        this.a = nArray;
        return true;
    }

    @Override
    public boolean add(int n2) {
        this.b = -1;
        if (this.a.length == 0) {
            this.a = new int[]{n2};
            return true;
        }
        int n3 = Arrays.binarySearch(this.a, n2);
        if (n3 >= 0) {
            return false;
        }
        n3 = -n3 - 1;
        int[] nArray = new int[this.a.length + 1];
        if (n3 > 0) {
            System.arraycopy(this.a, 0, nArray, 0, n3);
        }
        nArray[n3] = n2;
        if (n3 < this.a.length) {
            System.arraycopy(this.a, n3, nArray, n3 + 1, nArray.length - n3);
        }
        this.a = nArray;
        return true;
    }

    public int getFirst() {
        return this.a[0];
    }

    @Override
    public IntIterator iterator() {
        return new IntArrayIterator(this.a, this.a.length);
    }

    @Override
    public IntSet union(IntSet object) {
        if (this.size() == 0) {
            return object.copy();
        }
        if (object.isEmpty()) {
            return this.copy();
        }
        if (object == IntUniversalSet.getInstance()) {
            return object;
        }
        if (object instanceof IntComplementSet) {
            return object.union(this);
        }
        if (this.equals(object)) {
            return this.copy();
        }
        if (object instanceof IntArraySet) {
            int[] nArray = new int[this.size() + object.size()];
            int[] nArray2 = this.a;
            object = ((IntArraySet)object).a;
            int n2 = nArray2.length;
            int n3 = ((Object)object).length;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            do {
                if (nArray2[n5] < object[n6]) {
                    nArray[n4++] = nArray2[n5++];
                } else if (object[n6] < nArray2[n5]) {
                    nArray[n4++] = (int)object[n6++];
                } else {
                    nArray[n4++] = nArray2[n5++];
                    ++n6;
                }
                if (n5 != n2) continue;
                System.arraycopy(object, n6, nArray, n4, n3 - n6);
                return IntArraySet.make(nArray, n4 += n3 - n6);
            } while (n6 != n3);
            System.arraycopy(nArray2, n5, nArray, n4, n2 - n5);
            return IntArraySet.make(nArray, n4 += n2 - n5);
        }
        return IntSet.super.union((IntSet)object);
    }

    public static IntArraySet make(int[] nArray, int n2) {
        int[] nArray2;
        if (nArray.length == n2) {
            nArray2 = nArray;
        } else {
            nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
        }
        return new IntArraySet(nArray2);
    }

    private IntArraySet(int[] nArray) {
        this.a = nArray;
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.a.length << 2);
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            if (i2 == this.a.length - 1) {
                fastStringBuffer.append("" + this.a[i2]);
                continue;
            }
            if (this.a[i2] + 1 != this.a[i2 + 1]) {
                fastStringBuffer.append(this.a[i2] + ",");
                continue;
            }
            int n2 = i2 + 1;
            while (this.a[n2] == this.a[n2 - 1] + 1 && ++n2 != this.a.length) {
            }
            fastStringBuffer.append(this.a[i2] + "-" + this.a[n2 - 1] + ",");
            i2 = n2 - 1;
        }
        return fastStringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof IntArraySet) {
            IntArraySet intArraySet = (IntArraySet)object;
            return this.hashCode() == object.hashCode() && Arrays.equals(this.a, intArraySet.a);
        }
        return object instanceof IntSet && this.a.length == ((IntSet)object).size() && this.containsAll((IntSet)object);
    }

    public int hashCode() {
        if (this.b == -1) {
            int n2 = 936247625;
            IntIterator intIterator = this.iterator();
            while (intIterator.hasNext()) {
                n2 += intIterator.next();
            }
            this.b = n2;
        }
        return this.b;
    }

    public static class IntArrayIterator
    implements IntIterator {
        private int[] a;
        private int b;
        private int c = 0;

        public IntArrayIterator(int[] nArray, int n2) {
            this.a = nArray;
            this.b = n2;
        }

        @Override
        public boolean hasNext() {
            return this.c < this.b;
        }

        @Override
        public int next() {
            return this.a[this.c++];
        }
    }
}

