/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import net.sf.saxon.z.IntEmptySet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntUniversalSet;

public class IntComplementSet
implements IntSet {
    private IntSet a;

    public IntComplementSet(IntSet intSet) {
        this.a = intSet.copy();
    }

    public IntSet getExclusions() {
        return this.a;
    }

    @Override
    public IntSet copy() {
        return new IntComplementSet(this.a.copy());
    }

    @Override
    public IntSet mutableCopy() {
        return this.copy();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("IntComplementSet cannot be emptied");
    }

    @Override
    public int size() {
        return Integer.MAX_VALUE - this.a.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(int n2) {
        return !this.a.contains(n2);
    }

    @Override
    public boolean remove(int n2) {
        boolean bl2 = this.contains(n2);
        if (bl2) {
            this.a.add(n2);
        }
        return bl2;
    }

    @Override
    public boolean add(int n2) {
        boolean bl2 = this.contains(n2);
        if (!bl2) {
            this.a.remove(n2);
        }
        return bl2;
    }

    @Override
    public IntIterator iterator() {
        throw new UnsupportedOperationException("Cannot enumerate an infinite set");
    }

    @Override
    public IntSet union(IntSet intSet) {
        return new IntComplementSet(this.a.except(intSet));
    }

    @Override
    public IntSet intersect(IntSet intSet) {
        if (intSet.isEmpty()) {
            return IntEmptySet.getInstance();
        }
        if (intSet == IntUniversalSet.getInstance()) {
            return this.copy();
        }
        if (intSet instanceof IntComplementSet) {
            return new IntComplementSet(this.a.union(((IntComplementSet)intSet).a));
        }
        return intSet.intersect(this);
    }

    @Override
    public IntSet except(IntSet intSet) {
        return new IntComplementSet(this.a.union(intSet));
    }

    @Override
    public boolean containsAll(IntSet object) {
        if (object instanceof IntComplementSet) {
            return ((IntComplementSet)object).a.containsAll(this.a);
        }
        if (object instanceof IntUniversalSet) {
            return !this.a.isEmpty();
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (!this.a.contains(object.next())) continue;
            return false;
        }
        return true;
    }
}

