/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import java.util.Arrays;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.z.IntComplementSet;
import net.sf.saxon.z.IntEmptySet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntUniversalSet;

public class IntHashSet
implements IntSet {
    public static final int MAX_SIZE = 0x40000000;
    public final int ndv;
    private int a;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int[] g;

    public IntHashSet() {
        this(8, Integer.MIN_VALUE);
    }

    public IntHashSet(int n2) {
        this(n2, Integer.MIN_VALUE);
    }

    public IntHashSet(int n2, int n3) {
        this.ndv = n3;
        this.c(n2);
    }

    @Override
    public IntSet copy() {
        if (this.b == 0) {
            return IntEmptySet.getInstance();
        }
        IntHashSet intHashSet = new IntHashSet(this.b, this.ndv);
        new IntHashSet(this.b, this.ndv).a = this.a;
        intHashSet.b = this.b;
        intHashSet.c = this.c;
        intHashSet.d = this.d;
        intHashSet.e = this.e;
        intHashSet.b = this.b;
        intHashSet.f = this.f;
        intHashSet.g = new int[this.g.length];
        System.arraycopy(this.g, 0, intHashSet.g, 0, this.g.length);
        return intHashSet;
    }

    @Override
    public IntSet mutableCopy() {
        return this.copy();
    }

    @Override
    public void clear() {
        this.b = 0;
        for (int i2 = 0; i2 < this.a; ++i2) {
            this.g[i2] = this.ndv;
        }
    }

    @Override
    public int size() {
        return this.b;
    }

    @Override
    public boolean isEmpty() {
        return this.b == 0;
    }

    public int[] getValues() {
        int n2 = 0;
        int[] nArray = new int[this.b];
        int[] nArray2 = this.g;
        int n3 = this.g.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray2[i2];
            if (n4 == this.ndv) continue;
            nArray[n2++] = n4;
        }
        return nArray;
    }

    @Override
    public boolean contains(int n2) {
        return this.g[this.b(n2)] != this.ndv;
    }

    @Override
    public boolean remove(int n2) {
        if (this.g[n2 = this.b(n2)] == this.ndv) {
            return false;
        }
        --this.b;
        while (true) {
            IntHashSet intHashSet;
            int n3;
            this.g[n2] = this.ndv;
            int n4 = n2;
            do {
                if (this.g[n2 = n2 - 1 & this.f] == this.ndv) {
                    return true;
                }
                intHashSet = this;
            } while (n2 <= (n3 = intHashSet.a(intHashSet.g[n2])) && n3 < n4 || n3 < n4 && n4 < n2 || n4 < n2 && n2 <= n3);
            this.g[n4] = this.g[n2];
        }
    }

    @Override
    public boolean add(int n2) {
        if (n2 == this.ndv) {
            throw new IllegalArgumentException("Can't add the 'no data' value");
        }
        int n3 = this.b(n2);
        if (this.g[n3] == this.ndv) {
            ++this.b;
            this.g[n3] = n2;
            if (this.b > 0x40000000) {
                throw new RuntimeException("Too many elements (> 1073741824)");
            }
            if (this.c < this.b && this.b <= this.d) {
                IntHashSet intHashSet = this;
                intHashSet.c(intHashSet.b);
            }
            return true;
        }
        return false;
    }

    private int a(int n2) {
        return n2 * 1327217885 >> this.e & this.f;
    }

    private int b(int n2) {
        int n3 = this.a(n2);
        while (this.g[n3] != this.ndv) {
            if (this.g[n3] == n2) {
                return n3;
            }
            n3 = n3 - 1 & this.f;
        }
        return n3;
    }

    private void c(int n2) {
        int n3;
        if (n2 < this.b) {
            n2 = this.b;
        }
        int n4 = 1;
        for (n3 = 2; n3 < n2 << 2 && n3 < 0x40000000; n3 <<= 1) {
            ++n4;
        }
        n2 = this.a;
        if (n3 == n2) {
            return;
        }
        this.a = n3;
        this.c = n3 / 4;
        this.d = 0x10000000;
        this.e = 31 - n4;
        this.f = n3 - 1;
        this.b = 0;
        int[] nArray = this.g;
        this.g = new int[n3];
        Arrays.fill(this.g, this.ndv);
        if (nArray != null) {
            for (n3 = 0; n3 < n2; ++n3) {
                int n5 = nArray[n3];
                if (n5 == this.ndv) continue;
                ++this.b;
                this.g[this.b((int)n5)] = n5;
            }
        }
    }

    @Override
    public IntIterator iterator() {
        return new a(this);
    }

    public static boolean containsSome(IntSet intSet, IntSet object) {
        if (object instanceof IntEmptySet) {
            return false;
        }
        if (object instanceof IntUniversalSet) {
            return !intSet.isEmpty();
        }
        if (object instanceof IntComplementSet) {
            return !((IntComplementSet)object).getExclusions().containsAll(intSet);
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (!intSet.contains(object.next())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof IntSet) {
            object = (IntHashSet)object;
            return this.size() == ((IntHashSet)object).size() && this.containsAll((IntSet)object);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 936247625;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            n2 += intIterator.next();
        }
        return n2;
    }

    public String toString() {
        return IntHashSet.toString(this.iterator());
    }

    public static String toString(IntIterator intIterator) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        while (intIterator.hasNext()) {
            if (fastStringBuffer.isEmpty()) {
                fastStringBuffer.append("" + intIterator.next());
                continue;
            }
            fastStringBuffer.append(" " + intIterator.next());
        }
        return fastStringBuffer.toString();
    }

    public void diagnosticDump() {
        System.err.println("Contents of IntHashSet");
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        for (int i2 = 0; i2 < this.g.length; ++i2) {
            if (i2 % 10 == 0) {
                System.err.println(fastStringBuffer.toString());
                fastStringBuffer.setLength(0);
            }
            if (this.g[i2] == this.ndv) {
                fastStringBuffer.append("*, ");
                continue;
            }
            fastStringBuffer.append(this.g[i2] + ", ");
        }
        System.err.println(fastStringBuffer.toString());
        fastStringBuffer.setLength(0);
        System.err.println("size: " + this.b);
        System.err.println("ndv: " + this.ndv);
        System.err.println("nlo: " + this.c);
        System.err.println("nhi: " + this.d);
        System.err.println("nmax: " + this.a);
        System.err.println("shift: " + this.e);
        System.err.println("mask: " + this.f);
        System.err.println("Result of iterator:");
        IntIterator intIterator = this.iterator();
        int n2 = 0;
        while (intIterator.hasNext()) {
            if (n2++ % 10 == 0) {
                System.err.println(fastStringBuffer.toString());
                fastStringBuffer.setLength(0);
            }
            fastStringBuffer.append(intIterator.next() + ", ");
        }
        System.err.println(fastStringBuffer.toString());
        System.err.println("=====================");
    }

    private final class a
    implements IntIterator {
        private int a = 0;
        private /* synthetic */ IntHashSet b;

        public a(IntHashSet intHashSet) {
            this.b = intHashSet;
        }

        @Override
        public final boolean hasNext() {
            while (this.a < this.b.g.length) {
                if (this.b.g[this.a] != this.b.ndv) {
                    return true;
                }
                ++this.a;
            }
            return false;
        }

        @Override
        public final int next() {
            return this.b.g[this.a++];
        }
    }
}

