/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import net.sf.saxon.z.IntComplementSet;
import net.sf.saxon.z.IntEmptySet;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntUniversalSet;

public interface IntSet {
    public IntSet copy();

    public IntSet mutableCopy();

    public void clear();

    public int size();

    public boolean isEmpty();

    public boolean contains(int var1);

    public boolean remove(int var1);

    public boolean add(int var1);

    public IntIterator iterator();

    default public boolean containsAll(IntSet object) {
        if (object == IntUniversalSet.getInstance() || object instanceof IntComplementSet) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (this.contains(object.next())) continue;
            return false;
        }
        return true;
    }

    default public IntSet union(IntSet intSet) {
        if (intSet == IntUniversalSet.getInstance()) {
            return intSet;
        }
        if (this.isEmpty()) {
            return intSet.copy();
        }
        if (intSet.isEmpty()) {
            return this.copy();
        }
        if (intSet instanceof IntComplementSet) {
            return intSet.union(this);
        }
        IntHashSet intHashSet = new IntHashSet(this.size() + intSet.size());
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            intHashSet.add(intIterator.next());
        }
        intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            intHashSet.add(intIterator.next());
        }
        return intHashSet;
    }

    default public IntSet intersect(IntSet intSet) {
        if (this.isEmpty() || intSet.isEmpty()) {
            return IntEmptySet.getInstance();
        }
        IntHashSet intHashSet = new IntHashSet(this.size());
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            if (!intSet.contains(n2)) continue;
            intHashSet.add(n2);
        }
        return intHashSet;
    }

    default public IntSet except(IntSet intSet) {
        IntHashSet intHashSet = new IntHashSet(this.size());
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            if (intSet.contains(n2)) continue;
            intHashSet.add(n2);
        }
        return intHashSet;
    }
}

