/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import java.util.Arrays;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.z.IntArraySet;
import net.sf.saxon.z.IntComplementSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntUniversalSet;

public class MonotonicIntSet
implements IntSet {
    private int[] a;
    private int b = 0;

    public MonotonicIntSet() {
        this.a = new int[4];
        this.b = 0;
    }

    @Override
    public IntSet copy() {
        MonotonicIntSet monotonicIntSet = new MonotonicIntSet();
        new MonotonicIntSet().a = Arrays.copyOf(this.a, this.b);
        monotonicIntSet.b = this.b;
        return monotonicIntSet;
    }

    @Override
    public IntSet mutableCopy() {
        return this.copy();
    }

    @Override
    public void clear() {
        if (this.a.length > this.b + 20) {
            this.a = new int[4];
        }
        this.b = 0;
    }

    @Override
    public int size() {
        return this.b;
    }

    @Override
    public boolean isEmpty() {
        return this.b == 0;
    }

    @Override
    public boolean contains(int n2) {
        return Arrays.binarySearch(this.a, 0, this.b, n2) >= 0;
    }

    @Override
    public boolean remove(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(int n2) {
        if (this.b > 0) {
            int n3 = this.a[this.b - 1];
            if (n2 == n3) {
                return false;
            }
            if (n2 < n3) {
                throw new UnsupportedOperationException("Values must be added in monotonic order");
            }
        }
        if (this.b == this.a.length) {
            this.a = Arrays.copyOf(this.a, this.b == 0 ? 4 : this.b << 1);
        }
        this.a[this.b++] = n2;
        return true;
    }

    @Override
    public IntIterator iterator() {
        return new IntArraySet.IntArrayIterator(this.a, this.b);
    }

    @Override
    public IntSet union(IntSet intSet) {
        if (this.size() == 0) {
            return intSet.copy();
        }
        if (intSet.isEmpty()) {
            return this.copy();
        }
        if (intSet == IntUniversalSet.getInstance()) {
            return intSet;
        }
        if (intSet instanceof IntComplementSet) {
            return intSet.union(this);
        }
        if (this.equals(intSet)) {
            return this.copy();
        }
        if (intSet instanceof MonotonicIntSet) {
            int[] nArray = new int[this.size() + intSet.size()];
            int[] nArray2 = this.a;
            int[] nArray3 = ((MonotonicIntSet)intSet).a;
            int n2 = this.b;
            int n3 = ((MonotonicIntSet)intSet).b;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            do {
                if (nArray2[n5] < nArray3[n6]) {
                    nArray[n4++] = nArray2[n5++];
                } else if (nArray3[n6] < nArray2[n5]) {
                    nArray[n4++] = nArray3[n6++];
                } else {
                    nArray[n4++] = nArray2[n5++];
                    ++n6;
                }
                if (n5 != n2) continue;
                System.arraycopy(nArray3, n6, nArray, n4, n3 - n6);
                return MonotonicIntSet.make(nArray, n4 += n3 - n6);
            } while (n6 != n3);
            System.arraycopy(nArray2, n5, nArray, n4, n2 - n5);
            return MonotonicIntSet.make(nArray, n4 += n2 - n5);
        }
        return IntSet.super.union(intSet);
    }

    public static MonotonicIntSet make(int[] nArray, int n2) {
        return new MonotonicIntSet(nArray, n2);
    }

    private MonotonicIntSet(int[] nArray, int n2) {
        this.a = nArray;
        this.b = n2;
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.b << 2);
        for (int i2 = 0; i2 < this.b; ++i2) {
            if (i2 == this.b - 1) {
                fastStringBuffer.append("" + this.a[i2]);
                continue;
            }
            if (this.a[i2] + 1 != this.a[i2 + 1]) {
                fastStringBuffer.append(this.a[i2] + ",");
                continue;
            }
            int n2 = i2 + 1;
            while (this.a[n2] == this.a[n2 - 1] + 1 && ++n2 != this.b) {
            }
            fastStringBuffer.append(this.a[i2] + "-" + this.a[n2 - 1] + ",");
            i2 = n2;
        }
        return fastStringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof MonotonicIntSet) {
            object = (MonotonicIntSet)object;
            if (this.b != ((MonotonicIntSet)object).b) {
                return false;
            }
            for (int i2 = 0; i2 < this.b; ++i2) {
                if (this.a[i2] == ((MonotonicIntSet)object).a[i2]) continue;
                return false;
            }
            return true;
        }
        return object instanceof IntSet && this.b == ((IntSet)object).size() && this.containsAll((IntSet)object);
    }

    public int hashCode() {
        int n2 = 936247625;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            n2 += intIterator.next();
        }
        return n2;
    }
}

