/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.filter;

import java.util.Arrays;
import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.filter.AbstractSinglePixelFilter;

public class HistogramFilter
extends AbstractSinglePixelFilter {
    private int[] a = new int[]{1, 2, 1};
    private int[] b;
    private int c;
    private int d;

    public HistogramFilter() {
        this(256);
    }

    public HistogramFilter(int n2) {
        this.d = n2;
        this.b = new int[n2];
    }

    public int[] getHistogramm() {
        return this.b;
    }

    public int getTotalCount() {
        return this.c;
    }

    public void reset() {
        Arrays.fill(this.b, 0);
        this.c = 0;
    }

    protected void processPixel(Image image) {
        ++this.c;
        int n2 = image.next();
        this.b[n2] = this.b[n2] + 1;
    }

    public void smooth() {
        HistogramFilter histogramFilter = this;
        histogramFilter.fold(histogramFilter.a);
    }

    public void fold(int[] nArray) {
        if (nArray.length % 2 == 0) {
            throw new IllegalArgumentException("folding array must have odd length");
        }
        int[] nArray2 = new int[this.d];
        int n2 = nArray.length / 2;
        int n3 = this.b.length - n2;
        for (int i2 = n2; i2 < n3; ++i2) {
            int n4 = 0;
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                n4 += this.b[i2 - n2 + i3] * nArray[i3];
            }
            nArray2[i2] = n4 / nArray.length;
        }
        this.b = nArray2;
    }

    public int adaptiveThreshold() {
        HistogramFilter histogramFilter = this;
        return histogramFilter.adaptiveThreshold(histogramFilter.d / 2);
    }

    public int adaptiveThreshold(int n2) {
        int n3 = this.a(0, n2);
        int n4 = this.a(n2, this.d);
        if (Math.abs((n3 = (n3 + n4) / 2) - n2) <= 1) {
            return n2;
        }
        return this.adaptiveThreshold(n3);
    }

    private int a(int n2, int n3) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        while (n2 < n3) {
            f2 += (float)(this.b[n2] * n2);
            f3 += (float)this.b[n2];
            ++n2;
        }
        if (f3 == 0.0f) {
            f3 = 1.0f;
        }
        return (int)(f2 / f3);
    }
}

