/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.filter;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.ImageFilter;
import net.sourceforge.javaocr.filter.IntegralImageFilter;
import net.sourceforge.javaocr.ocr.PixelImage;

public class MedianFilter
implements ImageFilter {
    protected final Image destination;
    protected final int halfWindow;
    protected final int squareWindow;
    private final PixelImage a;
    protected final IntegralImageFilter integralImageFilter;

    public MedianFilter(Image image, int n2) {
        this.destination = image;
        this.halfWindow = n2 / 2;
        this.squareWindow = ((this.halfWindow << 1) + 1) * ((this.halfWindow << 1) + 1);
        this.a = new PixelImage(image.getWidth(), image.getHeight());
        this.integralImageFilter = new IntegralImageFilter(this.a);
    }

    public void process(Image image) {
        this.integralImageFilter.process(image);
        int n2 = image.getHeight();
        int n3 = image.getWidth();
        n2 -= this.halfWindow;
        n3 -= this.halfWindow;
        for (int i2 = this.halfWindow; i2 < n2; ++i2) {
            for (int i3 = this.halfWindow; i3 < n3; ++i3) {
                this.destination.put(i3, i2, this.computePixel(image, i2, i3));
            }
        }
    }

    protected int computePixel(Image image, int n2, int n3) {
        int n4 = this.integralImageFilter.windowValue(n3 - this.halfWindow, n2 - this.halfWindow, n3 + this.halfWindow, n2 + this.halfWindow);
        return n4 / this.squareWindow;
    }

    public int getHalfWindow() {
        return this.halfWindow;
    }

    public int getSquareWindow() {
        return this.squareWindow;
    }

    public IntegralImageFilter getIntegralImageFilter() {
        return this.integralImageFilter;
    }
}

