/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.filter;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.filter.MedianFilter;
import net.sourceforge.javaocr.filter.SquaredIntergalImageFilter;
import net.sourceforge.javaocr.ocr.PixelImage;

public class SauvolaBinarisationFilter
extends MedianFilter {
    protected final int above;
    protected final int below;
    protected final int range;
    protected final double weight;
    private SquaredIntergalImageFilter a;
    private PixelImage b;

    public SauvolaBinarisationFilter(int n2, int n3, Image image, int n4, double d2, int n5) {
        super(image, n5);
        this.above = n2;
        this.below = n3;
        this.range = n4 / 2;
        this.weight = d2;
        this.b = new PixelImage(image.getWidth(), image.getHeight());
        this.a = new SquaredIntergalImageFilter(this.b);
    }

    public void process(Image image) {
        this.a.process(image);
        super.process(image);
    }

    protected int computePixel(Image image, int n2, int n3) {
        double d2 = super.computePixel(image, n2, n3);
        double d3 = this.a.windowValue(n3 - this.getHalfWindow(), n2 - this.getHalfWindow(), n3 + this.getHalfWindow(), n2 + this.getHalfWindow()) / this.getSquareWindow();
        double d4 = d2;
        double d5 = d3 - d4 * d4;
        double d6 = d2 * (1.0 + this.weight * (Math.sqrt(d5) / (double)this.range - 1.0));
        if ((double)image.get(n3, n2) > d6) {
            return this.above;
        }
        return this.below;
    }

    protected int retrievePixel(Image image, int n2, int n3) {
        return image.get(n3, n2);
    }

    public int getAbove() {
        return this.above;
    }

    public int getBelow() {
        return this.below;
    }

    public int getRange() {
        return this.range;
    }

    public double getWeight() {
        return this.weight;
    }

    public SquaredIntergalImageFilter getSquaredIntergalImageFilter() {
        return this.a;
    }
}

