/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.matcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.javaocr.matcher.FreeSpacesContainer;
import net.sourceforge.javaocr.matcher.Match;
import net.sourceforge.javaocr.matcher.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeSpacesMatcher
implements Matcher {
    private Map<Integer, Set<Character>> a = new HashMap<Integer, Set<Character>>();

    @Override
    public List<Match> classify(double[] dArray) {
        int n2 = (int)dArray[0];
        Set<Character> set = this.a.get(n2);
        if (set == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Match> arrayList = new ArrayList<Match>();
        for (Comparable<Character> comparable : set) {
            comparable = new Match((Character)comparable, 1.0, 0.0, 0.0);
            arrayList.add((Match)comparable);
        }
        return arrayList;
    }

    public void train(char c2, int n2) {
        Set<Character> set = this.a.get(n2);
        if (set == null) {
            set = new HashSet<Character>();
            this.a.put(n2, set);
        }
        set.add(Character.valueOf(c2));
    }

    public Map<Integer, Set<Character>> getCounts() {
        return this.a;
    }

    public List<FreeSpacesContainer> getContainers() {
        ArrayList<FreeSpacesContainer> arrayList = new ArrayList<FreeSpacesContainer>();
        for (Integer n2 : this.getCounts().keySet()) {
            FreeSpacesContainer freeSpacesContainer = new FreeSpacesContainer();
            freeSpacesContainer.setCount(n2);
            Set<Character> object = this.getCounts().get(n2);
            freeSpacesContainer.setCharacters(object.toArray(new Character[0]));
            arrayList.add(freeSpacesContainer);
        }
        return arrayList;
    }

    public void setContainers(List<FreeSpacesContainer> object) {
        object = object.iterator();
        while (object.hasNext()) {
            FreeSpacesContainer freeSpacesContainer = (FreeSpacesContainer)object.next();
            for (Character c2 : freeSpacesContainer.getCharacters()) {
                this.train(c2.charValue(), freeSpacesContainer.getCount());
            }
        }
    }
}

