/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.javaocr.cluster.Metric;
import net.sourceforge.javaocr.matcher.Match;
import net.sourceforge.javaocr.matcher.MetricContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricMatcher {
    private Map<Metric, Character> a = new HashMap<Metric, Character>();
    private Map<Metric, Double> b = new HashMap<Metric, Double>();
    private Map<Metric, Double> c = new HashMap<Metric, Double>();

    public void addMetric(Metric metric, Character c2, double d2, double d3) {
        this.a.put(metric, c2);
        this.b.put(metric, d2);
        this.c.put(metric, d3);
    }

    public List<Match> classify(double[] dArray) {
        ArrayList<Match> arrayList = new ArrayList<Match>();
        for (Metric metric : this.a.keySet()) {
            double d2 = metric.distance(dArray);
            Match object = new Match(this.a.get(metric), d2, this.b.get(metric), this.c.get(metric));
            arrayList.add(object);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public Map<Metric, Character> getMetrics() {
        return this.a;
    }

    public Map<Metric, Double> getRed() {
        return this.c;
    }

    public Map<Metric, Double> getYellow() {
        return this.b;
    }

    public List<MetricContainer> containers() {
        ArrayList<MetricContainer> arrayList = new ArrayList<MetricContainer>();
        for (Metric metric : this.getMetrics().keySet()) {
            MetricContainer metricContainer = new MetricContainer();
            metricContainer.setMetric(metric);
            metricContainer.setRed(this.getRed().get(metric));
            metricContainer.setYellow(this.getYellow().get(metric));
            metricContainer.setCharacter(this.getMetrics().get(metric));
            arrayList.add(metricContainer);
        }
        return arrayList;
    }

    public void setContainers(Collection<? extends MetricContainer> object) {
        object = object.iterator();
        while (object.hasNext()) {
            MetricContainer metricContainer = (MetricContainer)object.next();
            this.addMetric(metricContainer.getMetric(), metricContainer.getCharacter(), metricContainer.getYellow(), metricContainer.getRed());
        }
    }
}

