/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocr;

import net.sourceforge.javaocr.Image;

public abstract class AbstractLinearImage
implements Image {
    protected final int arrayWidth;
    protected final int arrayHeight;
    protected final int originX;
    protected final int originY;
    protected final int width;
    protected final int height;
    protected int currentIndex;
    protected final float aspectRatio;
    private int a;
    private int b;

    protected AbstractLinearImage(int n2, int n3) {
        this(n2, n3, 0, 0, n2, n3);
    }

    protected AbstractLinearImage(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.height = n7;
        this.width = n6;
        this.arrayHeight = n3;
        this.originX = n4;
        this.originY = n5;
        this.arrayWidth = n2;
        this.aspectRatio = (float)n6 / (float)n7;
    }

    public abstract int get();

    public abstract void put(int var1);

    public int get(int n2, int n3) {
        this.setCurrentIndex(n2, n3);
        return this.get();
    }

    protected void setCurrentIndex(int n2, int n3) {
        this.currentIndex = (n3 + this.originY) * this.arrayWidth + n2 + this.originX;
    }

    public void put(int n2, int n3, int n4) {
        this.setCurrentIndex(n2, n3);
        this.put(n4);
    }

    public int getArrayHeight() {
        return this.arrayHeight;
    }

    public int getArrayWidth() {
        return this.arrayWidth;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public boolean horizontalSpanEquals(int n2, int n3, int n4, int n5) {
        this.iterateH(n2, n3, n4);
        while (this.hasNext()) {
            if (this.next() == n5) continue;
            return false;
        }
        return true;
    }

    public boolean verticalSpanEquals(int n2, int n3, int n4, int n5) {
        this.iterateV(n2, n3, n4);
        while (this.hasNext()) {
            if (this.next() == n5) continue;
            return false;
        }
        return true;
    }

    public void iterateV(int n2, int n3, int n4) {
        this.currentIndex = (n3 + this.originY - 1) * this.arrayWidth + n2 + this.originX;
        this.b = (n4 + this.originY) * this.arrayWidth + n2 + this.originX;
        this.a = this.arrayWidth;
    }

    public void iterateH(int n2, int n3, int n4) {
        n2 = (n2 + this.originY) * this.arrayWidth + this.originX - 1;
        this.currentIndex = n2 + n3;
        this.b = n2 + n4 + 1;
        this.a = 1;
    }

    public void iterateH(int n2) {
        this.iterateH(n2, 0, this.width - 1);
    }

    public void iterateV(int n2) {
        this.iterateV(n2, 0, this.height - 1);
    }

    public boolean hasNext() {
        return this.currentIndex < this.b;
    }

    public int next() {
        this.currentIndex += this.a;
        return this.get();
    }

    public void next(int n2) {
        this.currentIndex += this.a;
        this.put(n2);
    }

    public void copy(Image image) {
        int n2 = this.getHeight();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.iterateH(i2);
            image.iterateH(i2);
            while (this.hasNext()) {
                image.next(this.next());
            }
        }
    }

    public void flip(Image image) {
        int n2 = this.getWidth();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.iterateV(i2);
            image.iterateH(i2);
            while (this.hasNext()) {
                image.next(this.next());
            }
        }
    }

    public String toString() {
        return "AbstractLinearImage{arrayHeight=" + this.arrayHeight + ", arrayWidth=" + this.arrayWidth + ", aspectRatio=" + this.aspectRatio + ", height=" + this.height + ", originX=" + this.originX + ", originY=" + this.originY + ", width=" + this.width + '}';
    }

    public Image row(int n2) {
        return this.chisel(0, n2, this.width, 1);
    }

    public Image column(int n2) {
        return this.chisel(n2, 0, 1, this.height);
    }
}

