/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocrPlugins.OCRDemo;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.CharacterRange;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.OCRScanner;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.TrainingImage;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.TrainingImageLoader;
import net.sourceforge.javaocr.scanner.PixelImage;

public class OCRScannerDemo {
    private boolean a = true;
    private Image b;
    private OCRScanner c = new OCRScanner();

    public void loadTrainingImages(String string) {
        if (this.a) {
            System.err.println("loadTrainingImages(" + string + ")");
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        try {
            this.c.clearTrainingImages();
            TrainingImageLoader trainingImageLoader = new TrainingImageLoader();
            HashMap<Character, ArrayList<TrainingImage>> hashMap = new HashMap<Character, ArrayList<TrainingImage>>();
            if (this.a) {
                System.err.println("ascii.png");
            }
            trainingImageLoader.load(string + "ascii.png", new CharacterRange(33, 126), hashMap);
            if (this.a) {
                System.err.println("hpljPica.jpg");
            }
            trainingImageLoader.load(string + "hpljPica.jpg", new CharacterRange(33, 126), hashMap);
            if (this.a) {
                System.err.println("digits.jpg");
            }
            trainingImageLoader.load(string + "digits.jpg", new CharacterRange(48, 57), hashMap);
            if (this.a) {
                System.err.println("adding images");
            }
            this.c.addTrainingImages(hashMap);
            if (this.a) {
                System.err.println("loadTrainingImages() done");
            }
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            System.exit(2);
            return;
        }
    }

    public void process(String string) {
        Object object;
        if (this.a) {
            System.err.println("process(" + string + ")");
        }
        try {
            this.b = ImageIO.read(new File(string));
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        if (this.b == null) {
            System.err.println("Cannot find image file: " + string);
            return;
        }
        if (this.a) {
            System.err.println("constructing new PixelImage");
        }
        object = new PixelImage(this.b);
        if (this.a) {
            System.err.println("converting PixelImage to grayScale");
        }
        ((PixelImage)object).toGrayScale(true);
        if (this.a) {
            System.err.println("filtering");
        }
        ((PixelImage)object).filter();
        if (this.a) {
            System.err.println("setting image for display");
        }
        System.out.println(string + ":");
        string = this.c.scan(this.b, 0, 0, 0, 0, null);
        System.out.println("[" + string + "]");
    }

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length <= 0) {
            System.err.println("Please specify one or more image filenames.");
            System.exit(1);
        }
        if ((string = System.getProperty("TRAINING_IMAGE_DIR")) == null) {
            System.err.println("Please specify -DTRAINING_IMAGE_DIR=<dir> on the java command line.");
            return;
        }
        OCRScannerDemo oCRScannerDemo = new OCRScannerDemo();
        oCRScannerDemo.loadTrainingImages(string);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            oCRScannerDemo.process(stringArray[i2]);
        }
        System.out.println("done.");
    }

    static {
        Logger.getLogger(OCRScannerDemo.class.getName());
    }
}

