/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocrPlugins.aspectRatio;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Logger;
import net.sourceforge.javaocr.ocrPlugins.aspectRatio.CharacterRatio;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.TrainingImage;
import net.sourceforge.javaocr.scanner.DocumentScanner;
import net.sourceforge.javaocr.scanner.DocumentScannerListenerAdaptor;
import net.sourceforge.javaocr.scanner.PixelImage;
import net.sourceforge.javaocr.scanner.accuracy.AccuracyListenerInterface;
import net.sourceforge.javaocr.scanner.accuracy.AccuracyProviderInterface;
import net.sourceforge.javaocr.scanner.accuracy.OCRComp;
import net.sourceforge.javaocr.scanner.accuracy.OCRIdentification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectRatioOCR
extends DocumentScannerListenerAdaptor
implements AccuracyProviderInterface {
    private AccuracyListenerInterface a;
    private final HashMap<Character, ArrayList<TrainingImage>> b;
    private final ArrayList<CharacterRatio> c = new ArrayList();
    private DocumentScanner d = new DocumentScanner();

    public AspectRatioOCR(HashMap<Character, ArrayList<TrainingImage>> object) {
        this.b = object;
        object = this;
        for (Character c2 : ((AspectRatioOCR)object).b.keySet()) {
            ArrayList<TrainingImage> arrayList = ((AspectRatioOCR)object).b.get(c2);
            if (arrayList == null) continue;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                int n2 = arrayList.get((int)i2).width;
                int n3 = arrayList.get((int)i2).height;
                ((AspectRatioOCR)object).c.add(new CharacterRatio(c2.charValue(), (double)n2 / (double)n3));
            }
        }
        Collections.sort(((AspectRatioOCR)object).c);
    }

    public void scan(BufferedImage object) {
        object = new PixelImage((Image)object);
        ((PixelImage)object).toGrayScale(true);
        ((PixelImage)object).filter();
        this.d.scan((PixelImage)object, this, 0, 0, ((PixelImage)object).width, ((PixelImage)object).height);
    }

    @Override
    public void acceptAccuracyListener(AccuracyListenerInterface accuracyListenerInterface) {
        this.a = accuracyListenerInterface;
    }

    @Override
    public void endRow(PixelImage object, int n2, int n3) {
        if (this.a != null) {
            object = new OCRIdentification(OCRComp.ASPECT_RATIO);
            ((OCRIdentification)object).addChar('\n', 0.0);
            this.a.processCharOrSpace((OCRIdentification)object);
        }
    }

    @Override
    public void processChar(PixelImage pixelImage, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n4 - n2;
        n2 = n5 - n3;
        double d2 = (double)n8 / (double)n2;
        if (this.a != null) {
            double d3 = d2;
            Object object = this;
            double d4 = Double.MAX_VALUE;
            Stack<CharacterRatio> stack = new Stack<CharacterRatio>();
            for (CharacterRatio characterRatio : ((AspectRatioOCR)object).c) {
                CharacterRatio characterRatio2;
                if (!(Math.abs(characterRatio2.getRatio() - d3) < d4)) continue;
                d4 = Math.abs(characterRatio.getRatio() - d3);
                stack.push(characterRatio);
            }
            object = new OCRIdentification(OCRComp.ASPECT_RATIO);
            for (n3 = 0; !stack.isEmpty() && n3 < 5; ++n3) {
                CharacterRatio characterRatio = (CharacterRatio)stack.pop();
                double d5 = Math.abs(d3 - characterRatio.getRatio());
                ((OCRIdentification)object).addChar(characterRatio.getCharacter(), d5);
            }
            this.a.processCharOrSpace((OCRIdentification)object);
        }
    }

    @Override
    public void processSpace(PixelImage object, int n2, int n3, int n4, int n5) {
        if (this.a != null) {
            object = new OCRIdentification(OCRComp.ASPECT_RATIO);
            ((OCRIdentification)object).addChar(' ', 0.0);
            this.a.processCharOrSpace((OCRIdentification)object);
        }
    }

    static {
        Logger.getLogger(AspectRatioOCR.class.getName());
    }
}

