/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.cluster;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.cluster.FeatureExtractor;

public class CompositeExtractor
implements FeatureExtractor {
    private int a;
    private FeatureExtractor[] b;

    public CompositeExtractor(FeatureExtractor ... featureExtractorArray) {
        this.b = featureExtractorArray;
        for (FeatureExtractor featureExtractor : featureExtractorArray) {
            this.a += featureExtractor.getSize();
        }
    }

    public int getSize() {
        return this.a;
    }

    public double[] extract(Image image) {
        double[] dArray = new double[this.getSize()];
        int n2 = 0;
        FeatureExtractor[] featureExtractorArray = this.b;
        int n3 = this.b.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = featureExtractorArray[i2];
            double[] dArray2 = object.extract(image);
            object = dArray2;
            int n4 = dArray2.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                Object object2 = object[i3];
                dArray[n2++] = (double)object2;
            }
        }
        return dArray;
    }
}

