/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.cluster;

import net.sourceforge.javaocr.plugin.cluster.AbstractBaseCluster;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.SingularMatrixException;

public class MahalanobisDistanceCluster
extends AbstractBaseCluster {
    private double[][] a;
    private double[][] b;

    public MahalanobisDistanceCluster() {
    }

    public MahalanobisDistanceCluster(int n2) {
        super(n2);
        int n3 = n2;
        this.a = new double[n3][n3];
    }

    public MahalanobisDistanceCluster(double[] dArray, double[][] dArray2) {
        super(dArray);
        this.b = dArray2;
    }

    public double distance(double[] dArray) {
        this.getInvcov();
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.getDimensions(); ++i2) {
            double d3 = 0.0;
            for (int i3 = 0; i3 < this.getDimensions(); ++i3) {
                d3 += this.b[i3][i2] * (dArray[i3] - this.center()[i3]);
            }
            d2 += d3 * (dArray[i2] - this.center()[i2]);
        }
        return Math.sqrt(Math.abs(d2));
    }

    public void train(double[] dArray) {
        super.train(dArray);
        this.b = null;
        for (int i2 = 0; i2 < this.getDimensions(); ++i2) {
            for (int i3 = 0; i3 < this.getDimensions(); ++i3) {
                double[] dArray2 = this.a[i2];
                int n2 = i3;
                dArray2[n2] = dArray2[n2] + dArray[i2] * dArray[i3];
            }
        }
    }

    private double[][] a() {
        Object object = new double[this.getDimensions()][this.getDimensions()];
        for (int i2 = 0; i2 < this.getDimensions(); ++i2) {
            for (int i3 = 0; i3 < this.getDimensions(); ++i3) {
                double[] dArray = object[i2];
                int n2 = i3;
                dArray[n2] = dArray[n2] + (this.a[i2][i3] / (double)this.getAmountSamples() - this.center()[i2] * this.center()[i3]);
            }
        }
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(object);
        DecompositionSolver decompositionSolver = new LUDecompositionImpl((RealMatrix)array2DRowRealMatrix, Double.MIN_VALUE).getSolver();
        try {
            RealMatrix realMatrix = decompositionSolver.getInverse();
            object = realMatrix;
            return realMatrix.getData();
        }
        catch (SingularMatrixException singularMatrixException) {
            System.err.println("singular - return identity!!!!!!");
            object = new double[this.getDimensions()][this.getDimensions()];
            for (int i4 = 0; i4 < this.getDimensions(); ++i4) {
                object[i4][i4] = 1.0;
            }
            return object;
        }
    }

    public double[][] getInvcov() {
        if (this.b == null) {
            this.b = this.a();
        }
        return this.b;
    }

    public void setInvcov(double[][] dArray) {
        this.b = dArray;
    }
}

