/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.morphology;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.plugin.morphology.AbstractMorphologyFilter;

public class DilationFilter
extends AbstractMorphologyFilter {
    public DilationFilter(Image image, Image image2) {
        this(image, image2, 255, 0);
    }

    public DilationFilter(Image image, Image image2, int n2, int n3) {
        super(image, image2, n2, n3);
    }

    public void process(Image image) {
        int n2 = image.getWidth();
        int n3 = image.getHeight();
        image.chisel(0, 0, n2, this.sizeT).copy(this.destImage.chisel(0, 0, n2, this.sizeT));
        image.chisel(0, n3 - this.sizeB, n2, this.sizeB).copy(this.destImage.chisel(0, n3 - this.sizeB, n2, this.sizeB));
        image.chisel(0, 0, this.sizeL, n3).copy(this.destImage.chisel(0, 0, this.sizeL, n3));
        image.chisel(n2 - this.sizeR, 0, this.sizeR, n3).copy(this.destImage.chisel(n2 - this.sizeR, 0, this.sizeR, n3));
        for (int i2 = this.sizeT; i2 < n3 - this.sizeB; ++i2) {
            for (int i3 = this.sizeL; i3 < n2 - this.sizeR; ++i3) {
                if (image.get(i3, i2) != this.full) continue;
                Image image2 = this.destImage.chisel(i3 - this.sizeL, i2 - this.sizeT, this.seImageW, this.seImageH);
                this.processNeighborhood(image2);
            }
        }
    }

    protected void processNeighborhood(Image image) {
        for (int i2 = 0; i2 < this.seImageH; ++i2) {
            this.seImage.iterateH(i2);
            image.iterateH(i2);
            while (this.seImage.hasNext() && image.hasNext()) {
                if (this.seImage.next() == this.full) {
                    image.next(this.full);
                    continue;
                }
                image.next();
            }
        }
    }
}

