/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.scanner;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sourceforge.javaocr.scanner.DocumentScannerListener;
import net.sourceforge.javaocr.scanner.PixelImage;

public class DocumentScanner {
    protected float shortRowFraction = 0.125f;
    protected float liberalPolicyAreaWhitespaceFraction = 0.95f;
    protected float minSpaceWidthAsFractionOfRowHeight = 0.6f;
    protected float minCharWidthAsFractionOfRowHeight = 0.35f;
    protected float minCharBreakWidthAsFractionOfRowHeight = 0.05f;
    protected int whiteThreshold = 128;

    public float getShortRowFraction() {
        return this.shortRowFraction;
    }

    public void setShortRowFraction(float f2) {
        this.shortRowFraction = f2;
    }

    public float getLiberalPolicyAreaWhitespaceFraction() {
        return this.liberalPolicyAreaWhitespaceFraction;
    }

    public void setLiberalPolicyAreaWhitespaceFraction(float f2) {
        this.liberalPolicyAreaWhitespaceFraction = f2;
    }

    public float getMinSpaceWidthAsFractionOfRowHeight() {
        return this.minSpaceWidthAsFractionOfRowHeight;
    }

    public void setMinSpaceWidthAsFractionOfRowHeight(float f2) {
        this.minSpaceWidthAsFractionOfRowHeight = f2;
    }

    public float getMinCharWidthAsFractionOfRowHeight() {
        return this.minCharWidthAsFractionOfRowHeight;
    }

    public void setMinCharWidthAsFractionOfRowHeight(float f2) {
        this.minCharWidthAsFractionOfRowHeight = f2;
    }

    public float getMinCharBreakWidthAsFractionOfRowHeight() {
        return this.minCharBreakWidthAsFractionOfRowHeight;
    }

    public void setMinCharBreakWidthAsFractionOfRowHeight(float f2) {
        this.minCharBreakWidthAsFractionOfRowHeight = f2;
    }

    public int getWhiteThreshold() {
        return this.whiteThreshold;
    }

    public void setWhiteThreshold(int n2) {
        this.whiteThreshold = n2;
    }

    public final void scan(PixelImage pixelImage, DocumentScannerListener documentScannerListener, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int[] nArray = pixelImage.pixels;
        int n10 = pixelImage.width;
        int n11 = pixelImage.height;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= n10) {
            n2 = n10 - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= n11) {
            n3 = n11 - 1;
        }
        if (n4 <= 0 || n4 >= n10) {
            n4 = n10 - 1;
        }
        if (n5 <= 0 || n5 >= n11) {
            n5 = n11 - 1;
        }
        ++n4;
        ++n5;
        n11 = 1;
        documentScannerListener.beginDocument(pixelImage);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n12 = 0;
        for (n9 = n3; n9 < n5; ++n9) {
            n8 = 1;
            n7 = n2;
            n6 = n9 * n10 + n2;
            while (n7 < n4) {
                if (nArray[n6] < this.whiteThreshold) {
                    n8 = 0;
                    break;
                }
                ++n7;
                ++n6;
            }
            if (n8 != 0) {
                if (n11 != 0) continue;
                n11 = 1;
                arrayList.add(n12);
                arrayList.add(n9);
                continue;
            }
            if (n11 == 0) continue;
            n11 = 0;
            n12 = n9;
        }
        if (n11 == 0) {
            arrayList.add(n12);
            arrayList.add(n5);
        }
        n9 = 0;
        while (n9 + 4 <= arrayList.size()) {
            n8 = (Integer)arrayList.get(n9);
            n7 = (Integer)arrayList.get(n9 + 1);
            n6 = (Integer)arrayList.get(n9 + 2);
            n11 = (Integer)arrayList.get(n9 + 3);
            n12 = n7 - n8;
            n8 = n6 - n7;
            if (!((n11 -= n6) > (int)((float)n12 * this.shortRowFraction) && n11 >= 6 || n8 > (int)((float)n12 * this.shortRowFraction) && n8 >= 6)) {
                arrayList.remove(n9 + 2);
                arrayList.remove(n9 + 1);
                n9 -= 2;
            }
            n9 += 2;
        }
        if (arrayList.size() == 0) {
            arrayList.add(n3);
            arrayList.add(n5);
        }
        n9 = 0;
        while (n9 + 1 < arrayList.size()) {
            int n13;
            int n14;
            int n15;
            int n16;
            n8 = (Integer)arrayList.get(n9);
            int n17 = n7 = ((Integer)arrayList.get(n9 + 1)).intValue();
            int n18 = n4;
            n6 = n8;
            n7 = n2;
            n8 = n10;
            int[] nArray2 = nArray;
            DocumentScannerListener documentScannerListener2 = documentScannerListener;
            PixelImage pixelImage2 = pixelImage;
            DocumentScanner documentScanner = this;
            documentScannerListener2.beginRow(pixelImage2, n6, n17);
            int n19 = n17 - n6;
            int n20 = Math.max(1, (int)((float)n19 * documentScanner.minCharBreakWidthAsFractionOfRowHeight));
            int n21 = (int)((float)n19 * documentScanner.liberalPolicyAreaWhitespaceFraction);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            int n22 = 1;
            int n23 = 0;
            boolean bl2 = false;
            int n24 = 0;
            ++n7;
            while (n7 < n18 - 1) {
                if (!bl2 && n24 == 0 && n7 - n23 >= n19) {
                    n7 = n23;
                    bl2 = true;
                }
                n16 = 0;
                n15 = 1;
                n14 = n6;
                n13 = n6 * n8 + n7;
                while (n14 < n17) {
                    if (nArray2[n13] >= documentScanner.whiteThreshold) {
                        ++n16;
                    } else if (!bl2) {
                        n15 = 0;
                        break;
                    }
                    ++n14;
                    n13 += n8;
                }
                if (bl2 && n16 < n21) {
                    n15 = 0;
                }
                if (n15 != 0) {
                    if (++n24 >= n20 && n22 == 0) {
                        n22 = 1;
                        arrayList2.add(n23);
                        arrayList2.add(new Integer(n7 - (n24 - 1)));
                    }
                } else {
                    n24 = 0;
                    if (n22 != 0) {
                        n22 = 0;
                        n23 = n7;
                        bl2 = false;
                    }
                }
                ++n7;
            }
            if (n24 == 0) {
                arrayList2.add(n23);
                arrayList2.add(n18);
            }
            n7 = (int)((float)n19 * documentScanner.minSpaceWidthAsFractionOfRowHeight);
            n16 = (int)((float)n19 * documentScanner.minCharWidthAsFractionOfRowHeight);
            if (n16 <= 0) {
                n16 = 1;
            }
            n15 = 0;
            while (n15 + 4 < arrayList2.size()) {
                n14 = (Integer)arrayList2.get(n15 + 2) - (Integer)arrayList2.get(n15);
                if (n14 < n16 || n14 < 6) {
                    arrayList2.remove(n15 + 2);
                    arrayList2.remove(n15 + 1);
                    n15 -= 2;
                }
                n15 += 2;
            }
            n15 = 0;
            while (n15 + 1 < arrayList2.size()) {
                if (n15 >= 2) {
                    n14 = (Integer)arrayList2.get(n15 - 1);
                    n13 = (Integer)arrayList2.get(n15);
                    while (n13 - n14 >= n7) {
                        n18 = Math.min(n14 + n7, n13);
                        documentScannerListener2.processSpace(pixelImage2, n14, n6, n18, n17);
                        n14 += n7;
                    }
                }
                n14 = (Integer)arrayList2.get(n15);
                n13 = (Integer)arrayList2.get(n15 + 1);
                for (n18 = n6; n18 < n17; ++n18) {
                    n19 = 1;
                    n20 = n14;
                    n21 = n18 * n8 + n14;
                    while (n20 < n13) {
                        if (nArray2[n21] < documentScanner.whiteThreshold) {
                            n19 = 0;
                            break;
                        }
                        ++n20;
                        ++n21;
                    }
                    if (n19 == 0) break;
                }
                for (n19 = n17; n19 > n18; --n19) {
                    n20 = 1;
                    n21 = n14;
                    n22 = (n19 - 1) * n8 + n14;
                    while (n21 < n13) {
                        if (nArray2[n22] < documentScanner.whiteThreshold) {
                            n20 = 0;
                            break;
                        }
                        ++n21;
                        ++n22;
                    }
                    if (n20 == 0) break;
                }
                if (n18 >= n19) {
                    documentScannerListener2.processSpace(pixelImage2, n14, n6, n13, n17);
                } else {
                    documentScannerListener2.processChar(pixelImage2, n14, n18, n13, n19, n6, n17);
                }
                n15 += 2;
            }
            documentScannerListener2.endRow(pixelImage2, n6, n17);
            n9 += 2;
        }
    }

    static {
        Logger.getLogger(DocumentScanner.class.getName());
    }
}

