/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.scanner;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.logging.Logger;

public class PixelImage {
    protected static final float[] FILTER_FIR_COEFFS = new float[]{0.050017573f, -0.06430831f, -0.09003163f, 0.15005273f, 0.45015815f, 0.45015815f, 0.15005273f, -0.09003163f, -0.06430831f, 0.050017573f};
    public final int[] pixels;
    public final int width;
    public final int height;
    public final int npix;
    public final float aspectRatio;

    public PixelImage(int[] nArray, int n2, int n3) {
        this.pixels = nArray;
        this.width = n2;
        this.height = n3;
        this.npix = n2 * n3;
        this.aspectRatio = (float)n2 / (float)n3;
    }

    public PixelImage(Image object) {
        this.width = ((Image)object).getWidth(null);
        this.height = ((Image)object).getHeight(null);
        this.npix = this.width * this.height;
        this.aspectRatio = (float)this.width / (float)this.height;
        this.pixels = new int[this.npix];
        object = new PixelGrabber((Image)object, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            ((PixelGrabber)object).grabPixels();
            return;
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            interruptedException.printStackTrace();
            return;
        }
    }

    public Image rgbToImage(int[] nArray, int n2, int n3, Component component) {
        return component.createImage(new MemoryImageSource(n2, n3, nArray, 0, n2));
    }

    public final int getPixelIndex(int n2, int n3) {
        return n3 * this.width + n2;
    }

    public final int getPixel(int n2, int n3) {
        return this.pixels[n3 * this.width + n2];
    }

    private static int a(int n2) {
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        n2 &= 0xFF;
        if ((n2 = n3 * 306 + n4 * 601 + n2 * 117 >> 10) < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        return n2;
    }

    public final void toGrayScale(boolean n2) {
        int n3;
        if (this.npix == 0) {
            return;
        }
        if (n2 == 0) {
            for (n2 = 0; n2 < this.npix; ++n2) {
                this.pixels[n2] = PixelImage.a(this.pixels[n2]);
            }
            return;
        }
        this.pixels[0] = n2 = PixelImage.a(this.pixels[0]);
        int n4 = n2;
        int n5 = n2;
        for (n3 = 1; n3 < this.npix; ++n3) {
            this.pixels[n3] = n2 = PixelImage.a(this.pixels[n3]);
            n4 = Math.min(n4, n2);
            n5 = Math.max(n5, n2);
        }
        n3 = n5 - n4;
        if (n3 <= 0) {
            for (n2 = 0; n2 < this.npix; ++n2) {
                this.pixels[n2] = 255;
            }
            return;
        }
        for (n2 = 0; n2 < this.npix; ++n2) {
            this.pixels[n2] = Math.min(255, Math.max(0, (this.pixels[n2] - n4) * 255 / n3));
        }
    }

    public final int[] grayScaleToRGB(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            int n2;
            int n3 = n2 = nArray[i2] & 0xFF;
            nArray2[i2] = n3 | n3 << 8 | n2 << 16 | 0xFF000000;
        }
        return nArray2;
    }

    public final void filter() {
        PixelImage pixelImage = this;
        pixelImage.filter(pixelImage.pixels, this.width, this.height);
    }

    public final void filter(int[] nArray, int n2, int n3) {
        int n4;
        float f2;
        int n5;
        int n6;
        int n7;
        float[] fArray = new float[FILTER_FIR_COEFFS.length];
        int n8 = fArray.length - 1;
        for (n7 = 0; n7 < n3; ++n7) {
            for (n6 = 0; n6 < fArray.length; ++n6) {
                fArray[n6] = 255.0f;
            }
            n6 = -(fArray.length / 2);
            n5 = 0;
            while (n5 < n2) {
                f2 = 0.0f;
                for (n4 = 0; n4 < n8; ++n4) {
                    f2 += fArray[n4] * FILTER_FIR_COEFFS[n4];
                    fArray[n4] = fArray[n4 + 1];
                }
                f2 += fArray[n8] * FILTER_FIR_COEFFS[n8];
                fArray[n8] = this.getPixel(n5, n7);
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                } else if (f2 > 255.0f) {
                    f2 = 255.0f;
                }
                if (n6 >= 0) {
                    nArray[this.getPixelIndex((int)n6, (int)n7)] = (int)f2;
                }
                ++n5;
                ++n6;
            }
            while (n6 < n2) {
                f2 = 0.0f;
                for (n5 = 0; n5 < n8; ++n5) {
                    f2 += fArray[n5] * FILTER_FIR_COEFFS[n5];
                    fArray[n5] = fArray[n5 + 1];
                }
                f2 += fArray[n8] * FILTER_FIR_COEFFS[n8];
                fArray[n8] = 255.0f;
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                } else if (f2 > 255.0f) {
                    f2 = 255.0f;
                }
                nArray[this.getPixelIndex((int)n6, (int)n7)] = (int)f2;
                ++n6;
            }
        }
        for (n7 = 0; n7 < n2; ++n7) {
            for (n6 = 0; n6 < fArray.length; ++n6) {
                fArray[n6] = 255.0f;
            }
            n6 = -(fArray.length / 2);
            n5 = 0;
            while (n5 < n3) {
                f2 = 0.0f;
                for (n4 = 0; n4 < n8; ++n4) {
                    f2 += fArray[n4] * FILTER_FIR_COEFFS[n4];
                    fArray[n4] = fArray[n4 + 1];
                }
                f2 += fArray[n8] * FILTER_FIR_COEFFS[n8];
                fArray[n8] = this.getPixel(n7, n5);
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                } else if (f2 > 255.0f) {
                    f2 = 255.0f;
                }
                if (n6 >= 0) {
                    nArray[this.getPixelIndex((int)n7, (int)n6)] = (int)f2;
                }
                ++n5;
                ++n6;
            }
            while (n6 < n3) {
                f2 = 0.0f;
                for (n5 = 0; n5 < n8; ++n5) {
                    f2 += fArray[n5] * FILTER_FIR_COEFFS[n5];
                    fArray[n5] = fArray[n5 + 1];
                }
                f2 += fArray[n8] * FILTER_FIR_COEFFS[n8];
                fArray[n8] = 255.0f;
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                } else if (f2 > 255.0f) {
                    f2 = 255.0f;
                }
                nArray[this.getPixelIndex((int)n7, (int)n6)] = (int)f2;
                ++n6;
            }
        }
    }

    static {
        Logger.getLogger(PixelImage.class.getName());
    }
}

