/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.TypeHandler;
import org.apache.commons.cli.b;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine
implements Serializable {
    private final List<String> a = new LinkedList<String>();
    private final List<Option> b = new ArrayList<Option>();

    protected CommandLine() {
    }

    public boolean hasOption(String string) {
        return this.b.contains(this.a(string));
    }

    public boolean hasOption(char c2) {
        return this.hasOption(String.valueOf(c2));
    }

    @Deprecated
    public Object getOptionObject(String string) {
        try {
            return this.getParsedOptionValue(string);
        }
        catch (ParseException parseException) {
            System.err.println("Exception found converting " + string + " to desired type: " + parseException.getMessage());
            return null;
        }
    }

    public Object getParsedOptionValue(String object) {
        String string = this.getOptionValue((String)object);
        if ((object = this.a((String)object)) == null || string == null) {
            return null;
        }
        return TypeHandler.createValue(string, ((Option)object).getType());
    }

    public Object getOptionObject(char c2) {
        return this.getOptionObject(String.valueOf(c2));
    }

    public String getOptionValue(String stringArray) {
        if ((stringArray = this.getOptionValues((String)stringArray)) == null) {
            return null;
        }
        return stringArray[0];
    }

    public String getOptionValue(char c2) {
        return this.getOptionValue(String.valueOf(c2));
    }

    public String[] getOptionValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Option option : this.b) {
            if (!string.equals(option.getOpt()) && !string.equals(option.getLongOpt())) continue;
            arrayList.addAll(option.getValuesList());
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    private Option a(String string) {
        string = org.apache.commons.cli.b.a(string);
        for (Option option : this.b) {
            if (string.equals(option.getOpt())) {
                return option;
            }
            if (!string.equals(option.getLongOpt())) continue;
            return option;
        }
        return null;
    }

    public String[] getOptionValues(char c2) {
        return this.getOptionValues(String.valueOf(c2));
    }

    public String getOptionValue(String string, String string2) {
        if ((string = this.getOptionValue(string)) != null) {
            return string;
        }
        return string2;
    }

    public String getOptionValue(char c2, String string) {
        return this.getOptionValue(String.valueOf(c2), string);
    }

    public Properties getOptionProperties(String string) {
        Properties properties = new Properties();
        for (Option option : this.b) {
            if (!string.equals(option.getOpt()) && !string.equals(option.getLongOpt())) continue;
            List<String> list = option.getValuesList();
            if (list.size() >= 2) {
                properties.put(list.get(0), list.get(1));
                continue;
            }
            if (list.size() != 1) continue;
            properties.put(list.get(0), "true");
        }
        return properties;
    }

    public String[] getArgs() {
        String[] stringArray = new String[this.a.size()];
        this.a.toArray(stringArray);
        return stringArray;
    }

    public List<String> getArgList() {
        return this.a;
    }

    protected void addArg(String string) {
        this.a.add(string);
    }

    protected void addOption(Option option) {
        this.b.add(option);
    }

    public Iterator<Option> iterator() {
        return this.b.iterator();
    }

    public Option[] getOptions() {
        List<Option> list = this.b;
        Option[] optionArray = new Option[list.size()];
        return list.toArray(optionArray);
    }

    public static final class Builder {
        private final CommandLine a = new CommandLine();

        public final Builder addOption(Option option) {
            this.a.addOption(option);
            return this;
        }

        public final Builder addArg(String string) {
            this.a.addArg(string);
            return this;
        }

        public final CommandLine build() {
            return this.a;
        }
    }
}

