/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpFormatter {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_LONG_OPT_SEPARATOR = " ";
    public static final String DEFAULT_ARG_NAME = "arg";
    @Deprecated
    public int defaultWidth = 74;
    @Deprecated
    public int defaultLeftPad = 1;
    @Deprecated
    public int defaultDescPad = 3;
    @Deprecated
    public String defaultSyntaxPrefix = "usage: ";
    @Deprecated
    public String defaultNewLine = System.getProperty("line.separator");
    @Deprecated
    public String defaultOptPrefix = "-";
    @Deprecated
    public String defaultLongOptPrefix = "--";
    @Deprecated
    public String defaultArgName = "arg";
    protected Comparator<Option> optionComparator = new a(0);
    private String a = " ";

    public void setWidth(int n2) {
        this.defaultWidth = n2;
    }

    public int getWidth() {
        return this.defaultWidth;
    }

    public void setLeftPadding(int n2) {
        this.defaultLeftPad = n2;
    }

    public int getLeftPadding() {
        return this.defaultLeftPad;
    }

    public void setDescPadding(int n2) {
        this.defaultDescPad = n2;
    }

    public int getDescPadding() {
        return this.defaultDescPad;
    }

    public void setSyntaxPrefix(String string) {
        this.defaultSyntaxPrefix = string;
    }

    public String getSyntaxPrefix() {
        return this.defaultSyntaxPrefix;
    }

    public void setNewLine(String string) {
        this.defaultNewLine = string;
    }

    public String getNewLine() {
        return this.defaultNewLine;
    }

    public void setOptPrefix(String string) {
        this.defaultOptPrefix = string;
    }

    public String getOptPrefix() {
        return this.defaultOptPrefix;
    }

    public void setLongOptPrefix(String string) {
        this.defaultLongOptPrefix = string;
    }

    public String getLongOptPrefix() {
        return this.defaultLongOptPrefix;
    }

    public void setLongOptSeparator(String string) {
        this.a = string;
    }

    public String getLongOptSeparator() {
        return this.a;
    }

    public void setArgName(String string) {
        this.defaultArgName = string;
    }

    public String getArgName() {
        return this.defaultArgName;
    }

    public Comparator<Option> getOptionComparator() {
        return this.optionComparator;
    }

    public void setOptionComparator(Comparator<Option> comparator) {
        this.optionComparator = comparator;
    }

    public void printHelp(String string, Options options) {
        HelpFormatter helpFormatter = this;
        helpFormatter.printHelp(helpFormatter.getWidth(), string, null, options, null, false);
    }

    public void printHelp(String string, Options options, boolean bl2) {
        HelpFormatter helpFormatter = this;
        helpFormatter.printHelp(helpFormatter.getWidth(), string, null, options, null, bl2);
    }

    public void printHelp(String string, String string2, Options options, String string3) {
        this.printHelp(string, string2, options, string3, false);
    }

    public void printHelp(String string, String string2, Options options, String string3, boolean bl2) {
        HelpFormatter helpFormatter = this;
        helpFormatter.printHelp(helpFormatter.getWidth(), string, string2, options, string3, bl2);
    }

    public void printHelp(int n2, String string, String string2, Options options, String string3) {
        this.printHelp(n2, string, string2, options, string3, false);
    }

    public void printHelp(int n2, String string, String string2, Options options, String string3, boolean bl2) {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.printHelp(printWriter, n2, string, string2, options, this.getLeftPadding(), this.getDescPadding(), string3, bl2);
        printWriter.flush();
    }

    public void printHelp(PrintWriter printWriter, int n2, String string, String string2, Options options, int n3, int n4, String string3) {
        this.printHelp(printWriter, n2, string, string2, options, n3, n4, string3, false);
    }

    public void printHelp(PrintWriter printWriter, int n2, String string, String string2, Options options, int n3, int n4, String string3, boolean bl2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (bl2) {
            this.printUsage(printWriter, n2, string, options);
        } else {
            this.printUsage(printWriter, n2, string);
        }
        if (string2 != null && string2.trim().length() > 0) {
            this.printWrapped(printWriter, n2, string2);
        }
        this.printOptions(printWriter, n2, options, n3, n4);
        if (string3 != null && string3.trim().length() > 0) {
            this.printWrapped(printWriter, n2, string3);
        }
    }

    public void printUsage(PrintWriter printWriter, int n2, String charSequence, Options options) {
        charSequence = new StringBuffer(this.getSyntaxPrefix()).append((String)charSequence).append(DEFAULT_LONG_OPT_SEPARATOR);
        ArrayList<OptionGroup> arrayList = new ArrayList<OptionGroup>();
        Object object = new ArrayList<Option>(options.getOptions());
        if (this.getOptionComparator() != null) {
            Collections.sort(object, this.getOptionComparator());
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Option)object.next();
            Object object3 = options.getOptionGroup((Option)object2);
            if (object3 != null) {
                if (!arrayList.contains(object3)) {
                    arrayList.add((OptionGroup)object3);
                    OptionGroup optionGroup = object3;
                    object3 = charSequence;
                    object2 = this;
                    if (!optionGroup.isRequired()) {
                        ((StringBuffer)object3).append("[");
                    }
                    Object object4 = new ArrayList<Option>(optionGroup.getOptions());
                    if (((HelpFormatter)object2).getOptionComparator() != null) {
                        Collections.sort(object4, ((HelpFormatter)object2).getOptionComparator());
                    }
                    object4 = object4.iterator();
                    while (object4.hasNext()) {
                        super.a((StringBuffer)object3, (Option)object4.next(), true);
                        if (!object4.hasNext()) continue;
                        ((StringBuffer)object3).append(" | ");
                    }
                    if (!optionGroup.isRequired()) {
                        ((StringBuffer)object3).append("]");
                    }
                }
            } else {
                Option option = object2;
                this.a((StringBuffer)charSequence, option, option.isRequired());
            }
            if (!object.hasNext()) continue;
            ((StringBuffer)charSequence).append(DEFAULT_LONG_OPT_SEPARATOR);
        }
        this.printWrapped(printWriter, n2, ((StringBuffer)charSequence).toString().indexOf(32) + 1, ((StringBuffer)charSequence).toString());
    }

    private void a(StringBuffer stringBuffer, Option option, boolean bl2) {
        if (!bl2) {
            stringBuffer.append("[");
        }
        if (option.getOpt() != null) {
            stringBuffer.append(DEFAULT_OPT_PREFIX).append(option.getOpt());
        } else {
            stringBuffer.append(DEFAULT_LONG_OPT_PREFIX).append(option.getLongOpt());
        }
        if (option.hasArg() && (option.getArgName() == null || option.getArgName().length() != 0)) {
            stringBuffer.append(option.getOpt() == null ? this.a : DEFAULT_LONG_OPT_SEPARATOR);
            stringBuffer.append("<").append(option.getArgName() != null ? option.getArgName() : this.getArgName()).append(">");
        }
        if (!bl2) {
            stringBuffer.append("]");
        }
    }

    public void printUsage(PrintWriter printWriter, int n2, String string) {
        int n3 = string.indexOf(32) + 1;
        this.printWrapped(printWriter, n2, this.getSyntaxPrefix().length() + n3, this.getSyntaxPrefix() + string);
    }

    public void printOptions(PrintWriter printWriter, int n2, Options options, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        this.renderOptions(stringBuffer, n2, options, n3, n4);
        printWriter.println(stringBuffer.toString());
    }

    public void printWrapped(PrintWriter printWriter, int n2, String string) {
        this.printWrapped(printWriter, n2, 0, string);
    }

    public void printWrapped(PrintWriter printWriter, int n2, int n3, String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        this.a(stringBuffer, n2, n3, string);
        printWriter.println(stringBuffer.toString());
    }

    protected StringBuffer renderOptions(StringBuffer stringBuffer, int n2, Options object, int n3, int n4) {
        CharSequence charSequence;
        Serializable serializable;
        Object object2;
        String string = this.createPadding(n3);
        String string2 = this.createPadding(n4);
        int n5 = 0;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        object = ((Options)object).b();
        if (this.getOptionComparator() != null) {
            Collections.sort(object, this.getOptionComparator());
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object2 = (Option)iterator.next();
            serializable = new StringBuffer();
            if (((Option)object2).getOpt() == null) {
                ((StringBuffer)serializable).append(string).append("   ").append(this.getLongOptPrefix()).append(((Option)object2).getLongOpt());
            } else {
                ((StringBuffer)serializable).append(string).append(this.getOptPrefix()).append(((Option)object2).getOpt());
                if (((Option)object2).hasLongOpt()) {
                    ((StringBuffer)serializable).append(',').append(this.getLongOptPrefix()).append(((Option)object2).getLongOpt());
                }
            }
            if (((Option)object2).hasArg()) {
                charSequence = ((Option)object2).getArgName();
                if (charSequence != null && ((String)charSequence).length() == 0) {
                    ((StringBuffer)serializable).append(' ');
                } else {
                    ((StringBuffer)serializable).append(((Option)object2).hasLongOpt() ? this.a : DEFAULT_LONG_OPT_SEPARATOR);
                    ((StringBuffer)serializable).append("<").append(charSequence != null ? ((Option)object2).getArgName() : this.getArgName()).append(">");
                }
            }
            arrayList.add(serializable);
            n5 = ((StringBuffer)serializable).length() > n5 ? ((StringBuffer)serializable).length() : n5;
        }
        int n6 = 0;
        object2 = object.iterator();
        while (object2.hasNext()) {
            serializable = (Option)object2.next();
            if (((StringBuilder)(charSequence = new StringBuilder(((StringBuffer)arrayList.get(n6++)).toString()))).length() < n5) {
                ((StringBuilder)charSequence).append(this.createPadding(n5 - ((StringBuilder)charSequence).length()));
            }
            ((StringBuilder)charSequence).append(string2);
            int n7 = n5 + n4;
            if (((Option)serializable).getDescription() != null) {
                ((StringBuilder)charSequence).append(((Option)serializable).getDescription());
            }
            this.renderWrappedText(stringBuffer, n2, n7, ((StringBuilder)charSequence).toString());
            if (!object2.hasNext()) continue;
            stringBuffer.append(this.getNewLine());
        }
        return stringBuffer;
    }

    protected StringBuffer renderWrappedText(StringBuffer stringBuffer, int n2, int n3, String string) {
        int n4 = this.findWrapPos(string, n2, 0);
        if (n4 == -1) {
            stringBuffer.append(this.rtrim(string));
            return stringBuffer;
        }
        stringBuffer.append(this.rtrim(string.substring(0, n4))).append(this.getNewLine());
        if (n3 >= n2) {
            n3 = 1;
        }
        String string2 = this.createPadding(n3);
        while (true) {
            if ((n4 = this.findWrapPos(string = string2 + string.substring(n4).trim(), n2, 0)) == -1) {
                stringBuffer.append(string);
                return stringBuffer;
            }
            if (string.length() > n2 && n4 == n3 - 1) {
                n4 = n2;
            }
            stringBuffer.append(this.rtrim(string.substring(0, n4))).append(this.getNewLine());
        }
    }

    private Appendable a(StringBuffer stringBuffer, int n2, int n3, String object) {
        try {
            String string;
            object = new BufferedReader(new StringReader((String)object));
            boolean bl2 = true;
            while ((string = ((BufferedReader)object).readLine()) != null) {
                if (!bl2) {
                    stringBuffer.append(this.getNewLine());
                } else {
                    bl2 = false;
                }
                this.renderWrappedText(stringBuffer, n2, n3, string);
            }
        }
        catch (IOException iOException) {}
        return stringBuffer;
    }

    protected int findWrapPos(String string, int n2, int n3) {
        char c2;
        int n4 = string.indexOf(10, n3);
        if (n4 != -1 && n4 <= n2) {
            return n4 + 1;
        }
        n4 = string.indexOf(9, n3);
        if (n4 != -1 && n4 <= n2) {
            return n4 + 1;
        }
        if (n3 + n2 >= string.length()) {
            return -1;
        }
        for (n4 = n3 + n2; n4 >= n3 && (c2 = string.charAt(n4)) != ' ' && c2 != '\n' && c2 != '\r'; --n4) {
        }
        if (n4 > n3) {
            return n4;
        }
        n4 = n3 + n2;
        if (n4 == string.length()) {
            return -1;
        }
        return n4;
    }

    protected String createPadding(int n2) {
        char[] cArray = new char[n2];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    protected String rtrim(String string) {
        int n2;
        if (string == null || string.length() == 0) {
            return string;
        }
        for (n2 = string.length(); n2 > 0 && Character.isWhitespace(string.charAt(n2 - 1)); --n2) {
        }
        return string.substring(0, n2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class a
    implements Serializable,
    Comparator<Option> {
        private a() {
        }

        @Override
        public final /* synthetic */ int compare(Object object, Object object2) {
            object2 = (Option)object2;
            object = (Option)object;
            return ((Option)object).a().compareToIgnoreCase(((Option)object2).a());
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

