/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.b;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options
implements Serializable {
    private final Map<String, Option> a = new LinkedHashMap<String, Option>();
    private final Map<String, Option> b = new LinkedHashMap<String, Option>();
    private final List<Object> c = new ArrayList<Object>();
    private final Map<String, OptionGroup> d = new LinkedHashMap<String, OptionGroup>();

    public Options addOptionGroup(OptionGroup optionGroup) {
        if (optionGroup.isRequired()) {
            this.c.add(optionGroup);
        }
        for (Option option : optionGroup.getOptions()) {
            option.setRequired(false);
            this.addOption(option);
            this.d.put(option.a(), optionGroup);
        }
        return this;
    }

    final Collection<OptionGroup> a() {
        return new HashSet<OptionGroup>(this.d.values());
    }

    public Options addOption(String string, String string2) {
        this.addOption(string, null, false, string2);
        return this;
    }

    public Options addOption(String string, boolean bl2, String string2) {
        this.addOption(string, null, bl2, string2);
        return this;
    }

    public Options addOption(String string, String string2, boolean bl2, String string3) {
        this.addOption(new Option(string, string2, bl2, string3));
        return this;
    }

    public Options addRequiredOption(String object, String string, boolean bl2, String string2) {
        object = new Option((String)object, string, bl2, string2);
        ((Option)object).setRequired(true);
        this.addOption((Option)object);
        return this;
    }

    public Options addOption(Option option) {
        String string = option.a();
        if (option.hasLongOpt()) {
            this.b.put(option.getLongOpt(), option);
        }
        if (option.isRequired()) {
            if (this.c.contains(string)) {
                this.c.remove(this.c.indexOf(string));
            }
            this.c.add(string);
        }
        this.a.put(string, option);
        return this;
    }

    public Collection<Option> getOptions() {
        return Collections.unmodifiableCollection(this.b());
    }

    final List<Option> b() {
        return new ArrayList<Option>(this.a.values());
    }

    public List getRequiredOptions() {
        return Collections.unmodifiableList(this.c);
    }

    public Option getOption(String string) {
        if (this.a.containsKey(string = org.apache.commons.cli.b.a(string))) {
            return this.a.get(string);
        }
        return this.b.get(string);
    }

    public List<String> getMatchingOptions(String string) {
        string = org.apache.commons.cli.b.a(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.b.keySet().contains(string)) {
            return Collections.singletonList(string);
        }
        for (String string2 : this.b.keySet()) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public boolean hasOption(String string) {
        return this.a.containsKey(string = org.apache.commons.cli.b.a(string)) || this.b.containsKey(string);
    }

    public boolean hasLongOption(String string) {
        string = org.apache.commons.cli.b.a(string);
        return this.b.containsKey(string);
    }

    public boolean hasShortOption(String string) {
        string = org.apache.commons.cli.b.a(string);
        return this.a.containsKey(string);
    }

    public OptionGroup getOptionGroup(Option option) {
        return this.d.get(option.a());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ Options: [ short ");
        stringBuilder.append(this.a.toString());
        stringBuilder.append(" ] [ long ");
        stringBuilder.append(this.b);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

