/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Date;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class PatternOptionBuilder {
    public static final Class<String> STRING_VALUE = String.class;
    public static final Class<Object> OBJECT_VALUE = Object.class;
    public static final Class<Number> NUMBER_VALUE = Number.class;
    public static final Class<Date> DATE_VALUE = Date.class;
    public static final Class<?> CLASS_VALUE = Class.class;
    public static final Class<FileInputStream> EXISTING_FILE_VALUE = FileInputStream.class;
    public static final Class<File> FILE_VALUE = File.class;
    public static final Class<File[]> FILES_VALUE = File[].class;
    public static final Class<URL> URL_VALUE = URL.class;

    public static Object getValueClass(char c2) {
        switch (c2) {
            case '@': {
                return OBJECT_VALUE;
            }
            case ':': {
                return STRING_VALUE;
            }
            case '%': {
                return NUMBER_VALUE;
            }
            case '+': {
                return CLASS_VALUE;
            }
            case '#': {
                return DATE_VALUE;
            }
            case '<': {
                return EXISTING_FILE_VALUE;
            }
            case '>': {
                return FILE_VALUE;
            }
            case '*': {
                return FILES_VALUE;
            }
            case '/': {
                return URL_VALUE;
            }
        }
        return null;
    }

    public static boolean isValueCode(char c2) {
        return c2 == '@' || c2 == ':' || c2 == '%' || c2 == '+' || c2 == '#' || c2 == '<' || c2 == '>' || c2 == '*' || c2 == '/' || c2 == '!';
    }

    public static Options parsePattern(String string) {
        char c2 = ' ';
        boolean bl2 = false;
        Class clazz = null;
        Options options = new Options();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (!PatternOptionBuilder.isValueCode(c3)) {
                if (c2 != ' ') {
                    Option option = Option.builder(String.valueOf(c2)).hasArg(clazz != null).required(bl2).type(clazz).build();
                    options.addOption(option);
                    bl2 = false;
                    clazz = null;
                }
                c2 = c3;
                continue;
            }
            if (c3 == '!') {
                bl2 = true;
                continue;
            }
            clazz = (Class)PatternOptionBuilder.getValueClass(c3);
        }
        if (c2 != ' ') {
            Option option = Option.builder(String.valueOf(c2)).hasArg(clazz != null).required(bl2).type(clazz).build();
            options.addOption(option);
        }
        return options;
    }
}

