/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.UploadContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.fileupload.util.Closeable;
import org.apache.commons.fileupload.util.FileItemHeadersImpl;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.IOUtils;

public abstract class FileUploadBase {
    public static final String CONTENT_TYPE = "Content-type";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String CONTENT_LENGTH = "Content-length";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    @Deprecated
    public static final int MAX_HEADER_SIZE = 1024;
    private long a = -1L;
    private long b = -1L;
    private String c;
    private ProgressListener d;

    public static final boolean isMultipartContent(RequestContext object) {
        if ((object = object.getContentType()) == null) {
            return false;
        }
        return ((String)object).toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }

    @Deprecated
    public static boolean isMultipartContent(HttpServletRequest httpServletRequest) {
        return ServletFileUpload.isMultipartContent(httpServletRequest);
    }

    public abstract FileItemFactory getFileItemFactory();

    public abstract void setFileItemFactory(FileItemFactory var1);

    public long getSizeMax() {
        return this.a;
    }

    public void setSizeMax(long l2) {
        this.a = l2;
    }

    public long getFileSizeMax() {
        return this.b;
    }

    public void setFileSizeMax(long l2) {
        this.b = l2;
    }

    public String getHeaderEncoding() {
        return this.c;
    }

    public void setHeaderEncoding(String string) {
        this.c = string;
    }

    @Deprecated
    public List<FileItem> parseRequest(HttpServletRequest httpServletRequest) {
        return this.parseRequest(new ServletRequestContext(httpServletRequest));
    }

    public FileItemIterator getItemIterator(RequestContext object) {
        try {
            return new a((RequestContext)object);
        }
        catch (FileUploadIOException fileUploadIOException) {
            object = fileUploadIOException;
            throw (FileUploadException)fileUploadIOException.getCause();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<FileItem> parseRequest(RequestContext object) {
        Object object2 = new ArrayList();
        boolean bl2 = false;
        try {
            try {
                object = this.getItemIterator((RequestContext)object);
                FileItemFactory fileItemFactory = this.getFileItemFactory();
                if (fileItemFactory == null) {
                    throw new NullPointerException("No FileItemFactory has been set.");
                }
                while (true) {
                    if (!object.hasNext()) {
                        bl2 = true;
                        return object2;
                    }
                    Object object3 = object.next();
                    Object object4 = ((a.a)object3).c;
                    object4 = fileItemFactory.createItem(object3.getFieldName(), object3.getContentType(), object3.isFormField(), (String)object4);
                    object2.add(object4);
                    try {
                        Streams.copy(object3.openStream(), object4.getOutputStream(), true);
                    }
                    catch (FileUploadIOException fileUploadIOException) {
                        object3 = fileUploadIOException;
                        throw (FileUploadException)fileUploadIOException.getCause();
                    }
                    catch (IOException iOException) {
                        throw new IOFileUploadException(String.format("Processing of %s request failed. %s", MULTIPART_FORM_DATA, iOException.getMessage()), iOException);
                    }
                    object3 = object3.getHeaders();
                    object4.setHeaders((FileItemHeaders)object3);
                }
            }
            catch (FileUploadIOException fileUploadIOException) {
                object = fileUploadIOException;
                throw (FileUploadException)fileUploadIOException.getCause();
            }
            catch (IOException iOException) {
                throw new FileUploadException(iOException.getMessage(), iOException);
            }
        }
        catch (Throwable throwable) {
            if (bl2) throw throwable;
            object2 = object2.iterator();
            while (object2.hasNext()) {
                FileItem fileItem = (FileItem)object2.next();
                try {
                    fileItem.delete();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
    }

    public Map<String, List<FileItem>> parseParameterMap(RequestContext iterator) {
        iterator = this.parseRequest((RequestContext)((Object)iterator));
        HashMap<String, List<FileItem>> hashMap = new HashMap<String, List<FileItem>>(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            FileItem fileItem = (FileItem)iterator.next();
            String string = fileItem.getFieldName();
            ArrayList<FileItem> arrayList = (ArrayList<FileItem>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<FileItem>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(fileItem);
        }
        return hashMap;
    }

    protected byte[] getBoundary(String object) {
        Object object2 = new ParameterParser();
        ((ParameterParser)object2).setLowerCaseNames(true);
        object = ((ParameterParser)object2).parse((String)object, new char[]{';', ','});
        object = object.get("boundary");
        if (object == null) {
            return null;
        }
        try {
            object2 = ((String)object).getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object2 = ((String)object).getBytes();
        }
        return object2;
    }

    @Deprecated
    protected String getFileName(Map<String, String> map) {
        return FileUploadBase.a(this.getHeader(map, CONTENT_DISPOSITION));
    }

    protected String getFileName(FileItemHeaders fileItemHeaders) {
        return FileUploadBase.a(fileItemHeaders.getHeader(CONTENT_DISPOSITION));
    }

    private static String a(String object) {
        Object object2;
        String string = null;
        if (object != null && (((String)(object2 = ((String)object).toLowerCase(Locale.ENGLISH))).startsWith(FORM_DATA) || ((String)object2).startsWith(ATTACHMENT))) {
            object2 = new ParameterParser();
            ((ParameterParser)object2).setLowerCaseNames(true);
            object = ((ParameterParser)object2).parse((String)object, ';');
            if (object.containsKey("filename")) {
                string = (String)object.get("filename");
                string = string != null ? string.trim() : "";
            }
        }
        return string;
    }

    protected String getFieldName(FileItemHeaders fileItemHeaders) {
        return FileUploadBase.b(fileItemHeaders.getHeader(CONTENT_DISPOSITION));
    }

    private static String b(String object) {
        Object object2 = null;
        if (object != null && ((String)object).toLowerCase(Locale.ENGLISH).startsWith(FORM_DATA)) {
            object2 = new ParameterParser();
            ((ParameterParser)object2).setLowerCaseNames(true);
            object = ((ParameterParser)object2).parse((String)object, ';');
            object2 = object.get("name");
            if (object2 != null) {
                object2 = ((String)object2).trim();
            }
        }
        return object2;
    }

    @Deprecated
    protected String getFieldName(Map<String, String> map) {
        return FileUploadBase.b(this.getHeader(map, CONTENT_DISPOSITION));
    }

    @Deprecated
    protected FileItem createItem(Map<String, String> map, boolean bl2) {
        return this.getFileItemFactory().createItem(this.getFieldName(map), this.getHeader(map, CONTENT_TYPE), bl2, this.getFileName(map));
    }

    protected FileItemHeaders getParsedHeaders(String string) {
        int n2;
        int n3 = string.length();
        FileItemHeadersImpl fileItemHeadersImpl = this.newFileItemHeaders();
        int n4 = 0;
        while (n4 != (n2 = FileUploadBase.a(string, n4))) {
            int n5;
            CharSequence charSequence = new StringBuilder(string.substring(n4, n2));
            n4 = n2 + 2;
            while (n4 < n3) {
                for (n5 = n4; n5 < n3; ++n5) {
                    char c2 = string.charAt(n5);
                    n2 = c2;
                    if (c2 != ' ' && n2 != 9) break;
                }
                if (n5 == n4) break;
                n2 = FileUploadBase.a(string, n5);
                ((StringBuilder)charSequence).append(" ").append(string.substring(n5, n2));
                n4 = n2 + 2;
            }
            charSequence = ((StringBuilder)charSequence).toString();
            FileItemHeadersImpl fileItemHeadersImpl2 = fileItemHeadersImpl;
            n5 = ((String)charSequence).indexOf(58);
            if (n5 == -1) continue;
            String string2 = ((String)charSequence).substring(0, n5).trim();
            CharSequence charSequence2 = charSequence;
            charSequence = ((String)charSequence2).substring(((String)charSequence2).indexOf(58) + 1).trim();
            fileItemHeadersImpl2.addHeader(string2, (String)charSequence);
        }
        return fileItemHeadersImpl;
    }

    protected FileItemHeadersImpl newFileItemHeaders() {
        return new FileItemHeadersImpl();
    }

    @Deprecated
    protected Map<String, String> parseHeaders(String object) {
        object = this.getParsedHeaders((String)object);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator<String> iterator = object.getHeaderNames();
        while (iterator.hasNext()) {
            String string = iterator.next();
            Iterator<String> iterator2 = object.getHeaders(string);
            StringBuilder stringBuilder = new StringBuilder(iterator2.next());
            while (iterator2.hasNext()) {
                stringBuilder.append(",").append(iterator2.next());
            }
            hashMap.put(string, stringBuilder.toString());
        }
        return hashMap;
    }

    private static int a(String string, int n2) {
        while (true) {
            if ((n2 = string.indexOf(13, n2)) == -1 || n2 + 1 >= string.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (string.charAt(n2 + 1) == '\n') {
                return n2;
            }
            ++n2;
        }
    }

    @Deprecated
    protected final String getHeader(Map<String, String> map, String string) {
        return map.get(string.toLowerCase(Locale.ENGLISH));
    }

    public ProgressListener getProgressListener() {
        return this.d;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.d = progressListener;
    }

    public static class FileSizeLimitExceededException
    extends SizeException {
        private String a;
        private String b;

        public FileSizeLimitExceededException(String string, long l2, long l3) {
            super(string, l2, l3);
        }

        public String getFileName() {
            return this.a;
        }

        public void setFileName(String string) {
            this.a = string;
        }

        public String getFieldName() {
            return this.b;
        }

        public void setFieldName(String string) {
            this.b = string;
        }
    }

    public static class SizeLimitExceededException
    extends SizeException {
        @Deprecated
        public SizeLimitExceededException() {
            this(null, 0L, 0L);
        }

        @Deprecated
        public SizeLimitExceededException(String string) {
            this(string, 0L, 0L);
        }

        public SizeLimitExceededException(String string, long l2, long l3) {
            super(string, l2, l3);
        }
    }

    @Deprecated
    public static class UnknownSizeException
    extends FileUploadException {
        public UnknownSizeException() {
        }

        public UnknownSizeException(String string) {
            super(string);
        }
    }

    protected static abstract class SizeException
    extends FileUploadException {
        private final long a;
        private final long b;

        protected SizeException(String string, long l2, long l3) {
            super(string);
            this.a = l2;
            this.b = l3;
        }

        public long getActualSize() {
            return this.a;
        }

        public long getPermittedSize() {
            return this.b;
        }
    }

    public static class IOFileUploadException
    extends FileUploadException {
        private final IOException a;

        public IOFileUploadException(String string, IOException iOException) {
            super(string);
            this.a = iOException;
        }

        @Override
        public Throwable getCause() {
            return this.a;
        }
    }

    public static class InvalidContentTypeException
    extends FileUploadException {
        public InvalidContentTypeException() {
        }

        public InvalidContentTypeException(String string) {
            super(string);
        }

        public InvalidContentTypeException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class FileUploadIOException
    extends IOException {
        private final FileUploadException a;

        public FileUploadIOException(FileUploadException fileUploadException) {
            this.a = fileUploadException;
        }

        @Override
        public Throwable getCause() {
            return this.a;
        }
    }

    private final class org.apache.commons.fileupload.FileUploadBase$a
    implements FileItemIterator {
        private final MultipartStream b;
        private final MultipartStream.ProgressNotifier c;
        private final byte[] d;
        private a e;
        private String f;
        private boolean g;
        private boolean h;
        private boolean i;

        org.apache.commons.fileupload.FileUploadBase$a(RequestContext requestContext) {
            InputStream inputStream;
            long l2;
            if (requestContext == null) {
                throw new NullPointerException("ctx parameter");
            }
            String string = requestContext.getContentType();
            if (string == null || !string.toLowerCase(Locale.ENGLISH).startsWith(FileUploadBase.MULTIPART)) {
                throw new InvalidContentTypeException(String.format("the request doesn't contain a %s or %s stream, content type header is %s", FileUploadBase.MULTIPART_FORM_DATA, FileUploadBase.MULTIPART_MIXED, string));
            }
            int n2 = requestContext.getContentLength();
            long l3 = l2 = UploadContext.class.isAssignableFrom(requestContext.getClass()) ? ((UploadContext)requestContext).contentLength() : (long)n2;
            if (FileUploadBase.this.a >= 0L) {
                if (l2 != -1L && l2 > FileUploadBase.this.a) {
                    throw new SizeLimitExceededException(String.format("the request was rejected because its size (%s) exceeds the configured maximum (%s)", l2, FileUploadBase.this.a), l2, FileUploadBase.this.a);
                }
                inputStream = new LimitedInputStream(this, requestContext.getInputStream(), FileUploadBase.this.a, FileUploadBase.this){
                    private /* synthetic */ FileUploadBase a;
                    private /* synthetic */ org.apache.commons.fileupload.FileUploadBase$a b;
                    {
                        this.b = a2;
                        this.a = fileUploadBase;
                        super(inputStream, l2);
                    }

                    @Override
                    protected final void raiseError(long l2, long l3) {
                        SizeLimitExceededException sizeLimitExceededException = new SizeLimitExceededException(String.format("the request was rejected because its size (%s) exceeds the configured maximum (%s)", l3, l2), l3, l2);
                        throw new FileUploadIOException(sizeLimitExceededException);
                    }
                };
            } else {
                inputStream = requestContext.getInputStream();
            }
            String string2 = FileUploadBase.this.c;
            if (string2 == null) {
                string2 = requestContext.getCharacterEncoding();
            }
            this.d = FileUploadBase.this.getBoundary(string);
            if (this.d == null) {
                IOUtils.closeQuietly(inputStream);
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            this.c = new MultipartStream.ProgressNotifier(FileUploadBase.this.d, l2);
            try {
                this.b = new MultipartStream(inputStream, this.d, this.c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IOUtils.closeQuietly(inputStream);
                throw new InvalidContentTypeException(String.format("The boundary specified in the %s header is too long", FileUploadBase.CONTENT_TYPE), illegalArgumentException);
            }
            this.b.setHeaderEncoding(string2);
            this.g = true;
            this.a();
        }

        private boolean a() {
            if (this.i) {
                return false;
            }
            if (this.e != null) {
                this.e.a();
                this.e = null;
            }
            while (true) {
                String string;
                boolean bl2;
                if (!(bl2 = this.g ? this.b.skipPreamble() : this.b.readBoundary())) {
                    if (this.f == null) {
                        this.i = true;
                        return false;
                    }
                    this.b.setBoundary(this.d);
                    this.f = null;
                    continue;
                }
                FileItemHeaders fileItemHeaders = FileUploadBase.this.getParsedHeaders(this.b.readHeaders());
                if (this.f == null) {
                    string = FileUploadBase.this.getFieldName(fileItemHeaders);
                    if (string != null) {
                        Object object = fileItemHeaders.getHeader(FileUploadBase.CONTENT_TYPE);
                        if (object != null && ((String)object).toLowerCase(Locale.ENGLISH).startsWith(FileUploadBase.MULTIPART_MIXED)) {
                            this.f = string;
                            object = FileUploadBase.this.getBoundary((String)object);
                            this.b.setBoundary((byte[])object);
                            this.g = true;
                            continue;
                        }
                        object = FileUploadBase.this.getFileName(fileItemHeaders);
                        this.e = new a(this, (String)object, string, fileItemHeaders.getHeader(FileUploadBase.CONTENT_TYPE), object == null, org.apache.commons.fileupload.FileUploadBase$a.a(fileItemHeaders));
                        this.e.setHeaders(fileItemHeaders);
                        this.c.a();
                        this.h = true;
                        return true;
                    }
                } else {
                    string = FileUploadBase.this.getFileName(fileItemHeaders);
                    if (string != null) {
                        this.e = new a(this, string, this.f, fileItemHeaders.getHeader(FileUploadBase.CONTENT_TYPE), false, org.apache.commons.fileupload.FileUploadBase$a.a(fileItemHeaders));
                        this.e.setHeaders(fileItemHeaders);
                        this.c.a();
                        this.h = true;
                        return true;
                    }
                }
                this.b.discardBodyData();
            }
        }

        private static long a(FileItemHeaders fileItemHeaders) {
            try {
                return Long.parseLong(fileItemHeaders.getHeader(FileUploadBase.CONTENT_LENGTH));
            }
            catch (Exception exception) {
                return -1L;
            }
        }

        @Override
        public final boolean hasNext() {
            if (this.i) {
                return false;
            }
            if (this.h) {
                return true;
            }
            try {
                return this.a();
            }
            catch (FileUploadIOException fileUploadIOException) {
                FileUploadIOException fileUploadIOException2 = fileUploadIOException;
                throw (FileUploadException)fileUploadIOException.getCause();
            }
        }

        @Override
        public final FileItemStream next() {
            if (this.i || !this.h && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.h = false;
            return this.e;
        }

        final class a
        implements FileItemStream {
            private final String a;
            private final String b;
            private final String c;
            private final boolean d;
            private final InputStream e;
            private boolean f;
            private FileItemHeaders g;
            private /* synthetic */ org.apache.commons.fileupload.FileUploadBase$a h;

            a(org.apache.commons.fileupload.FileUploadBase$a a2, String object, String string, String object2, boolean bl2, long l2) {
                this.h = a2;
                this.c = object;
                this.b = string;
                this.a = object2;
                this.d = bl2;
                if (a2.FileUploadBase.this.b != -1L && l2 != -1L && l2 > a2.FileUploadBase.this.b) {
                    object2 = new FileSizeLimitExceededException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", this.b, a2.FileUploadBase.this.b), l2, a2.FileUploadBase.this.b);
                    ((FileSizeLimitExceededException)object2).setFileName((String)object);
                    ((FileSizeLimitExceededException)object2).setFieldName(string);
                    throw new FileUploadIOException((FileUploadException)object2);
                }
                object = object2 = a2.b.a();
                if (a2.FileUploadBase.this.b != -1L) {
                    object = new LimitedInputStream(this, (MultipartStream.ItemInputStream)object, a2.FileUploadBase.this.b, a2, (MultipartStream.ItemInputStream)object2){
                        private /* synthetic */ org.apache.commons.fileupload.FileUploadBase$a a;
                        private /* synthetic */ MultipartStream.ItemInputStream b;
                        private /* synthetic */ a c;
                        {
                            this.c = a2;
                            this.a = a3;
                            this.b = itemInputStream2;
                            super(itemInputStream, l2);
                        }

                        @Override
                        protected final void raiseError(long l2, long l3) {
                            this.b.close(true);
                            FileSizeLimitExceededException fileSizeLimitExceededException = new FileSizeLimitExceededException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", this.c.b, l2), l3, l2);
                            fileSizeLimitExceededException.setFieldName(this.c.b);
                            fileSizeLimitExceededException.setFileName(this.c.c);
                            throw new FileUploadIOException(fileSizeLimitExceededException);
                        }
                    };
                }
                this.e = object;
            }

            @Override
            public final String getContentType() {
                return this.a;
            }

            @Override
            public final String getFieldName() {
                return this.b;
            }

            @Override
            public final String getName() {
                return Streams.checkFileName(this.c);
            }

            @Override
            public final boolean isFormField() {
                return this.d;
            }

            @Override
            public final InputStream openStream() {
                if (((Closeable)((Object)this.e)).isClosed()) {
                    throw new FileItemStream.ItemSkippedException();
                }
                return this.e;
            }

            final void a() {
                this.e.close();
            }

            @Override
            public final FileItemHeaders getHeaders() {
                return this.g;
            }

            @Override
            public final void setHeaders(FileItemHeaders fileItemHeaders) {
                this.g = fileItemHeaders;
            }
        }
    }
}

