/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.util.Closeable;
import org.apache.commons.fileupload.util.Streams;

public class MultipartStream {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte DASH = 45;
    public static final int HEADER_PART_SIZE_MAX = 10240;
    protected static final int DEFAULT_BUFSIZE = 4096;
    protected static final byte[] HEADER_SEPARATOR = new byte[]{13, 10, 13, 10};
    protected static final byte[] FIELD_SEPARATOR = new byte[]{13, 10};
    protected static final byte[] STREAM_TERMINATOR = new byte[]{45, 45};
    protected static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private final InputStream a;
    private int b;
    private final int c;
    private final byte[] d;
    private final int[] e;
    private final int f;
    private final byte[] g;
    private int h;
    private int i;
    private String j;
    private final ProgressNotifier k;

    @Deprecated
    public MultipartStream() {
        this(null, null, null);
    }

    @Deprecated
    public MultipartStream(InputStream inputStream, byte[] byArray, int n2) {
        this(inputStream, byArray, n2, null);
    }

    public MultipartStream(InputStream inputStream, byte[] byArray, int n2, ProgressNotifier progressNotifier) {
        if (byArray == null) {
            throw new IllegalArgumentException("boundary may not be null");
        }
        this.b = byArray.length + BOUNDARY_PREFIX.length;
        if (n2 < this.b + 1) {
            throw new IllegalArgumentException("The buffer size specified for the MultipartStream is too small");
        }
        this.a = inputStream;
        this.f = Math.max(n2, this.b << 1);
        this.g = new byte[this.f];
        this.k = progressNotifier;
        this.d = new byte[this.b];
        this.e = new int[this.b + 1];
        this.c = this.d.length;
        System.arraycopy(BOUNDARY_PREFIX, 0, this.d, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(byArray, 0, this.d, BOUNDARY_PREFIX.length, byArray.length);
        this.b();
        this.h = 0;
        this.i = 0;
    }

    MultipartStream(InputStream inputStream, byte[] byArray, ProgressNotifier progressNotifier) {
        this(inputStream, byArray, 4096, progressNotifier);
    }

    @Deprecated
    public MultipartStream(InputStream inputStream, byte[] byArray) {
        this(inputStream, byArray, 4096, null);
    }

    public String getHeaderEncoding() {
        return this.j;
    }

    public void setHeaderEncoding(String string) {
        this.j = string;
    }

    public byte readByte() {
        if (this.h == this.i) {
            this.h = 0;
            this.i = this.a.read(this.g, this.h, this.f);
            if (this.i == -1) {
                throw new IOException("No more data is available");
            }
            if (this.k != null) {
                this.k.a(this.i);
            }
        }
        return this.g[this.h++];
    }

    public boolean readBoundary() {
        boolean bl2;
        block6: {
            Object object = new byte[2];
            this.h += this.b;
            try {
                object[0] = this.readByte();
                if (object[0] == 10) {
                    return true;
                }
                object[1] = this.readByte();
                if (MultipartStream.arrayequals(object, STREAM_TERMINATOR, 2)) {
                    bl2 = false;
                    break block6;
                }
                if (MultipartStream.arrayequals(object, FIELD_SEPARATOR, 2)) {
                    bl2 = true;
                    break block6;
                }
                throw new MalformedStreamException("Unexpected characters follow a boundary");
            }
            catch (FileUploadBase.FileUploadIOException fileUploadIOException) {
                object = fileUploadIOException;
                throw fileUploadIOException;
            }
            catch (IOException iOException) {
                throw new MalformedStreamException("Stream ended unexpectedly");
            }
        }
        return bl2;
    }

    public void setBoundary(byte[] byArray) {
        if (byArray.length != this.b - BOUNDARY_PREFIX.length) {
            throw new IllegalBoundaryException("The length of a boundary token cannot be changed");
        }
        System.arraycopy(byArray, 0, this.d, BOUNDARY_PREFIX.length, byArray.length);
        this.b();
    }

    private void b() {
        int n2 = 2;
        int n3 = 0;
        this.e[0] = -1;
        this.e[1] = 0;
        while (n2 <= this.b) {
            if (this.d[n2 - 1] == this.d[n3]) {
                this.e[n2] = n3 + 1;
                ++n3;
                ++n2;
                continue;
            }
            if (n3 > 0) {
                n3 = this.e[n3];
                continue;
            }
            this.e[n2] = 0;
            ++n2;
        }
    }

    public String readHeaders() {
        String string;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        while (n2 < HEADER_SEPARATOR.length) {
            byte by;
            try {
                by = this.readByte();
            }
            catch (FileUploadBase.FileUploadIOException fileUploadIOException) {
                FileUploadBase.FileUploadIOException fileUploadIOException2 = fileUploadIOException;
                throw fileUploadIOException;
            }
            catch (IOException iOException) {
                throw new MalformedStreamException("Stream ended unexpectedly");
            }
            if (++n3 > 10240) {
                throw new MalformedStreamException(String.format("Header section has more than %s bytes (maybe it is not properly terminated)", 10240));
            }
            n2 = by == HEADER_SEPARATOR[n2] ? ++n2 : 0;
            byteArrayOutputStream.write(by);
        }
        if (this.j != null) {
            try {
                string = byteArrayOutputStream.toString(this.j);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        string = byteArrayOutputStream.toString();
        return string;
    }

    public int readBodyData(OutputStream outputStream) {
        return (int)Streams.copy(this.a(), outputStream, false);
    }

    final ItemInputStream a() {
        return new ItemInputStream(this);
    }

    public int discardBodyData() {
        return this.readBodyData(null);
    }

    public boolean skipPreamble() {
        System.arraycopy(this.d, 2, this.d, 0, this.d.length - 2);
        this.b = this.d.length - 2;
        this.b();
        try {
            this.discardBodyData();
            boolean bl2 = this.readBoundary();
            return bl2;
        }
        catch (MalformedStreamException malformedStreamException) {
            return false;
        }
        finally {
            System.arraycopy(this.d, 0, this.d, 2, this.d.length - 2);
            this.b = this.d.length;
            this.d[0] = 13;
            this.d[1] = 10;
            this.b();
        }
    }

    public static boolean arrayequals(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    protected int findByte(byte by, int n2) {
        while (n2 < this.i) {
            if (this.g[n2] == by) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected int findSeparator() {
        int n2 = 0;
        for (int i2 = this.h; i2 < this.i; ++i2) {
            while (n2 >= 0 && this.g[i2] != this.d[n2]) {
                n2 = this.e[n2];
            }
            if (++n2 != this.b) continue;
            return i2 - this.b;
        }
        return -1;
    }

    public class ItemInputStream
    extends InputStream
    implements Closeable {
        private long a;
        private int b;
        private int c;
        private boolean d;
        private /* synthetic */ MultipartStream e;

        ItemInputStream(MultipartStream multipartStream) {
            this.e = multipartStream;
            this.a();
        }

        private void a() {
            this.c = this.e.findSeparator();
            if (this.c == -1) {
                if (this.e.i - this.e.h > this.e.c) {
                    this.b = this.e.c;
                    return;
                }
                this.b = this.e.i - this.e.h;
            }
        }

        public long getBytesRead() {
            return this.a;
        }

        @Override
        public int available() {
            if (this.c == -1) {
                return this.e.i - this.e.h - this.b;
            }
            return this.c - this.e.h;
        }

        @Override
        public int read() {
            if (this.d) {
                throw new FileItemStream.ItemSkippedException();
            }
            if (this.available() == 0 && this.b() == 0) {
                return -1;
            }
            ++this.a;
            byte by = this.e.g[this.e.h++];
            if (by >= 0) {
                return by;
            }
            return by + 256;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) {
            if (this.d) {
                throw new FileItemStream.ItemSkippedException();
            }
            if (n3 == 0) {
                return 0;
            }
            int n4 = this.available();
            if (n4 == 0 && (n4 = this.b()) == 0) {
                return -1;
            }
            n4 = Math.min(n4, n3);
            System.arraycopy(this.e.g, this.e.h, byArray, n2, n4);
            this.e.h = this.e.h + n4;
            this.a += (long)n4;
            return n4;
        }

        @Override
        public void close() {
            this.close(false);
        }

        public void close(boolean n2) {
            if (this.d) {
                return;
            }
            if (n2 != 0) {
                this.d = true;
                this.e.a.close();
            } else {
                while ((n2 = this.available()) != 0 || (n2 = this.b()) != 0) {
                    this.skip(n2);
                }
            }
            this.d = true;
        }

        @Override
        public long skip(long l2) {
            if (this.d) {
                throw new FileItemStream.ItemSkippedException();
            }
            int n2 = this.available();
            if (n2 == 0 && (n2 = this.b()) == 0) {
                return 0L;
            }
            long l3 = Math.min((long)n2, l2);
            this.e.h = (int)((long)this.e.h + l3);
            return l3;
        }

        private int b() {
            int n2;
            if (this.c != -1) {
                return 0;
            }
            this.a += (long)(this.e.i - this.e.h - this.b);
            System.arraycopy(this.e.g, this.e.i - this.b, this.e.g, 0, this.b);
            this.e.h = 0;
            this.e.i = this.b;
            do {
                if ((n2 = this.e.a.read(this.e.g, this.e.i, this.e.f - this.e.i)) == -1) {
                    throw new MalformedStreamException("Stream ended unexpectedly");
                }
                if (this.e.k != null) {
                    this.e.k.a(n2);
                }
                this.e.i = this.e.i + n2;
                this.a();
            } while ((n2 = this.available()) <= 0 && this.c == -1);
            return n2;
        }

        @Override
        public boolean isClosed() {
            return this.d;
        }
    }

    public static class IllegalBoundaryException
    extends IOException {
        public IllegalBoundaryException() {
        }

        public IllegalBoundaryException(String string) {
            super(string);
        }
    }

    public static class MalformedStreamException
    extends IOException {
        public MalformedStreamException() {
        }

        public MalformedStreamException(String string) {
            super(string);
        }
    }

    public static class ProgressNotifier {
        private final ProgressListener a;
        private final long b;
        private long c;
        private int d;

        ProgressNotifier(ProgressListener progressListener, long l2) {
            this.a = progressListener;
            this.b = l2;
        }

        final void a(int n2) {
            this.c += (long)n2;
            this.b();
        }

        final void a() {
            ++this.d;
            this.b();
        }

        private void b() {
            if (this.a != null) {
                this.a.update(this.c, this.b, this.d);
            }
        }
    }
}

