/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload.disk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;

public class DiskFileItem
implements FileItem {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String a = UUID.randomUUID().toString().replace('-', '_');
    private static final AtomicInteger b = new AtomicInteger(0);
    private String c;
    private final String d;
    private boolean e;
    private final String f;
    private long g = -1L;
    private final int h;
    private final File i;
    private byte[] j;
    private transient DeferredFileOutputStream k;
    private transient File l;
    private FileItemHeaders m;
    private String n = "ISO-8859-1";

    public DiskFileItem(String string, String string2, boolean bl2, String string3, int n2, File file) {
        this.c = string;
        this.d = string2;
        this.e = bl2;
        this.f = string3;
        this.h = n2;
        this.i = file;
    }

    @Override
    public InputStream getInputStream() {
        if (!this.isInMemory()) {
            return new FileInputStream(this.k.getFile());
        }
        if (this.j == null) {
            this.j = this.k.getData();
        }
        return new ByteArrayInputStream(this.j);
    }

    @Override
    public String getContentType() {
        return this.d;
    }

    public String getCharSet() {
        Object object = new ParameterParser();
        ((ParameterParser)object).setLowerCaseNames(true);
        object = ((ParameterParser)object).parse(this.getContentType(), ';');
        return object.get("charset");
    }

    @Override
    public String getName() {
        return Streams.checkFileName(this.f);
    }

    @Override
    public boolean isInMemory() {
        if (this.j != null) {
            return true;
        }
        return this.k.isInMemory();
    }

    @Override
    public long getSize() {
        if (this.g >= 0L) {
            return this.g;
        }
        if (this.j != null) {
            return this.j.length;
        }
        if (this.k.isInMemory()) {
            return this.k.getData().length;
        }
        return this.k.getFile().length();
    }

    @Override
    public byte[] get() {
        if (this.isInMemory()) {
            if (this.j == null && this.k != null) {
                this.j = this.k.getData();
            }
            return this.j;
        }
        byte[] byArray = new byte[(int)this.getSize()];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.k.getFile());
            IOUtils.readFully((InputStream)fileInputStream, byArray);
        }
        catch (IOException iOException) {
            byArray = null;
            IOUtils.closeQuietly(fileInputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        return byArray;
    }

    @Override
    public String getString(String string) {
        return new String(this.get(), string);
    }

    @Override
    public String getString() {
        byte[] byArray = this.get();
        String string = this.getCharSet();
        if (string == null) {
            string = this.n;
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    @Override
    public void write(File file) {
        FileOutputStream fileOutputStream;
        block4: {
            block3: {
                if (!this.isInMemory()) break block3;
                fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(this.get());
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileOutputStream);
                    throw throwable;
                }
                break block4;
            }
            File file2 = this.getStoreLocation();
            if (file2 != null) {
                this.g = file2.length();
                FileUtils.moveFile(file2, file);
                return;
            }
            throw new FileUploadException("Cannot write uploaded file to disk!");
        }
        IOUtils.closeQuietly(fileOutputStream);
    }

    @Override
    public void delete() {
        this.j = null;
        File file = this.getStoreLocation();
        if (file != null && !this.isInMemory() && file.exists()) {
            file.delete();
        }
    }

    @Override
    public String getFieldName() {
        return this.c;
    }

    @Override
    public void setFieldName(String string) {
        this.c = string;
    }

    @Override
    public boolean isFormField() {
        return this.e;
    }

    @Override
    public void setFormField(boolean bl2) {
        this.e = bl2;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.k == null) {
            File file = this.getTempFile();
            this.k = new DeferredFileOutputStream(this.h, file);
        }
        return this.k;
    }

    public File getStoreLocation() {
        if (this.k == null) {
            return null;
        }
        if (this.isInMemory()) {
            return null;
        }
        return this.k.getFile();
    }

    protected void finalize() {
        if (this.k == null || this.k.isInMemory()) {
            return;
        }
        File file = this.k.getFile();
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    protected File getTempFile() {
        if (this.l == null) {
            File file = this.i;
            if (file == null) {
                file = new File(System.getProperty("java.io.tmpdir"));
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            int n2 = b.getAndIncrement();
            String string = Integer.toString(n2);
            if (n2 < 100000000) {
                string = ("00000000" + string).substring(string.length());
            }
            objectArray[1] = string;
            String string2 = String.format("upload_%s_%s.tmp", objectArray);
            this.l = new File(file, string2);
        }
        return this.l;
    }

    public String toString() {
        return String.format("name=%s, StoreLocation=%s, size=%s bytes, isFormField=%s, FieldName=%s", this.getName(), this.getStoreLocation(), this.getSize(), this.isFormField(), this.getFieldName());
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.m;
    }

    @Override
    public void setHeaders(FileItemHeaders fileItemHeaders) {
        this.m = fileItemHeaders;
    }

    public String getDefaultCharset() {
        return this.n;
    }

    public void setDefaultCharset(String string) {
        this.n = string;
    }
}

