/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.InvalidFileNameException;
import org.apache.commons.io.IOUtils;

public final class Streams {
    private Streams() {
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, boolean bl2) {
        return Streams.copy(inputStream, outputStream, bl2, new byte[8192]);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, boolean bl2, byte[] byArray) {
        long l2;
        try {
            int n2;
            long l3 = 0L;
            while ((n2 = inputStream.read(byArray)) != -1) {
                if (n2 <= 0) continue;
                l3 += (long)n2;
                if (outputStream == null) continue;
                outputStream.write(byArray, 0, n2);
            }
            if (outputStream != null) {
                if (bl2) {
                    outputStream.close();
                } else {
                    outputStream.flush();
                }
                outputStream = null;
            }
            inputStream.close();
            inputStream = null;
            l2 = l3;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            if (bl2) {
                IOUtils.closeQuietly(outputStream);
            }
            throw throwable;
        }
        IOUtils.closeQuietly(null);
        if (bl2) {
            IOUtils.closeQuietly(outputStream);
        }
        return l2;
    }

    public static String asString(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.copy(inputStream, byteArrayOutputStream, true);
        return byteArrayOutputStream.toString();
    }

    public static String asString(InputStream inputStream, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.copy(inputStream, byteArrayOutputStream, true);
        return byteArrayOutputStream.toString(string);
    }

    public static String checkFileName(String string) {
        if (string != null && string.indexOf(0) != -1) {
            StringBuilder stringBuilder = new StringBuilder();
            block3: for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                switch (c2) {
                    case '\u0000': {
                        stringBuilder.append("\\0");
                        continue block3;
                    }
                    default: {
                        stringBuilder.append(c2);
                    }
                }
            }
            throw new InvalidFileNameException(string, "Invalid file name: " + stringBuilder);
        }
        return string;
    }
}

