/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.Serializable;

public class ByteOrderMark
implements Serializable {
    public static final ByteOrderMark UTF_8 = new ByteOrderMark("UTF-8", 239, 187, 191);
    public static final ByteOrderMark UTF_16BE = new ByteOrderMark("UTF-16BE", 254, 255);
    public static final ByteOrderMark UTF_16LE = new ByteOrderMark("UTF-16LE", 255, 254);
    public static final ByteOrderMark UTF_32BE = new ByteOrderMark("UTF-32BE", 0, 0, 254, 255);
    public static final ByteOrderMark UTF_32LE = new ByteOrderMark("UTF-32LE", 255, 254, 0, 0);
    public static final char UTF_BOM = '\ufeff';
    private final String a;
    private final int[] b;

    public ByteOrderMark(String string, int ... nArray) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("No charsetName specified");
        }
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("No bytes specified");
        }
        this.a = string;
        this.b = new int[nArray.length];
        System.arraycopy(nArray, 0, this.b, 0, nArray.length);
    }

    public String getCharsetName() {
        return this.a;
    }

    public int length() {
        return this.b.length;
    }

    public int get(int n2) {
        return this.b[n2];
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.b.length];
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            byArray[i2] = (byte)this.b[i2];
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ByteOrderMark)) {
            return false;
        }
        if (this.b.length != ((ByteOrderMark)(object = (ByteOrderMark)object)).length()) {
            return false;
        }
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            if (this.b[i2] == ((ByteOrderMark)object).get(i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.getClass().hashCode();
        int[] nArray = this.b;
        int n3 = this.b.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            n2 += n4;
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('[');
        stringBuilder.append(this.a);
        stringBuilder.append(": ");
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("0x");
            stringBuilder.append(Integer.toHexString(0xFF & this.b[i2]).toUpperCase());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

