/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public abstract class DirectoryWalker<T> {
    private final FileFilter a;
    private final int b;

    protected DirectoryWalker() {
        this(null, -1);
    }

    protected DirectoryWalker(FileFilter fileFilter, int n2) {
        this.a = fileFilter;
        this.b = n2;
    }

    protected DirectoryWalker(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2, int n2) {
        if (iOFileFilter == null && iOFileFilter2 == null) {
            this.a = null;
        } else {
            iOFileFilter = iOFileFilter != null ? iOFileFilter : TrueFileFilter.TRUE;
            iOFileFilter2 = iOFileFilter2 != null ? iOFileFilter2 : TrueFileFilter.TRUE;
            iOFileFilter = FileFilterUtils.makeDirectoryOnly(iOFileFilter);
            iOFileFilter2 = FileFilterUtils.makeFileOnly(iOFileFilter2);
            this.a = FileFilterUtils.or(iOFileFilter, iOFileFilter2);
        }
        this.b = n2;
    }

    protected final void walk(File file, Collection<T> collection) {
        if (file == null) {
            throw new NullPointerException("Start Directory is null");
        }
        try {
            this.handleStart(file, collection);
            this.a(file, 0, collection);
            this.handleEnd(collection);
            return;
        }
        catch (CancelException cancelException) {
            this.handleCancelled(file, collection, cancelException);
            return;
        }
    }

    private void a(File file, int n2, Collection<T> collection) {
        this.checkIfCancelled(file, n2, collection);
        if (this.handleDirectory(file, n2, collection)) {
            this.handleDirectoryStart(file, n2, collection);
            int n3 = n2 + 1;
            if (this.b < 0 || n3 <= this.b) {
                this.checkIfCancelled(file, n2, collection);
                File[] fileArray = this.a == null ? file.listFiles() : file.listFiles(this.a);
                fileArray = this.filterDirectoryContents(file, n2, fileArray);
                if (fileArray == null) {
                    this.handleRestricted(file, n3, collection);
                } else {
                    for (File file2 : fileArray) {
                        if (file2.isDirectory()) {
                            this.a(file2, n3, collection);
                            continue;
                        }
                        this.checkIfCancelled(file2, n3, collection);
                        this.handleFile(file2, n3, collection);
                        this.checkIfCancelled(file2, n3, collection);
                    }
                }
            }
            this.handleDirectoryEnd(file, n2, collection);
        }
        this.checkIfCancelled(file, n2, collection);
    }

    protected final void checkIfCancelled(File file, int n2, Collection<T> collection) {
        if (this.handleIsCancelled(file, n2, collection)) {
            throw new CancelException(file, n2);
        }
    }

    protected boolean handleIsCancelled(File file, int n2, Collection<T> collection) {
        return false;
    }

    protected void handleCancelled(File file, Collection<T> collection, CancelException cancelException) {
        throw cancelException;
    }

    protected void handleStart(File file, Collection<T> collection) {
    }

    protected boolean handleDirectory(File file, int n2, Collection<T> collection) {
        return true;
    }

    protected void handleDirectoryStart(File file, int n2, Collection<T> collection) {
    }

    protected File[] filterDirectoryContents(File file, int n2, File[] fileArray) {
        return fileArray;
    }

    protected void handleFile(File file, int n2, Collection<T> collection) {
    }

    protected void handleRestricted(File file, int n2, Collection<T> collection) {
    }

    protected void handleDirectoryEnd(File file, int n2, Collection<T> collection) {
    }

    protected void handleEnd(Collection<T> collection) {
    }

    public static class CancelException
    extends IOException {
        private final File a;
        private final int b;

        public CancelException(File file, int n2) {
            this("Operation Cancelled", file, n2);
        }

        public CancelException(String string, File file, int n2) {
            super(string);
            this.a = file;
            this.b = n2;
        }

        public File getFile() {
            return this.a;
        }

        public int getDepth() {
            return this.b;
        }
    }
}

