/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.output.NullOutputStream;

public class FileUtils {
    public static final long ONE_KB = 1024L;
    public static final BigInteger ONE_KB_BI = BigInteger.valueOf(1024L);
    public static final long ONE_MB = 0x100000L;
    public static final BigInteger ONE_MB_BI = ONE_KB_BI.multiply(ONE_KB_BI);
    public static final long ONE_GB = 0x40000000L;
    public static final BigInteger ONE_GB_BI = ONE_KB_BI.multiply(ONE_MB_BI);
    public static final long ONE_TB = 0x10000000000L;
    public static final BigInteger ONE_TB_BI = ONE_KB_BI.multiply(ONE_GB_BI);
    public static final long ONE_PB = 0x4000000000000L;
    public static final BigInteger ONE_PB_BI = ONE_KB_BI.multiply(ONE_TB_BI);
    public static final long ONE_EB = 0x1000000000000000L;
    public static final BigInteger ONE_EB_BI = ONE_KB_BI.multiply(ONE_PB_BI);
    public static final BigInteger ONE_ZB = BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(0x1000000000000000L));
    public static final BigInteger ONE_YB = ONE_KB_BI.multiply(ONE_ZB);
    public static final File[] EMPTY_FILE_ARRAY = new File[0];

    public static File getFile(File file, String ... stringArray) {
        if (file == null) {
            throw new NullPointerException("directory must not be null");
        }
        if (stringArray == null) {
            throw new NullPointerException("names must not be null");
        }
        for (String string : stringArray) {
            file = new File(file, string);
        }
        return file;
    }

    public static File getFile(String ... stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("names must not be null");
        }
        File file = null;
        for (String string : stringArray) {
            file = file == null ? new File(string) : new File(file, string);
        }
        return file;
    }

    public static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getTempDirectory() {
        return new File(FileUtils.getTempDirectoryPath());
    }

    public static String getUserDirectoryPath() {
        return System.getProperty("user.home");
    }

    public static File getUserDirectory() {
        return new File(FileUtils.getUserDirectoryPath());
    }

    public static FileInputStream openInputStream(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) {
        return FileUtils.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean bl2) {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File file2 = file.getParentFile();
            if (file2 != null && !file2.mkdirs() && !file2.isDirectory()) {
                throw new IOException("Directory '" + file2 + "' could not be created");
            }
        }
        return new FileOutputStream(file, bl2);
    }

    public static String byteCountToDisplaySize(BigInteger object) {
        object = ((BigInteger)object).divide(ONE_EB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(((BigInteger)object).divide(ONE_EB_BI)) + " EB" : (((BigInteger)object).divide(ONE_PB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(((BigInteger)object).divide(ONE_PB_BI)) + " PB" : (((BigInteger)object).divide(ONE_TB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(((BigInteger)object).divide(ONE_TB_BI)) + " TB" : (((BigInteger)object).divide(ONE_GB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(((BigInteger)object).divide(ONE_GB_BI)) + " GB" : (((BigInteger)object).divide(ONE_MB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(((BigInteger)object).divide(ONE_MB_BI)) + " MB" : (((BigInteger)object).divide(ONE_KB_BI).compareTo(BigInteger.ZERO) > 0 ? String.valueOf(((BigInteger)object).divide(ONE_KB_BI)) + " KB" : String.valueOf(object) + " bytes")))));
        return object;
    }

    public static String byteCountToDisplaySize(long l2) {
        return FileUtils.byteCountToDisplaySize(BigInteger.valueOf(l2));
    }

    public static void touch(File file) {
        boolean bl2;
        if (!file.exists()) {
            FileUtils.openOutputStream(file).close();
        }
        if (!(bl2 = file.setLastModified(System.currentTimeMillis()))) {
            throw new IOException("Unable to set the last modification time for " + file);
        }
    }

    public static File[] convertFileCollectionToFileArray(Collection<File> collection) {
        Collection<File> collection2 = collection;
        return collection2.toArray(new File[collection2.size()]);
    }

    private static void a(Collection<File> collection, File fileArray, IOFileFilter iOFileFilter, boolean bl2) {
        if ((fileArray = fileArray.listFiles(iOFileFilter)) != null) {
            for (File file : fileArray) {
                if (file.isDirectory()) {
                    if (bl2) {
                        collection.add(file);
                    }
                    FileUtils.a(collection, file, iOFileFilter, bl2);
                    continue;
                }
                collection.add(file);
            }
        }
    }

    public static Collection<File> listFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        FileUtils.a(file, iOFileFilter);
        iOFileFilter = FileUtils.a(iOFileFilter);
        iOFileFilter2 = FileUtils.b(iOFileFilter2);
        LinkedList<File> linkedList = new LinkedList<File>();
        FileUtils.a(linkedList, file, FileFilterUtils.or(iOFileFilter, iOFileFilter2), false);
        return linkedList;
    }

    private static void a(File file, IOFileFilter iOFileFilter) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Parameter 'directory' is not a directory: " + file);
        }
        if (iOFileFilter == null) {
            throw new NullPointerException("Parameter 'fileFilter' is null");
        }
    }

    private static IOFileFilter a(IOFileFilter iOFileFilter) {
        return FileFilterUtils.and(iOFileFilter, FileFilterUtils.notFileFilter(DirectoryFileFilter.INSTANCE));
    }

    private static IOFileFilter b(IOFileFilter iOFileFilter) {
        if (iOFileFilter == null) {
            return FalseFileFilter.INSTANCE;
        }
        return FileFilterUtils.and(iOFileFilter, DirectoryFileFilter.INSTANCE);
    }

    public static Collection<File> listFilesAndDirs(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        FileUtils.a(file, iOFileFilter);
        iOFileFilter = FileUtils.a(iOFileFilter);
        iOFileFilter2 = FileUtils.b(iOFileFilter2);
        LinkedList<File> linkedList = new LinkedList<File>();
        if (file.isDirectory()) {
            linkedList.add(file);
        }
        FileUtils.a(linkedList, file, FileFilterUtils.or(iOFileFilter, iOFileFilter2), true);
        return linkedList;
    }

    public static Iterator<File> iterateFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFiles(file, iOFileFilter, iOFileFilter2).iterator();
    }

    public static Iterator<File> iterateFilesAndDirs(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFilesAndDirs(file, iOFileFilter, iOFileFilter2).iterator();
    }

    public static Collection<File> listFiles(File file, String[] object, boolean bl2) {
        if (object == null) {
            object = TrueFileFilter.INSTANCE;
        } else {
            String[] stringArray = new String[((String[])object).length];
            for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                stringArray[i2] = "." + object[i2];
            }
            object = stringArray;
            object = new SuffixFileFilter((String[])object);
        }
        return FileUtils.listFiles(file, (IOFileFilter)object, bl2 ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE);
    }

    public static Iterator<File> iterateFiles(File file, String[] stringArray, boolean bl2) {
        return FileUtils.listFiles(file, stringArray, bl2).iterator();
    }

    /*
     * Loose catch block
     */
    public static boolean contentEquals(File object, File object2) {
        boolean bl2 = ((File)object).exists();
        if (bl2 != ((File)object2).exists()) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        if (((File)object).isDirectory() || ((File)object2).isDirectory()) {
            throw new IOException("Can't compare directories, only files");
        }
        if (((File)object).length() != ((File)object2).length()) {
            return false;
        }
        if (((File)object).getCanonicalFile().equals(((File)object2).getCanonicalFile())) {
            return true;
        }
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        object2 = new FileInputStream((File)object2);
        Throwable throwable2 = null;
        boolean bl3 = IOUtils.contentEquals((InputStream)object, (InputStream)object2);
        ((InputStream)object2).close();
        ((InputStream)object).close();
        return bl3;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            Throwable throwable4 = throwable3;
                            throwable2 = throwable3;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 != null) {
                                try {
                                    ((InputStream)object2).close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                ((InputStream)object2).close();
                            }
                            throw throwable5;
                        }
                    }
                    catch (Throwable throwable7) {
                        object2 = throwable7;
                        throwable = throwable7;
                        throw object2;
                    }
                }
                catch (Throwable throwable8) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                    throw throwable8;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public static boolean contentEqualsIgnoreEOL(File object, File object2, String object3) {
        boolean bl2 = ((File)object).exists();
        if (bl2 != ((File)object2).exists()) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        if (((File)object).isDirectory() || ((File)object2).isDirectory()) {
            throw new IOException("Can't compare directories, only files");
        }
        if (((File)object).getCanonicalFile().equals(((File)object2).getCanonicalFile())) {
            return true;
        }
        object = object3 == null ? new InputStreamReader((InputStream)new FileInputStream((File)object), Charset.defaultCharset()) : new InputStreamReader((InputStream)new FileInputStream((File)object), (String)object3);
        Throwable throwable = null;
        object2 = object3 == null ? new InputStreamReader((InputStream)new FileInputStream((File)object2), Charset.defaultCharset()) : new InputStreamReader((InputStream)new FileInputStream((File)object2), (String)object3);
        object3 = null;
        boolean bl3 = IOUtils.contentEqualsIgnoreEOL((Reader)object, (Reader)object2);
        ((Reader)object2).close();
        ((Reader)object).close();
        return bl3;
        {
            catch (Throwable throwable2) {
                try {
                    try {
                        try {
                            Throwable throwable3 = throwable2;
                            object3 = throwable2;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (object3 != null) {
                                try {
                                    ((Reader)object2).close();
                                }
                                catch (Throwable throwable5) {
                                    ((Throwable)object3).addSuppressed(throwable5);
                                }
                            } else {
                                ((Reader)object2).close();
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable6) {
                        object2 = throwable6;
                        throwable = throwable6;
                        throw object2;
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable != null) {
                        try {
                            ((Reader)object).close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        ((Reader)object).close();
                    }
                    throw throwable7;
                }
            }
        }
    }

    public static File toFile(URL object) {
        if (object == null || !"file".equalsIgnoreCase(((URL)object).getProtocol())) {
            return null;
        }
        object = ((URL)object).getFile().replace('/', File.separatorChar);
        object = FileUtils.a((String)object);
        return new File((String)object);
    }

    private static String a(String string) {
        String string2 = string;
        if (string != null && string.indexOf(37) >= 0) {
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            int n3 = 0;
            while (n3 < n2) {
                if (string.charAt(n3) == '%') {
                    try {
                        do {
                            byte by = (byte)Integer.parseInt(string.substring(n3 + 1, n3 + 3), 16);
                            byteBuffer.put(by);
                        } while ((n3 += 3) < n2 && string.charAt(n3) == '%');
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    finally {
                        if (byteBuffer.position() <= 0) continue;
                        byteBuffer.flip();
                        stringBuilder.append(StandardCharsets.UTF_8.decode(byteBuffer).toString());
                        byteBuffer.clear();
                        continue;
                    }
                }
                stringBuilder.append(string.charAt(n3++));
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public static File[] toFiles(URL[] uRLArray) {
        if (uRLArray == null || uRLArray.length == 0) {
            return EMPTY_FILE_ARRAY;
        }
        File[] fileArray = new File[uRLArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            URL uRL = uRLArray[i2];
            if (uRL == null) continue;
            if (!uRL.getProtocol().equals("file")) {
                throw new IllegalArgumentException("URL could not be converted to a File: " + uRL);
            }
            fileArray[i2] = FileUtils.toFile(uRL);
        }
        return fileArray;
    }

    public static URL[] toURLs(File[] fileArray) {
        URL[] uRLArray = new URL[fileArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            uRLArray[i2] = fileArray[i2].toURI().toURL();
        }
        return uRLArray;
    }

    public static void copyFileToDirectory(File file, File file2) {
        FileUtils.copyFileToDirectory(file, file2, true);
    }

    public static void copyFileToDirectory(File file, File file2, boolean bl2) {
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + file2 + "' is not a directory");
        }
        file2 = new File(file2, file.getName());
        FileUtils.copyFile(file, file2, bl2);
    }

    public static void copyFile(File file, File file2) {
        FileUtils.copyFile(file, file2, true);
    }

    public static void copyFile(File file, File file2, boolean bl2) {
        FileUtils.a(file, file2);
        if (file.isDirectory()) {
            throw new IOException("Source '" + file + "' exists but is a directory");
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException("Source '" + file + "' and destination '" + file2 + "' are the same");
        }
        File file3 = file2.getParentFile();
        if (file3 != null && !file3.mkdirs() && !file3.isDirectory()) {
            throw new IOException("Destination '" + file3 + "' directory cannot be created");
        }
        if (file2.exists() && !file2.canWrite()) {
            throw new IOException("Destination '" + file2 + "' exists but is read-only");
        }
        FileUtils.a(file, file2, bl2);
    }

    public static long copyFile(File object, OutputStream outputStream) {
        long l2;
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            l2 = IOUtils.copyLarge((InputStream)object, outputStream);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    ((FileInputStream)object).close();
                }
                throw throwable4;
            }
        }
        ((FileInputStream)object).close();
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(File file, File file2, boolean bl2) {
        FileInputStream fileInputStream;
        block32: {
            if (file2.exists() && file2.isDirectory()) {
                throw new IOException("Destination '" + file2 + "' exists but is a directory");
            }
            fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileChannel fileChannel = fileInputStream.getChannel();
                Throwable throwable2 = null;
                try {
                    FileOutputStream fileOutputStream;
                    block31: {
                        fileOutputStream = new FileOutputStream(file2);
                        Throwable throwable3 = null;
                        try {
                            FileChannel fileChannel2 = fileOutputStream.getChannel();
                            Throwable throwable4 = null;
                            try {
                                long l2;
                                long l3;
                                long l4;
                                long l5 = fileChannel.size();
                                for (long i2 = 0L; i2 < l5 && (l4 = fileChannel2.transferFrom(fileChannel, i2, l3 = (l2 = l5 - i2) > 0x1E00000L ? 0x1E00000L : l2)) != 0L; i2 += l4) {
                                }
                                if (fileChannel2 == null) break block31;
                            }
                            catch (Throwable throwable5) {
                                try {
                                    Throwable throwable6 = throwable5;
                                    throwable4 = throwable5;
                                    throw throwable6;
                                }
                                catch (Throwable throwable7) {
                                    if (fileChannel2 == null) throw throwable7;
                                    if (throwable4 == null) {
                                        fileChannel2.close();
                                        throw throwable7;
                                    }
                                    try {
                                        fileChannel2.close();
                                        throw throwable7;
                                    }
                                    catch (Throwable throwable8) {
                                        throwable4.addSuppressed(throwable8);
                                        throw throwable7;
                                    }
                                }
                            }
                            fileChannel2.close();
                        }
                        catch (Throwable throwable9) {
                            try {
                                Throwable throwable10 = throwable9;
                                throwable3 = throwable9;
                                throw throwable10;
                            }
                            catch (Throwable throwable11) {
                                if (throwable3 == null) {
                                    fileOutputStream.close();
                                    throw throwable11;
                                }
                                try {
                                    fileOutputStream.close();
                                    throw throwable11;
                                }
                                catch (Throwable throwable12) {
                                    throwable3.addSuppressed(throwable12);
                                    throw throwable11;
                                }
                            }
                        }
                    }
                    fileOutputStream.close();
                    if (fileChannel == null) break block32;
                }
                catch (Throwable throwable13) {
                    try {
                        Throwable throwable14 = throwable13;
                        throwable2 = throwable13;
                        throw throwable14;
                    }
                    catch (Throwable throwable15) {
                        if (fileChannel == null) throw throwable15;
                        if (throwable2 == null) {
                            fileChannel.close();
                            throw throwable15;
                        }
                        try {
                            fileChannel.close();
                            throw throwable15;
                        }
                        catch (Throwable throwable16) {
                            throwable2.addSuppressed(throwable16);
                            throw throwable15;
                        }
                    }
                }
                fileChannel.close();
            }
            catch (Throwable throwable17) {
                try {
                    Throwable throwable18 = throwable17;
                    throwable = throwable17;
                    throw throwable18;
                }
                catch (Throwable throwable19) {
                    if (throwable == null) {
                        fileInputStream.close();
                        throw throwable19;
                    }
                    try {
                        fileInputStream.close();
                        throw throwable19;
                    }
                    catch (Throwable throwable20) {
                        throwable.addSuppressed(throwable20);
                        throw throwable19;
                    }
                }
            }
        }
        fileInputStream.close();
        long l6 = file.length();
        long l7 = file2.length();
        if (l6 == l7) {
            if (!bl2) return;
            file2.setLastModified(file.lastModified());
            return;
        }
        throw new IOException("Failed to copy full contents from '" + file + "' to '" + file2 + "' Expected length: " + l6 + " Actual: " + l7);
    }

    public static void copyDirectoryToDirectory(File file, File file2) {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException("Source '" + file2 + "' is not a directory");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + file2 + "' is not a directory");
        }
        FileUtils.copyDirectory(file, new File(file2, file.getName()), true);
    }

    public static void copyDirectory(File file, File file2) {
        FileUtils.copyDirectory(file, file2, true);
    }

    public static void copyDirectory(File file, File file2, boolean bl2) {
        FileUtils.copyDirectory(file, file2, null, bl2);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter) {
        FileUtils.copyDirectory(file, file2, fileFilter, true);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter, boolean bl2) {
        File[] fileArray;
        FileUtils.a(file, file2);
        if (!file.isDirectory()) {
            throw new IOException("Source '" + file + "' exists but is not a directory");
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            throw new IOException("Source '" + file + "' and destination '" + file2 + "' are the same");
        }
        ArrayList<String> arrayList = null;
        if (file2.getCanonicalPath().startsWith(file.getCanonicalPath()) && (fileArray = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter)) != null && fileArray.length > 0) {
            arrayList = new ArrayList<String>(fileArray.length);
            for (File file3 : fileArray) {
                file3 = new File(file2, file3.getName());
                arrayList.add(file3.getCanonicalPath());
            }
        }
        FileUtils.a(file, file2, fileFilter, bl2, arrayList);
    }

    private static void a(File file, File file2) {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
    }

    private static void a(File file, File file2, FileFilter fileFilter, boolean bl2, List<String> list) {
        File[] fileArray = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter);
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new IOException("Destination '" + file2 + "' exists but is not a directory");
            }
        } else if (!file2.mkdirs() && !file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' directory cannot be created");
        }
        if (!file2.canWrite()) {
            throw new IOException("Destination '" + file2 + "' cannot be written to");
        }
        for (File file3 : fileArray) {
            File file4 = new File(file2, file3.getName());
            if (list != null && list.contains(file3.getCanonicalPath())) continue;
            if (file3.isDirectory()) {
                FileUtils.a(file3, file4, fileFilter, bl2, list);
                continue;
            }
            FileUtils.a(file3, file4, bl2);
        }
        if (bl2) {
            file2.setLastModified(file.lastModified());
        }
    }

    public static void copyURLToFile(URL uRL, File file) {
        FileUtils.copyInputStreamToFile(uRL.openStream(), file);
    }

    public static void copyURLToFile(URL object, File file, int n2, int n3) {
        object = ((URL)object).openConnection();
        ((URLConnection)object).setConnectTimeout(n2);
        ((URLConnection)object).setReadTimeout(n3);
        FileUtils.copyInputStreamToFile(((URLConnection)object).getInputStream(), file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyInputStreamToFile(InputStream inputStream, File serializable) {
        Throwable throwable = null;
        try {
            FileUtils.copyToFile(inputStream, serializable);
            if (inputStream == null) return;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (inputStream == null) throw throwable4;
                if (throwable != null) {
                    try {
                        inputStream.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    inputStream.close();
                }
                throw throwable4;
            }
        }
        inputStream.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyToFile(InputStream inputStream, File object) {
        Throwable throwable = null;
        try {
            block14: {
                object = FileUtils.openOutputStream((File)object);
                Throwable throwable2 = null;
                try {
                    IOUtils.copy(inputStream, (OutputStream)object);
                    if (object == null) break block14;
                }
                catch (Throwable throwable3) {
                    try {
                        Throwable throwable4 = throwable3;
                        throwable2 = throwable3;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (object == null) throw throwable5;
                        if (throwable2 == null) {
                            ((OutputStream)object).close();
                            throw throwable5;
                        }
                        try {
                            ((OutputStream)object).close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                }
                ((OutputStream)object).close();
            }
            if (inputStream == null) return;
        }
        catch (Throwable throwable7) {
            try {
                object = throwable7;
                throwable = throwable7;
                throw object;
            }
            catch (Throwable throwable8) {
                if (inputStream == null) throw throwable8;
                if (throwable == null) {
                    inputStream.close();
                    throw throwable8;
                }
                try {
                    inputStream.close();
                    throw throwable8;
                }
                catch (Throwable throwable9) {
                    throwable.addSuppressed(throwable9);
                    throw throwable8;
                }
            }
        }
        inputStream.close();
    }

    public static void copyToDirectory(File file, File file2) {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file.isFile()) {
            FileUtils.copyFileToDirectory(file, file2);
            return;
        }
        if (file.isDirectory()) {
            FileUtils.copyDirectoryToDirectory(file, file2);
            return;
        }
        throw new IOException("The source " + file + " does not exist");
    }

    public static void copyToDirectory(Iterable<File> object, File file) {
        if (object == null) {
            throw new NullPointerException("Sources must not be null");
        }
        object = object.iterator();
        while (object.hasNext()) {
            File file2 = (File)object.next();
            FileUtils.copyFileToDirectory(file2, file);
        }
    }

    public static void deleteDirectory(File object) {
        if (!((File)object).exists()) {
            return;
        }
        if (!FileUtils.isSymlink((File)object)) {
            FileUtils.cleanDirectory((File)object);
        }
        if (!((File)object).delete()) {
            object = "Unable to delete directory " + object + ".";
            throw new IOException((String)object);
        }
    }

    public static boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileUtils.cleanDirectory(file);
            }
        }
        catch (Exception exception) {}
        try {
            return file.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean directoryContains(File object, File object2) {
        if (object == null) {
            throw new IllegalArgumentException("Directory must not be null");
        }
        if (!((File)object).isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + object);
        }
        if (object2 == null) {
            return false;
        }
        if (!((File)object).exists() || !((File)object2).exists()) {
            return false;
        }
        object = ((File)object).getCanonicalPath();
        object2 = ((File)object2).getCanonicalPath();
        return FilenameUtils.directoryContains((String)object, (String)object2);
    }

    public static void cleanDirectory(File fileArray) {
        fileArray = FileUtils.a((File)fileArray);
        IOException iOException = null;
        for (File file : fileArray) {
            try {
                FileUtils.forceDelete(file);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    private static File[] a(File file) {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new IOException("Failed to list contents of " + file);
        }
        return fileArray;
    }

    public static boolean waitFor(File file, int n2) {
        long l2 = System.currentTimeMillis() + (long)n2 * 1000L;
        n2 = 0;
        try {
            while (!file.exists()) {
                long l3 = l2 - System.currentTimeMillis();
                if (l3 < 0L) {
                    return false;
                }
                try {
                    Thread.sleep(Math.min(100L, l3));
                }
                catch (InterruptedException interruptedException) {
                    n2 = 1;
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
        finally {
            if (n2 != 0) {
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    public static String readFileToString(File object, Charset object2) {
        block9: {
            object = FileUtils.openInputStream((File)object);
            Throwable throwable = null;
            try {
                object2 = IOUtils.toString((InputStream)object, Charsets.toCharset((Charset)object2));
                if (object == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object2 = throwable2;
                    throwable = throwable2;
                    throw object2;
                }
                catch (Throwable throwable3) {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                    throw throwable3;
                }
            }
            ((InputStream)object).close();
        }
        return object2;
    }

    public static String readFileToString(File file, String string) {
        return FileUtils.readFileToString(file, Charsets.toCharset(string));
    }

    @Deprecated
    public static String readFileToString(File file) {
        return FileUtils.readFileToString(file, Charset.defaultCharset());
    }

    public static byte[] readFileToByteArray(File object) {
        block9: {
            FileInputStream fileInputStream = FileUtils.openInputStream((File)object);
            Throwable throwable = null;
            try {
                long l2 = ((File)object).length();
                object = l2 > 0L ? IOUtils.toByteArray((InputStream)fileInputStream, l2) : IOUtils.toByteArray(fileInputStream);
                if (fileInputStream == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (fileInputStream != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)fileInputStream).close();
                        }
                    }
                    throw throwable4;
                }
            }
            ((InputStream)fileInputStream).close();
        }
        return object;
    }

    public static List<String> readLines(File object, Charset list) {
        block9: {
            object = FileUtils.openInputStream((File)object);
            Throwable throwable = null;
            try {
                list = IOUtils.readLines((InputStream)object, Charsets.toCharset((Charset)((Object)list)));
                if (object == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    list = throwable2;
                    throwable = throwable2;
                    throw list;
                }
                catch (Throwable throwable3) {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                    throw throwable3;
                }
            }
            ((InputStream)object).close();
        }
        return list;
    }

    public static List<String> readLines(File file, String string) {
        return FileUtils.readLines(file, Charsets.toCharset(string));
    }

    @Deprecated
    public static List<String> readLines(File file) {
        return FileUtils.readLines(file, Charset.defaultCharset());
    }

    public static LineIterator lineIterator(File file, String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(file);
            return IOUtils.lineIterator((InputStream)fileInputStream, string);
        }
        catch (IOException | RuntimeException exception) {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException iOException) {
                exception.addSuppressed(iOException);
            }
            throw exception;
        }
    }

    public static LineIterator lineIterator(File file) {
        return FileUtils.lineIterator(file, null);
    }

    public static void writeStringToFile(File file, String string, Charset charset) {
        FileUtils.writeStringToFile(file, string, charset, false);
    }

    public static void writeStringToFile(File file, String string, String string2) {
        FileUtils.writeStringToFile(file, string, string2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeStringToFile(File object, String object2, Charset charset, boolean bl2) {
        object = FileUtils.openOutputStream((File)object, bl2);
        Throwable throwable = null;
        try {
            IOUtils.write((String)object2, (OutputStream)object, charset);
            if (object == null) return;
        }
        catch (Throwable throwable2) {
            try {
                object2 = throwable2;
                throwable = throwable2;
                throw object2;
            }
            catch (Throwable throwable3) {
                if (object == null) throw throwable3;
                if (throwable != null) {
                    try {
                        ((OutputStream)object).close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable3;
                } else {
                    ((OutputStream)object).close();
                }
                throw throwable3;
            }
        }
        ((OutputStream)object).close();
        return;
    }

    public static void writeStringToFile(File file, String string, String string2, boolean bl2) {
        FileUtils.writeStringToFile(file, string, Charsets.toCharset(string2), bl2);
    }

    @Deprecated
    public static void writeStringToFile(File file, String string) {
        FileUtils.writeStringToFile(file, string, Charset.defaultCharset(), false);
    }

    @Deprecated
    public static void writeStringToFile(File file, String string, boolean bl2) {
        FileUtils.writeStringToFile(file, string, Charset.defaultCharset(), bl2);
    }

    @Deprecated
    public static void write(File file, CharSequence charSequence) {
        FileUtils.write(file, charSequence, Charset.defaultCharset(), false);
    }

    @Deprecated
    public static void write(File file, CharSequence charSequence, boolean bl2) {
        FileUtils.write(file, charSequence, Charset.defaultCharset(), bl2);
    }

    public static void write(File file, CharSequence charSequence, Charset charset) {
        FileUtils.write(file, charSequence, charset, false);
    }

    public static void write(File file, CharSequence charSequence, String string) {
        FileUtils.write(file, charSequence, string, false);
    }

    public static void write(File file, CharSequence charSequence, Charset charset, boolean bl2) {
        charSequence = charSequence == null ? null : charSequence.toString();
        FileUtils.writeStringToFile(file, (String)charSequence, charset, bl2);
    }

    public static void write(File file, CharSequence charSequence, String string, boolean bl2) {
        FileUtils.write(file, charSequence, Charsets.toCharset(string), bl2);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray) {
        FileUtils.writeByteArrayToFile(file, byArray, false);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, boolean bl2) {
        FileUtils.writeByteArrayToFile(file, byArray, 0, byArray.length, bl2);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, int n2, int n3) {
        FileUtils.writeByteArrayToFile(file, byArray, n2, n3, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeByteArrayToFile(File object, byte[] object2, int n2, int n3, boolean bl2) {
        void var4_7;
        object = FileUtils.openOutputStream((File)object, (boolean)var4_7);
        Throwable throwable = null;
        try {
            void var3_6;
            void var2_5;
            ((OutputStream)object).write((byte[])object2, (int)var2_5, (int)var3_6);
            if (object == null) return;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (object == null) throw throwable4;
                if (throwable != null) {
                    try {
                        ((OutputStream)object).close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    ((OutputStream)object).close();
                }
                throw throwable4;
            }
        }
        ((OutputStream)object).close();
        return;
    }

    public static void writeLines(File file, String string, Collection<?> collection) {
        FileUtils.writeLines(file, string, collection, null, false);
    }

    public static void writeLines(File file, String string, Collection<?> collection, boolean bl2) {
        FileUtils.writeLines(file, string, collection, null, bl2);
    }

    public static void writeLines(File file, Collection<?> collection) {
        FileUtils.writeLines(file, null, collection, null, false);
    }

    public static void writeLines(File file, Collection<?> collection, boolean bl2) {
        FileUtils.writeLines(file, null, collection, null, bl2);
    }

    public static void writeLines(File file, String string, Collection<?> collection, String string2) {
        FileUtils.writeLines(file, string, collection, string2, false);
    }

    public static void writeLines(File object, String object2, Collection<?> collection, String string, boolean bl2) {
        object = new BufferedOutputStream(FileUtils.openOutputStream((File)object, bl2));
        Throwable throwable = null;
        try {
            IOUtils.writeLines(collection, string, (OutputStream)object, (String)object2);
        }
        catch (Throwable throwable2) {
            try {
                object2 = throwable2;
                throwable = throwable2;
                throw object2;
            }
            catch (Throwable throwable3) {
                if (throwable != null) {
                    try {
                        ((OutputStream)object).close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    ((OutputStream)object).close();
                }
                throw throwable3;
            }
        }
        ((OutputStream)object).close();
        return;
    }

    public static void writeLines(File file, Collection<?> collection, String string) {
        FileUtils.writeLines(file, null, collection, string, false);
    }

    public static void writeLines(File file, Collection<?> collection, String string, boolean bl2) {
        FileUtils.writeLines(file, null, collection, string, bl2);
    }

    public static void forceDelete(File object) {
        if (((File)object).isDirectory()) {
            FileUtils.deleteDirectory((File)object);
            return;
        }
        boolean bl2 = ((File)object).exists();
        if (!((File)object).delete()) {
            if (!bl2) {
                throw new FileNotFoundException("File does not exist: " + object);
            }
            object = "Unable to delete file: " + object;
            throw new IOException((String)object);
        }
    }

    public static void forceDeleteOnExit(File file) {
        if (file.isDirectory()) {
            if (file.exists()) {
                file.deleteOnExit();
                if (!FileUtils.isSymlink(file)) {
                    FileUtils.b(file);
                }
            }
            return;
        }
        file.deleteOnExit();
    }

    private static void b(File fileArray) {
        fileArray = FileUtils.a((File)fileArray);
        IOException iOException = null;
        for (File file : fileArray) {
            try {
                FileUtils.forceDeleteOnExit(file);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public static void forceMkdir(File object) {
        if (((File)object).exists()) {
            if (!((File)object).isDirectory()) {
                object = "File " + object + " exists and is not a directory. Unable to create directory.";
                throw new IOException((String)object);
            }
        } else if (!((File)object).mkdirs() && !((File)object).isDirectory()) {
            object = "Unable to create directory " + object;
            throw new IOException((String)object);
        }
    }

    public static void forceMkdirParent(File file) {
        if ((file = file.getParentFile()) == null) {
            return;
        }
        FileUtils.forceMkdir(file);
    }

    public static long sizeOf(File object) {
        if (!((File)object).exists()) {
            object = object + " does not exist";
            throw new IllegalArgumentException((String)object);
        }
        if (((File)object).isDirectory()) {
            return FileUtils.c((File)object);
        }
        return ((File)object).length();
    }

    public static BigInteger sizeOfAsBigInteger(File object) {
        if (!((File)object).exists()) {
            object = object + " does not exist";
            throw new IllegalArgumentException((String)object);
        }
        if (((File)object).isDirectory()) {
            return FileUtils.d((File)object);
        }
        return BigInteger.valueOf(((File)object).length());
    }

    public static long sizeOfDirectory(File file) {
        FileUtils.e(file);
        return FileUtils.c(file);
    }

    private static long c(File fileArray) {
        if ((fileArray = fileArray.listFiles()) == null) {
            return 0L;
        }
        long l2 = 0L;
        for (File file : fileArray) {
            try {
                if (FileUtils.isSymlink(file) || (l2 += file.isDirectory() ? FileUtils.c(file) : file.length()) >= 0L) continue;
                break;
            }
            catch (IOException iOException) {}
        }
        return l2;
    }

    public static BigInteger sizeOfDirectoryAsBigInteger(File file) {
        FileUtils.e(file);
        return FileUtils.d(file);
    }

    private static BigInteger d(File fileArray) {
        if ((fileArray = fileArray.listFiles()) == null) {
            return BigInteger.ZERO;
        }
        BigInteger bigInteger = BigInteger.ZERO;
        for (File file : fileArray) {
            try {
                if (FileUtils.isSymlink(file)) continue;
                bigInteger = bigInteger.add(file.isDirectory() ? FileUtils.d(file) : BigInteger.valueOf(file.length()));
            }
            catch (IOException iOException) {}
        }
        return bigInteger;
    }

    private static void e(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory");
        }
    }

    public static boolean isFileNewer(File file, File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("No specified reference file");
        }
        if (!file2.exists()) {
            throw new IllegalArgumentException("The reference file '" + file2 + "' doesn't exist");
        }
        return FileUtils.isFileNewer(file, file2.lastModified());
    }

    public static boolean isFileNewer(File file, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("No specified date");
        }
        return FileUtils.isFileNewer(file, date.getTime());
    }

    public static boolean isFileNewer(File file, long l2) {
        if (file == null) {
            throw new IllegalArgumentException("No specified file");
        }
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() > l2;
    }

    public static boolean isFileOlder(File file, File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("No specified reference file");
        }
        if (!file2.exists()) {
            throw new IllegalArgumentException("The reference file '" + file2 + "' doesn't exist");
        }
        return FileUtils.isFileOlder(file, file2.lastModified());
    }

    public static boolean isFileOlder(File file, Date date) {
        if (date == null) {
            throw new IllegalArgumentException("No specified date");
        }
        return FileUtils.isFileOlder(file, date.getTime());
    }

    public static boolean isFileOlder(File file, long l2) {
        if (file == null) {
            throw new IllegalArgumentException("No specified file");
        }
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() < l2;
    }

    public static long checksumCRC32(File file) {
        CRC32 cRC32 = new CRC32();
        FileUtils.checksum(file, cRC32);
        return cRC32.getValue();
    }

    public static Checksum checksum(File object, Checksum object2) {
        if (((File)object).isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        object = new CheckedInputStream(new FileInputStream((File)object), (Checksum)object2);
        Throwable throwable = null;
        try {
            IOUtils.copy((InputStream)object, (OutputStream)new NullOutputStream());
        }
        catch (Throwable throwable2) {
            try {
                object2 = throwable2;
                throwable = throwable2;
                throw object2;
            }
            catch (Throwable throwable3) {
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    ((InputStream)object).close();
                }
                throw throwable3;
            }
        }
        ((InputStream)object).close();
        return object2;
    }

    public static void moveDirectory(File file, File file2) {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
        if (!file.isDirectory()) {
            throw new IOException("Source '" + file + "' is not a directory");
        }
        if (file2.exists()) {
            throw new FileExistsException("Destination '" + file2 + "' already exists");
        }
        boolean bl2 = file.renameTo(file2);
        if (!bl2) {
            if (file2.getCanonicalPath().startsWith(file.getCanonicalPath() + File.separator)) {
                throw new IOException("Cannot move directory: " + file + " to a subdirectory of itself: " + file2);
            }
            FileUtils.copyDirectory(file, file2);
            FileUtils.deleteDirectory(file);
            if (file.exists()) {
                throw new IOException("Failed to delete original directory '" + file + "' after copy to '" + file2 + "'");
            }
        }
    }

    public static void moveDirectoryToDirectory(File file, File file2, boolean bl2) {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination directory must not be null");
        }
        if (!file2.exists() && bl2) {
            file2.mkdirs();
        }
        if (!file2.exists()) {
            throw new FileNotFoundException("Destination directory '" + file2 + "' does not exist [createDestDir=" + bl2 + "]");
        }
        if (!file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' is not a directory");
        }
        FileUtils.moveDirectory(file, new File(file2, file.getName()));
    }

    public static void moveFile(File file, File file2) {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
        if (file.isDirectory()) {
            throw new IOException("Source '" + file + "' is a directory");
        }
        if (file2.exists()) {
            throw new FileExistsException("Destination '" + file2 + "' already exists");
        }
        if (file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' is a directory");
        }
        boolean bl2 = file.renameTo(file2);
        if (!bl2) {
            FileUtils.copyFile(file, file2);
            if (!file.delete()) {
                FileUtils.deleteQuietly(file2);
                throw new IOException("Failed to delete original file '" + file + "' after copy to '" + file2 + "'");
            }
        }
    }

    public static void moveFileToDirectory(File file, File file2, boolean bl2) {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination directory must not be null");
        }
        if (!file2.exists() && bl2) {
            file2.mkdirs();
        }
        if (!file2.exists()) {
            throw new FileNotFoundException("Destination directory '" + file2 + "' does not exist [createDestDir=" + bl2 + "]");
        }
        if (!file2.isDirectory()) {
            throw new IOException("Destination '" + file2 + "' is not a directory");
        }
        FileUtils.moveFile(file, new File(file2, file.getName()));
    }

    public static void moveToDirectory(File file, File file2, boolean bl2) {
        if (file == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
        if (file.isDirectory()) {
            FileUtils.moveDirectoryToDirectory(file, file2, bl2);
            return;
        }
        FileUtils.moveFileToDirectory(file, file2, bl2);
    }

    public static boolean isSymlink(File file) {
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        return Files.isSymbolicLink(file.toPath());
    }
}

