/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.OutputStream;
import java.nio.charset.Charset;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] b = new int[]{28, 24, 20, 16, 12, 8, 4, 0};

    public static void dump(byte[] byArray, long l2, OutputStream outputStream, int n2) {
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + n2 + " into array of length " + byArray.length);
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long l3 = l2 + (long)n2;
        StringBuilder stringBuilder = new StringBuilder(74);
        for (int i2 = n2; i2 < byArray.length; i2 += 16) {
            int n3;
            n2 = byArray.length - i2;
            if (n2 > 16) {
                n2 = 16;
            }
            long l4 = l3;
            StringBuilder stringBuilder2 = stringBuilder;
            for (n3 = 0; n3 < 8; ++n3) {
                stringBuilder2.append(a[(int)(l4 >> b[n3]) & 0xF]);
            }
            stringBuilder2.append(' ');
            for (n3 = 0; n3 < 16; ++n3) {
                if (n3 < n2) {
                    byte by = byArray[n3 + i2];
                    stringBuilder2 = stringBuilder;
                    for (int i3 = 0; i3 < 2; ++i3) {
                        stringBuilder2.append(a[by >> b[i3 + 6] & 0xF]);
                    }
                } else {
                    stringBuilder.append("  ");
                }
                stringBuilder.append(' ');
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (byArray[n3 + i2] >= 32 && byArray[n3 + i2] < 127) {
                    stringBuilder.append((char)byArray[n3 + i2]);
                    continue;
                }
                stringBuilder.append('.');
            }
            stringBuilder.append(EOL);
            outputStream.write(stringBuilder.toString().getBytes(Charset.defaultCharset()));
            outputStream.flush();
            stringBuilder.setLength(0);
            l3 += (long)n2;
        }
    }
}

